/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteSnapshotHttpRequest;
import com.google.cloud.compute.v1.GetSnapshotHttpRequest;
import com.google.cloud.compute.v1.ListSnapshotsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetLabelsSnapshotHttpRequest;
import com.google.cloud.compute.v1.Snapshot;
import com.google.cloud.compute.v1.SnapshotClient;
import com.google.cloud.compute.v1.SnapshotList;
import com.google.cloud.compute.v1.stub.HttpJsonSnapshotStub;
import com.google.cloud.compute.v1.stub.SnapshotStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SnapshotStubSettings
extends StubSettings<SnapshotStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteSnapshotHttpRequest, Operation> deleteSnapshotSettings;
    private final UnaryCallSettings<GetSnapshotHttpRequest, Snapshot> getSnapshotSettings;
    private final PagedCallSettings<ListSnapshotsHttpRequest, SnapshotList, SnapshotClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
    private final UnaryCallSettings<SetLabelsSnapshotHttpRequest, Operation> setLabelsSnapshotSettings;
    private static final PagedListDescriptor<ListSnapshotsHttpRequest, SnapshotList, Snapshot> LIST_SNAPSHOTS_PAGE_STR_DESC = new PagedListDescriptor<ListSnapshotsHttpRequest, SnapshotList, Snapshot>(){

        public String emptyToken() {
            return "";
        }

        public ListSnapshotsHttpRequest injectToken(ListSnapshotsHttpRequest payload, String token) {
            return ListSnapshotsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListSnapshotsHttpRequest injectPageSize(ListSnapshotsHttpRequest payload, int pageSize) {
            return ListSnapshotsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListSnapshotsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SnapshotList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Snapshot> extractResources(SnapshotList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListSnapshotsHttpRequest, SnapshotList, SnapshotClient.ListSnapshotsPagedResponse> LIST_SNAPSHOTS_PAGE_STR_FACT = new PagedListResponseFactory<ListSnapshotsHttpRequest, SnapshotList, SnapshotClient.ListSnapshotsPagedResponse>(){

        public ApiFuture<SnapshotClient.ListSnapshotsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSnapshotsHttpRequest, SnapshotList> callable, ListSnapshotsHttpRequest request, ApiCallContext context, ApiFuture<SnapshotList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SNAPSHOTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SnapshotClient.ListSnapshotsPagedResponse.createAsync((PageContext<ListSnapshotsHttpRequest, SnapshotList, Snapshot>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteSnapshotHttpRequest, Operation> deleteSnapshotSettings() {
        return this.deleteSnapshotSettings;
    }

    public UnaryCallSettings<GetSnapshotHttpRequest, Snapshot> getSnapshotSettings() {
        return this.getSnapshotSettings;
    }

    public PagedCallSettings<ListSnapshotsHttpRequest, SnapshotList, SnapshotClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
        return this.listSnapshotsSettings;
    }

    public UnaryCallSettings<SetLabelsSnapshotHttpRequest, Operation> setLabelsSnapshotSettings() {
        return this.setLabelsSnapshotSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SnapshotStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSnapshotStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SnapshotStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SnapshotStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SnapshotStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSnapshotSettings = settingsBuilder.deleteSnapshotSettings().build();
        this.getSnapshotSettings = settingsBuilder.getSnapshotSettings().build();
        this.listSnapshotsSettings = settingsBuilder.listSnapshotsSettings().build();
        this.setLabelsSnapshotSettings = settingsBuilder.setLabelsSnapshotSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SnapshotStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteSnapshotHttpRequest, Operation> deleteSnapshotSettings;
        private final UnaryCallSettings.Builder<GetSnapshotHttpRequest, Snapshot> getSnapshotSettings;
        private final PagedCallSettings.Builder<ListSnapshotsHttpRequest, SnapshotList, SnapshotClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
        private final UnaryCallSettings.Builder<SetLabelsSnapshotHttpRequest, Operation> setLabelsSnapshotSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSnapshotsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SNAPSHOTS_PAGE_STR_FACT);
            this.setLabelsSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSnapshotSettings, this.getSnapshotSettings, this.listSnapshotsSettings, this.setLabelsSnapshotSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SnapshotStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SnapshotStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SnapshotStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SnapshotStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSnapshotsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setLabelsSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(SnapshotStubSettings settings) {
            super((StubSettings)settings);
            this.deleteSnapshotSettings = settings.deleteSnapshotSettings.toBuilder();
            this.getSnapshotSettings = settings.getSnapshotSettings.toBuilder();
            this.listSnapshotsSettings = settings.listSnapshotsSettings.toBuilder();
            this.setLabelsSnapshotSettings = settings.setLabelsSnapshotSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSnapshotSettings, this.getSnapshotSettings, this.listSnapshotsSettings, this.setLabelsSnapshotSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteSnapshotHttpRequest, Operation> deleteSnapshotSettings() {
            return this.deleteSnapshotSettings;
        }

        public UnaryCallSettings.Builder<GetSnapshotHttpRequest, Snapshot> getSnapshotSettings() {
            return this.getSnapshotSettings;
        }

        public PagedCallSettings.Builder<ListSnapshotsHttpRequest, SnapshotList, SnapshotClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
            return this.listSnapshotsSettings;
        }

        public UnaryCallSettings.Builder<SetLabelsSnapshotHttpRequest, Operation> setLabelsSnapshotSettings() {
            return this.setLabelsSnapshotSettings;
        }

        public SnapshotStubSettings build() throws IOException {
            return new SnapshotStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

