/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListDiskTypesHttpRequest;
import com.google.cloud.compute.v1.DiskType;
import com.google.cloud.compute.v1.DiskTypeAggregatedList;
import com.google.cloud.compute.v1.DiskTypeList;
import com.google.cloud.compute.v1.DiskTypeSettings;
import com.google.cloud.compute.v1.DiskTypesScopedList;
import com.google.cloud.compute.v1.GetDiskTypeHttpRequest;
import com.google.cloud.compute.v1.ListDiskTypesHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneDiskTypeName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.stub.DiskTypeStub;
import com.google.cloud.compute.v1.stub.DiskTypeStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DiskTypeClient
implements BackgroundResource {
    private final DiskTypeSettings settings;
    private final DiskTypeStub stub;

    public static final DiskTypeClient create() throws IOException {
        return DiskTypeClient.create(DiskTypeSettings.newBuilder().build());
    }

    public static final DiskTypeClient create(DiskTypeSettings settings) throws IOException {
        return new DiskTypeClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DiskTypeClient create(DiskTypeStub stub) {
        return new DiskTypeClient(stub);
    }

    protected DiskTypeClient(DiskTypeSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DiskTypeStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DiskTypeClient(DiskTypeStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DiskTypeSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DiskTypeStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListDiskTypesPagedResponse aggregatedListDiskTypes(ProjectName project) {
        AggregatedListDiskTypesHttpRequest request = AggregatedListDiskTypesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListDiskTypes(request);
    }

    @BetaApi
    public final AggregatedListDiskTypesPagedResponse aggregatedListDiskTypes(String project) {
        AggregatedListDiskTypesHttpRequest request = AggregatedListDiskTypesHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListDiskTypes(request);
    }

    @BetaApi
    public final AggregatedListDiskTypesPagedResponse aggregatedListDiskTypes(AggregatedListDiskTypesHttpRequest request) {
        return (AggregatedListDiskTypesPagedResponse)((Object)this.aggregatedListDiskTypesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListDiskTypesHttpRequest, AggregatedListDiskTypesPagedResponse> aggregatedListDiskTypesPagedCallable() {
        return this.stub.aggregatedListDiskTypesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList> aggregatedListDiskTypesCallable() {
        return this.stub.aggregatedListDiskTypesCallable();
    }

    @BetaApi
    public final DiskType getDiskType(ProjectZoneDiskTypeName diskType) {
        GetDiskTypeHttpRequest request = GetDiskTypeHttpRequest.newBuilder().setDiskType(diskType == null ? null : diskType.toString()).build();
        return this.getDiskType(request);
    }

    @BetaApi
    public final DiskType getDiskType(String diskType) {
        GetDiskTypeHttpRequest request = GetDiskTypeHttpRequest.newBuilder().setDiskType(diskType).build();
        return this.getDiskType(request);
    }

    @BetaApi
    public final DiskType getDiskType(GetDiskTypeHttpRequest request) {
        return (DiskType)this.getDiskTypeCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetDiskTypeHttpRequest, DiskType> getDiskTypeCallable() {
        return this.stub.getDiskTypeCallable();
    }

    @BetaApi
    public final ListDiskTypesPagedResponse listDiskTypes(ProjectZoneName zone) {
        ListDiskTypesHttpRequest request = ListDiskTypesHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listDiskTypes(request);
    }

    @BetaApi
    public final ListDiskTypesPagedResponse listDiskTypes(String zone) {
        ListDiskTypesHttpRequest request = ListDiskTypesHttpRequest.newBuilder().setZone(zone).build();
        return this.listDiskTypes(request);
    }

    @BetaApi
    public final ListDiskTypesPagedResponse listDiskTypes(ListDiskTypesHttpRequest request) {
        return (ListDiskTypesPagedResponse)((Object)this.listDiskTypesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListDiskTypesHttpRequest, ListDiskTypesPagedResponse> listDiskTypesPagedCallable() {
        return this.stub.listDiskTypesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListDiskTypesHttpRequest, DiskTypeList> listDiskTypesCallable() {
        return this.stub.listDiskTypesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDiskTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDiskTypesHttpRequest, DiskTypeList, DiskType, ListDiskTypesPage, ListDiskTypesFixedSizeCollection> {
        private ListDiskTypesFixedSizeCollection(List<ListDiskTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDiskTypesFixedSizeCollection createEmptyCollection() {
            return new ListDiskTypesFixedSizeCollection(null, 0);
        }

        protected ListDiskTypesFixedSizeCollection createCollection(List<ListDiskTypesPage> pages, int collectionSize) {
            return new ListDiskTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDiskTypesPage
    extends AbstractPage<ListDiskTypesHttpRequest, DiskTypeList, DiskType, ListDiskTypesPage> {
        private ListDiskTypesPage(PageContext<ListDiskTypesHttpRequest, DiskTypeList, DiskType> context, DiskTypeList response) {
            super(context, (Object)response);
        }

        private static ListDiskTypesPage createEmptyPage() {
            return new ListDiskTypesPage(null, null);
        }

        protected ListDiskTypesPage createPage(PageContext<ListDiskTypesHttpRequest, DiskTypeList, DiskType> context, DiskTypeList response) {
            return new ListDiskTypesPage(context, response);
        }

        public ApiFuture<ListDiskTypesPage> createPageAsync(PageContext<ListDiskTypesHttpRequest, DiskTypeList, DiskType> context, ApiFuture<DiskTypeList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDiskTypesPagedResponse
    extends AbstractPagedListResponse<ListDiskTypesHttpRequest, DiskTypeList, DiskType, ListDiskTypesPage, ListDiskTypesFixedSizeCollection> {
        public static ApiFuture<ListDiskTypesPagedResponse> createAsync(PageContext<ListDiskTypesHttpRequest, DiskTypeList, DiskType> context, ApiFuture<DiskTypeList> futureResponse) {
            ApiFuture<ListDiskTypesPage> futurePage = ListDiskTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListDiskTypesPage, ListDiskTypesPagedResponse>(){

                public ListDiskTypesPagedResponse apply(ListDiskTypesPage input) {
                    return new ListDiskTypesPagedResponse(input);
                }
            });
        }

        private ListDiskTypesPagedResponse(ListDiskTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDiskTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListDiskTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypesScopedList, AggregatedListDiskTypesPage, AggregatedListDiskTypesFixedSizeCollection> {
        private AggregatedListDiskTypesFixedSizeCollection(List<AggregatedListDiskTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListDiskTypesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListDiskTypesFixedSizeCollection(null, 0);
        }

        protected AggregatedListDiskTypesFixedSizeCollection createCollection(List<AggregatedListDiskTypesPage> pages, int collectionSize) {
            return new AggregatedListDiskTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListDiskTypesPage
    extends AbstractPage<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypesScopedList, AggregatedListDiskTypesPage> {
        private AggregatedListDiskTypesPage(PageContext<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypesScopedList> context, DiskTypeAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListDiskTypesPage createEmptyPage() {
            return new AggregatedListDiskTypesPage(null, null);
        }

        protected AggregatedListDiskTypesPage createPage(PageContext<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypesScopedList> context, DiskTypeAggregatedList response) {
            return new AggregatedListDiskTypesPage(context, response);
        }

        public ApiFuture<AggregatedListDiskTypesPage> createPageAsync(PageContext<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypesScopedList> context, ApiFuture<DiskTypeAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListDiskTypesPagedResponse
    extends AbstractPagedListResponse<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypesScopedList, AggregatedListDiskTypesPage, AggregatedListDiskTypesFixedSizeCollection> {
        public static ApiFuture<AggregatedListDiskTypesPagedResponse> createAsync(PageContext<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypesScopedList> context, ApiFuture<DiskTypeAggregatedList> futureResponse) {
            ApiFuture<AggregatedListDiskTypesPage> futurePage = AggregatedListDiskTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListDiskTypesPage, AggregatedListDiskTypesPagedResponse>(){

                public AggregatedListDiskTypesPagedResponse apply(AggregatedListDiskTypesPage input) {
                    return new AggregatedListDiskTypesPagedResponse(input);
                }
            });
        }

        private AggregatedListDiskTypesPagedResponse(AggregatedListDiskTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListDiskTypesFixedSizeCollection.createEmptyCollection());
        }
    }
}

