/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Firewall;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class UpdateFirewallHttpRequest
implements ApiMessage {
    private final String access_token;
    private final String callback;
    private final List<String> fieldMask;
    private final String fields;
    private final String firewall;
    private final Firewall firewallResource;
    private final String key;
    private final String prettyPrint;
    private final String quotaUser;
    private final String requestId;
    private final String userIp;
    private static final UpdateFirewallHttpRequest DEFAULT_INSTANCE = new UpdateFirewallHttpRequest();

    private UpdateFirewallHttpRequest() {
        this.access_token = null;
        this.callback = null;
        this.fieldMask = null;
        this.fields = null;
        this.firewall = null;
        this.firewallResource = null;
        this.key = null;
        this.prettyPrint = null;
        this.quotaUser = null;
        this.requestId = null;
        this.userIp = null;
    }

    private UpdateFirewallHttpRequest(String access_token, String callback, List<String> fieldMask, String fields, String firewall, Firewall firewallResource, String key, String prettyPrint, String quotaUser, String requestId, String userIp) {
        this.access_token = access_token;
        this.callback = callback;
        this.fieldMask = fieldMask;
        this.fields = fields;
        this.firewall = firewall;
        this.firewallResource = firewallResource;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.quotaUser = quotaUser;
        this.requestId = requestId;
        this.userIp = userIp;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("access_token")) {
            return this.access_token;
        }
        if (fieldName.equals("callback")) {
            return this.callback;
        }
        if (fieldName.equals("fieldMask")) {
            return this.fieldMask;
        }
        if (fieldName.equals("fields")) {
            return this.fields;
        }
        if (fieldName.equals("firewall")) {
            return this.firewall;
        }
        if (fieldName.equals("firewallResource")) {
            return this.firewallResource;
        }
        if (fieldName.equals("key")) {
            return this.key;
        }
        if (fieldName.equals("prettyPrint")) {
            return this.prettyPrint;
        }
        if (fieldName.equals("quotaUser")) {
            return this.quotaUser;
        }
        if (fieldName.equals("requestId")) {
            return this.requestId;
        }
        if (fieldName.equals("userIp")) {
            return this.userIp;
        }
        return null;
    }

    @Nullable
    public Firewall getApiMessageRequestBody() {
        return this.firewallResource;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getCallback() {
        return this.callback;
    }

    public List<String> getFieldMask() {
        return this.fieldMask;
    }

    public String getFields() {
        return this.fields;
    }

    public String getFirewall() {
        return this.firewall;
    }

    public Firewall getFirewallResource() {
        return this.firewallResource;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(UpdateFirewallHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static UpdateFirewallHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "UpdateFirewallHttpRequest{access_token=" + this.access_token + ", callback=" + this.callback + ", fieldMask=" + this.fieldMask + ", fields=" + this.fields + ", firewall=" + this.firewall + ", firewallResource=" + this.firewallResource + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", quotaUser=" + this.quotaUser + ", requestId=" + this.requestId + ", userIp=" + this.userIp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UpdateFirewallHttpRequest) {
            UpdateFirewallHttpRequest that = (UpdateFirewallHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.fieldMask, that.getFieldMask()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.firewall, that.getFirewall()) && Objects.equals(this.firewallResource, that.getFirewallResource()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.requestId, that.getRequestId()) && Objects.equals(this.userIp, that.getUserIp());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.callback, this.fieldMask, this.fields, this.firewall, this.firewallResource, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.userIp);
    }

    public static class Builder {
        private String access_token;
        private String callback;
        private List<String> fieldMask;
        private String fields;
        private String firewall;
        private Firewall firewallResource;
        private String key;
        private String prettyPrint;
        private String quotaUser;
        private String requestId;
        private String userIp;

        Builder() {
        }

        public Builder mergeFrom(UpdateFirewallHttpRequest other) {
            if (other == UpdateFirewallHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getFieldMask() != null) {
                this.fieldMask = other.fieldMask;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getFirewall() != null) {
                this.firewall = other.firewall;
            }
            if (other.getFirewallResource() != null) {
                this.firewallResource = other.firewallResource;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getRequestId() != null) {
                this.requestId = other.requestId;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            return this;
        }

        Builder(UpdateFirewallHttpRequest source) {
            this.access_token = source.access_token;
            this.callback = source.callback;
            this.fieldMask = source.fieldMask;
            this.fields = source.fields;
            this.firewall = source.firewall;
            this.firewallResource = source.firewallResource;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.quotaUser = source.quotaUser;
            this.requestId = source.requestId;
            this.userIp = source.userIp;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public List<String> getFieldMask() {
            return this.fieldMask;
        }

        public Builder addAllFieldMask(List<String> fieldMask) {
            if (this.fieldMask == null) {
                this.fieldMask = new LinkedList<String>();
            }
            this.fieldMask.addAll(fieldMask);
            return this;
        }

        public Builder addFieldMask(String fieldMask) {
            if (this.fieldMask == null) {
                this.fieldMask = new LinkedList<String>();
            }
            this.fieldMask.add(fieldMask);
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public String getFirewall() {
            return this.firewall;
        }

        public Builder setFirewall(String firewall) {
            this.firewall = firewall;
            return this;
        }

        public Firewall getFirewallResource() {
            return this.firewallResource;
        }

        public Builder setFirewallResource(Firewall firewallResource) {
            this.firewallResource = firewallResource;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public UpdateFirewallHttpRequest build() {
            String missing = "";
            if (this.fieldMask == null) {
                missing = missing + " fieldMask";
            }
            if (this.firewall == null) {
                missing = missing + " firewall";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new UpdateFirewallHttpRequest(this.access_token, this.callback, this.fieldMask, this.fields, this.firewall, this.firewallResource, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.userIp);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setCallback(this.callback);
            newBuilder.addAllFieldMask(this.fieldMask);
            newBuilder.setFields(this.fields);
            newBuilder.setFirewall(this.firewall);
            newBuilder.setFirewallResource(this.firewallResource);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setRequestId(this.requestId);
            newBuilder.setUserIp(this.userIp);
            return newBuilder;
        }
    }
}

