/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteSslPolicyHttpRequest;
import com.google.cloud.compute.v1.GetSslPolicyHttpRequest;
import com.google.cloud.compute.v1.InsertSslPolicyHttpRequest;
import com.google.cloud.compute.v1.ListAvailableFeaturesSslPoliciesHttpRequest;
import com.google.cloud.compute.v1.ListSslPoliciesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchSslPolicyHttpRequest;
import com.google.cloud.compute.v1.SslPoliciesList;
import com.google.cloud.compute.v1.SslPoliciesListAvailableFeaturesResponse;
import com.google.cloud.compute.v1.SslPolicy;
import com.google.cloud.compute.v1.SslPolicyClient;
import com.google.cloud.compute.v1.stub.HttpJsonSslPolicyStub;
import com.google.cloud.compute.v1.stub.SslPolicyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SslPolicyStubSettings
extends StubSettings<SslPolicyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteSslPolicyHttpRequest, Operation> deleteSslPolicySettings;
    private final UnaryCallSettings<GetSslPolicyHttpRequest, SslPolicy> getSslPolicySettings;
    private final UnaryCallSettings<InsertSslPolicyHttpRequest, Operation> insertSslPolicySettings;
    private final PagedCallSettings<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicyClient.ListSslPoliciesPagedResponse> listSslPoliciesSettings;
    private final UnaryCallSettings<ListAvailableFeaturesSslPoliciesHttpRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesSslPoliciesSettings;
    private final UnaryCallSettings<PatchSslPolicyHttpRequest, Operation> patchSslPolicySettings;
    private static final PagedListDescriptor<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicy> LIST_SSL_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListSslPoliciesHttpRequest injectToken(ListSslPoliciesHttpRequest payload, String token) {
            return ListSslPoliciesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListSslPoliciesHttpRequest injectPageSize(ListSslPoliciesHttpRequest payload, int pageSize) {
            return ListSslPoliciesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListSslPoliciesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SslPoliciesList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SslPolicy> extractResources(SslPoliciesList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicyClient.ListSslPoliciesPagedResponse> LIST_SSL_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicyClient.ListSslPoliciesPagedResponse>(){

        public ApiFuture<SslPolicyClient.ListSslPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSslPoliciesHttpRequest, SslPoliciesList> callable, ListSslPoliciesHttpRequest request, ApiCallContext context, ApiFuture<SslPoliciesList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SSL_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SslPolicyClient.ListSslPoliciesPagedResponse.createAsync((PageContext<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteSslPolicyHttpRequest, Operation> deleteSslPolicySettings() {
        return this.deleteSslPolicySettings;
    }

    public UnaryCallSettings<GetSslPolicyHttpRequest, SslPolicy> getSslPolicySettings() {
        return this.getSslPolicySettings;
    }

    public UnaryCallSettings<InsertSslPolicyHttpRequest, Operation> insertSslPolicySettings() {
        return this.insertSslPolicySettings;
    }

    public PagedCallSettings<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicyClient.ListSslPoliciesPagedResponse> listSslPoliciesSettings() {
        return this.listSslPoliciesSettings;
    }

    public UnaryCallSettings<ListAvailableFeaturesSslPoliciesHttpRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesSslPoliciesSettings() {
        return this.listAvailableFeaturesSslPoliciesSettings;
    }

    public UnaryCallSettings<PatchSslPolicyHttpRequest, Operation> patchSslPolicySettings() {
        return this.patchSslPolicySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SslPolicyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSslPolicyStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SslPolicyStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SslPolicyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SslPolicyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSslPolicySettings = settingsBuilder.deleteSslPolicySettings().build();
        this.getSslPolicySettings = settingsBuilder.getSslPolicySettings().build();
        this.insertSslPolicySettings = settingsBuilder.insertSslPolicySettings().build();
        this.listSslPoliciesSettings = settingsBuilder.listSslPoliciesSettings().build();
        this.listAvailableFeaturesSslPoliciesSettings = settingsBuilder.listAvailableFeaturesSslPoliciesSettings().build();
        this.patchSslPolicySettings = settingsBuilder.patchSslPolicySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SslPolicyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteSslPolicyHttpRequest, Operation> deleteSslPolicySettings;
        private final UnaryCallSettings.Builder<GetSslPolicyHttpRequest, SslPolicy> getSslPolicySettings;
        private final UnaryCallSettings.Builder<InsertSslPolicyHttpRequest, Operation> insertSslPolicySettings;
        private final PagedCallSettings.Builder<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicyClient.ListSslPoliciesPagedResponse> listSslPoliciesSettings;
        private final UnaryCallSettings.Builder<ListAvailableFeaturesSslPoliciesHttpRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesSslPoliciesSettings;
        private final UnaryCallSettings.Builder<PatchSslPolicyHttpRequest, Operation> patchSslPolicySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSslPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSslPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSslPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSslPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SSL_POLICIES_PAGE_STR_FACT);
            this.listAvailableFeaturesSslPoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchSslPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSslPolicySettings, this.getSslPolicySettings, this.insertSslPolicySettings, this.listSslPoliciesSettings, this.listAvailableFeaturesSslPoliciesSettings, this.patchSslPolicySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SslPolicyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SslPolicyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SslPolicyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SslPolicyStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSslPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSslPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertSslPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSslPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listAvailableFeaturesSslPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchSslPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(SslPolicyStubSettings settings) {
            super((StubSettings)settings);
            this.deleteSslPolicySettings = settings.deleteSslPolicySettings.toBuilder();
            this.getSslPolicySettings = settings.getSslPolicySettings.toBuilder();
            this.insertSslPolicySettings = settings.insertSslPolicySettings.toBuilder();
            this.listSslPoliciesSettings = settings.listSslPoliciesSettings.toBuilder();
            this.listAvailableFeaturesSslPoliciesSettings = settings.listAvailableFeaturesSslPoliciesSettings.toBuilder();
            this.patchSslPolicySettings = settings.patchSslPolicySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSslPolicySettings, this.getSslPolicySettings, this.insertSslPolicySettings, this.listSslPoliciesSettings, this.listAvailableFeaturesSslPoliciesSettings, this.patchSslPolicySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteSslPolicyHttpRequest, Operation> deleteSslPolicySettings() {
            return this.deleteSslPolicySettings;
        }

        public UnaryCallSettings.Builder<GetSslPolicyHttpRequest, SslPolicy> getSslPolicySettings() {
            return this.getSslPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertSslPolicyHttpRequest, Operation> insertSslPolicySettings() {
            return this.insertSslPolicySettings;
        }

        public PagedCallSettings.Builder<ListSslPoliciesHttpRequest, SslPoliciesList, SslPolicyClient.ListSslPoliciesPagedResponse> listSslPoliciesSettings() {
            return this.listSslPoliciesSettings;
        }

        public UnaryCallSettings.Builder<ListAvailableFeaturesSslPoliciesHttpRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesSslPoliciesSettings() {
            return this.listAvailableFeaturesSslPoliciesSettings;
        }

        public UnaryCallSettings.Builder<PatchSslPolicyHttpRequest, Operation> patchSslPolicySettings() {
            return this.patchSslPolicySettings;
        }

        public SslPolicyStubSettings build() throws IOException {
            return new SslPolicyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

