/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.HealthCheckClient;
import com.google.cloud.compute.v1.HealthCheckList;
import com.google.cloud.compute.v1.InsertHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHealthCheckHttpRequest;
import com.google.cloud.compute.v1.UpdateHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HealthCheckStub;
import com.google.cloud.compute.v1.stub.HttpJsonHealthCheckStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class HealthCheckStubSettings
extends StubSettings<HealthCheckStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteHealthCheckHttpRequest, Operation> deleteHealthCheckSettings;
    private final UnaryCallSettings<GetHealthCheckHttpRequest, HealthCheck> getHealthCheckSettings;
    private final UnaryCallSettings<InsertHealthCheckHttpRequest, Operation> insertHealthCheckSettings;
    private final PagedCallSettings<ListHealthChecksHttpRequest, HealthCheckList, HealthCheckClient.ListHealthChecksPagedResponse> listHealthChecksSettings;
    private final UnaryCallSettings<PatchHealthCheckHttpRequest, Operation> patchHealthCheckSettings;
    private final UnaryCallSettings<UpdateHealthCheckHttpRequest, Operation> updateHealthCheckSettings;
    private static final PagedListDescriptor<ListHealthChecksHttpRequest, HealthCheckList, HealthCheck> LIST_HEALTH_CHECKS_PAGE_STR_DESC = new PagedListDescriptor<ListHealthChecksHttpRequest, HealthCheckList, HealthCheck>(){

        public String emptyToken() {
            return "";
        }

        public ListHealthChecksHttpRequest injectToken(ListHealthChecksHttpRequest payload, String token) {
            return ListHealthChecksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListHealthChecksHttpRequest injectPageSize(ListHealthChecksHttpRequest payload, int pageSize) {
            return ListHealthChecksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListHealthChecksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(HealthCheckList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HealthCheck> extractResources(HealthCheckList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListHealthChecksHttpRequest, HealthCheckList, HealthCheckClient.ListHealthChecksPagedResponse> LIST_HEALTH_CHECKS_PAGE_STR_FACT = new PagedListResponseFactory<ListHealthChecksHttpRequest, HealthCheckList, HealthCheckClient.ListHealthChecksPagedResponse>(){

        public ApiFuture<HealthCheckClient.ListHealthChecksPagedResponse> getFuturePagedResponse(UnaryCallable<ListHealthChecksHttpRequest, HealthCheckList> callable, ListHealthChecksHttpRequest request, ApiCallContext context, ApiFuture<HealthCheckList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_HEALTH_CHECKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HealthCheckClient.ListHealthChecksPagedResponse.createAsync((PageContext<ListHealthChecksHttpRequest, HealthCheckList, HealthCheck>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteHealthCheckHttpRequest, Operation> deleteHealthCheckSettings() {
        return this.deleteHealthCheckSettings;
    }

    public UnaryCallSettings<GetHealthCheckHttpRequest, HealthCheck> getHealthCheckSettings() {
        return this.getHealthCheckSettings;
    }

    public UnaryCallSettings<InsertHealthCheckHttpRequest, Operation> insertHealthCheckSettings() {
        return this.insertHealthCheckSettings;
    }

    public PagedCallSettings<ListHealthChecksHttpRequest, HealthCheckList, HealthCheckClient.ListHealthChecksPagedResponse> listHealthChecksSettings() {
        return this.listHealthChecksSettings;
    }

    public UnaryCallSettings<PatchHealthCheckHttpRequest, Operation> patchHealthCheckSettings() {
        return this.patchHealthCheckSettings;
    }

    public UnaryCallSettings<UpdateHealthCheckHttpRequest, Operation> updateHealthCheckSettings() {
        return this.updateHealthCheckSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public HealthCheckStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonHealthCheckStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return HealthCheckStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HealthCheckStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected HealthCheckStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteHealthCheckSettings = settingsBuilder.deleteHealthCheckSettings().build();
        this.getHealthCheckSettings = settingsBuilder.getHealthCheckSettings().build();
        this.insertHealthCheckSettings = settingsBuilder.insertHealthCheckSettings().build();
        this.listHealthChecksSettings = settingsBuilder.listHealthChecksSettings().build();
        this.patchHealthCheckSettings = settingsBuilder.patchHealthCheckSettings().build();
        this.updateHealthCheckSettings = settingsBuilder.updateHealthCheckSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<HealthCheckStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteHealthCheckHttpRequest, Operation> deleteHealthCheckSettings;
        private final UnaryCallSettings.Builder<GetHealthCheckHttpRequest, HealthCheck> getHealthCheckSettings;
        private final UnaryCallSettings.Builder<InsertHealthCheckHttpRequest, Operation> insertHealthCheckSettings;
        private final PagedCallSettings.Builder<ListHealthChecksHttpRequest, HealthCheckList, HealthCheckClient.ListHealthChecksPagedResponse> listHealthChecksSettings;
        private final UnaryCallSettings.Builder<PatchHealthCheckHttpRequest, Operation> patchHealthCheckSettings;
        private final UnaryCallSettings.Builder<UpdateHealthCheckHttpRequest, Operation> updateHealthCheckSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listHealthChecksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_HEALTH_CHECKS_PAGE_STR_FACT);
            this.patchHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteHealthCheckSettings, this.getHealthCheckSettings, this.insertHealthCheckSettings, this.listHealthChecksSettings, this.patchHealthCheckSettings, this.updateHealthCheckSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(HealthCheckStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)HealthCheckStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HealthCheckStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(HealthCheckStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listHealthChecksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(HealthCheckStubSettings settings) {
            super((StubSettings)settings);
            this.deleteHealthCheckSettings = settings.deleteHealthCheckSettings.toBuilder();
            this.getHealthCheckSettings = settings.getHealthCheckSettings.toBuilder();
            this.insertHealthCheckSettings = settings.insertHealthCheckSettings.toBuilder();
            this.listHealthChecksSettings = settings.listHealthChecksSettings.toBuilder();
            this.patchHealthCheckSettings = settings.patchHealthCheckSettings.toBuilder();
            this.updateHealthCheckSettings = settings.updateHealthCheckSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteHealthCheckSettings, this.getHealthCheckSettings, this.insertHealthCheckSettings, this.listHealthChecksSettings, this.patchHealthCheckSettings, this.updateHealthCheckSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteHealthCheckHttpRequest, Operation> deleteHealthCheckSettings() {
            return this.deleteHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<GetHealthCheckHttpRequest, HealthCheck> getHealthCheckSettings() {
            return this.getHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<InsertHealthCheckHttpRequest, Operation> insertHealthCheckSettings() {
            return this.insertHealthCheckSettings;
        }

        public PagedCallSettings.Builder<ListHealthChecksHttpRequest, HealthCheckList, HealthCheckClient.ListHealthChecksPagedResponse> listHealthChecksSettings() {
            return this.listHealthChecksSettings;
        }

        public UnaryCallSettings.Builder<PatchHealthCheckHttpRequest, Operation> patchHealthCheckSettings() {
            return this.patchHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<UpdateHealthCheckHttpRequest, Operation> updateHealthCheckSettings() {
            return this.updateHealthCheckSettings;
        }

        public HealthCheckStubSettings build() throws IOException {
            return new HealthCheckStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

