/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Data
implements ApiMessage {
    private final String key;
    private final String value;
    private static final Data DEFAULT_INSTANCE = new Data();

    private Data() {
        this.key = null;
        this.value = null;
    }

    private Data(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("key")) {
            return this.key;
        }
        if (fieldName.equals("value")) {
            return this.value;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Data prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Data getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Data{key=" + this.key + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Data) {
            Data that = (Data)o;
            return Objects.equals(this.key, that.getKey()) && Objects.equals(this.value, that.getValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public static class Builder {
        private String key;
        private String value;

        Builder() {
        }

        public Builder mergeFrom(Data other) {
            if (other == Data.getDefaultInstance()) {
                return this;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getValue() != null) {
                this.value = other.value;
            }
            return this;
        }

        Builder(Data source) {
            this.key = source.key;
            this.value = source.value;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Data build() {
            return new Data(this.key, this.value);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setKey(this.key);
            newBuilder.setValue(this.value);
            return newBuilder;
        }
    }
}

