/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListInterconnectAttachmentsHttpRequest;
import com.google.cloud.compute.v1.DeleteInterconnectAttachmentHttpRequest;
import com.google.cloud.compute.v1.GetInterconnectAttachmentHttpRequest;
import com.google.cloud.compute.v1.InsertInterconnectAttachmentHttpRequest;
import com.google.cloud.compute.v1.InterconnectAttachment;
import com.google.cloud.compute.v1.InterconnectAttachmentAggregatedList;
import com.google.cloud.compute.v1.InterconnectAttachmentList;
import com.google.cloud.compute.v1.InterconnectAttachmentSettings;
import com.google.cloud.compute.v1.InterconnectAttachmentsScopedList;
import com.google.cloud.compute.v1.ListInterconnectAttachmentsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionInterconnectAttachmentName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentStub;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class InterconnectAttachmentClient
implements BackgroundResource {
    private final InterconnectAttachmentSettings settings;
    private final InterconnectAttachmentStub stub;

    public static final InterconnectAttachmentClient create() throws IOException {
        return InterconnectAttachmentClient.create(InterconnectAttachmentSettings.newBuilder().build());
    }

    public static final InterconnectAttachmentClient create(InterconnectAttachmentSettings settings) throws IOException {
        return new InterconnectAttachmentClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InterconnectAttachmentClient create(InterconnectAttachmentStub stub) {
        return new InterconnectAttachmentClient(stub);
    }

    protected InterconnectAttachmentClient(InterconnectAttachmentSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InterconnectAttachmentStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InterconnectAttachmentClient(InterconnectAttachmentStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InterconnectAttachmentSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InterconnectAttachmentStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListInterconnectAttachmentsPagedResponse aggregatedListInterconnectAttachments(ProjectName project) {
        AggregatedListInterconnectAttachmentsHttpRequest request = AggregatedListInterconnectAttachmentsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListInterconnectAttachments(request);
    }

    @BetaApi
    public final AggregatedListInterconnectAttachmentsPagedResponse aggregatedListInterconnectAttachments(String project) {
        AggregatedListInterconnectAttachmentsHttpRequest request = AggregatedListInterconnectAttachmentsHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListInterconnectAttachments(request);
    }

    @BetaApi
    public final AggregatedListInterconnectAttachmentsPagedResponse aggregatedListInterconnectAttachments(AggregatedListInterconnectAttachmentsHttpRequest request) {
        return (AggregatedListInterconnectAttachmentsPagedResponse)((Object)this.aggregatedListInterconnectAttachmentsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListInterconnectAttachmentsHttpRequest, AggregatedListInterconnectAttachmentsPagedResponse> aggregatedListInterconnectAttachmentsPagedCallable() {
        return this.stub.aggregatedListInterconnectAttachmentsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList> aggregatedListInterconnectAttachmentsCallable() {
        return this.stub.aggregatedListInterconnectAttachmentsCallable();
    }

    @BetaApi
    public final Operation deleteInterconnectAttachment(ProjectRegionInterconnectAttachmentName interconnectAttachment) {
        DeleteInterconnectAttachmentHttpRequest request = DeleteInterconnectAttachmentHttpRequest.newBuilder().setInterconnectAttachment(interconnectAttachment == null ? null : interconnectAttachment.toString()).build();
        return this.deleteInterconnectAttachment(request);
    }

    @BetaApi
    public final Operation deleteInterconnectAttachment(String interconnectAttachment) {
        DeleteInterconnectAttachmentHttpRequest request = DeleteInterconnectAttachmentHttpRequest.newBuilder().setInterconnectAttachment(interconnectAttachment).build();
        return this.deleteInterconnectAttachment(request);
    }

    @BetaApi
    public final Operation deleteInterconnectAttachment(DeleteInterconnectAttachmentHttpRequest request) {
        return (Operation)this.deleteInterconnectAttachmentCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteInterconnectAttachmentHttpRequest, Operation> deleteInterconnectAttachmentCallable() {
        return this.stub.deleteInterconnectAttachmentCallable();
    }

    @BetaApi
    public final InterconnectAttachment getInterconnectAttachment(ProjectRegionInterconnectAttachmentName interconnectAttachment) {
        GetInterconnectAttachmentHttpRequest request = GetInterconnectAttachmentHttpRequest.newBuilder().setInterconnectAttachment(interconnectAttachment == null ? null : interconnectAttachment.toString()).build();
        return this.getInterconnectAttachment(request);
    }

    @BetaApi
    public final InterconnectAttachment getInterconnectAttachment(String interconnectAttachment) {
        GetInterconnectAttachmentHttpRequest request = GetInterconnectAttachmentHttpRequest.newBuilder().setInterconnectAttachment(interconnectAttachment).build();
        return this.getInterconnectAttachment(request);
    }

    @BetaApi
    public final InterconnectAttachment getInterconnectAttachment(GetInterconnectAttachmentHttpRequest request) {
        return (InterconnectAttachment)this.getInterconnectAttachmentCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetInterconnectAttachmentHttpRequest, InterconnectAttachment> getInterconnectAttachmentCallable() {
        return this.stub.getInterconnectAttachmentCallable();
    }

    @BetaApi
    public final Operation insertInterconnectAttachment(ProjectRegionName region, InterconnectAttachment interconnectAttachmentResource) {
        InsertInterconnectAttachmentHttpRequest request = InsertInterconnectAttachmentHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setInterconnectAttachmentResource(interconnectAttachmentResource).build();
        return this.insertInterconnectAttachment(request);
    }

    @BetaApi
    public final Operation insertInterconnectAttachment(String region, InterconnectAttachment interconnectAttachmentResource) {
        InsertInterconnectAttachmentHttpRequest request = InsertInterconnectAttachmentHttpRequest.newBuilder().setRegion(region).setInterconnectAttachmentResource(interconnectAttachmentResource).build();
        return this.insertInterconnectAttachment(request);
    }

    @BetaApi
    public final Operation insertInterconnectAttachment(InsertInterconnectAttachmentHttpRequest request) {
        return (Operation)this.insertInterconnectAttachmentCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertInterconnectAttachmentHttpRequest, Operation> insertInterconnectAttachmentCallable() {
        return this.stub.insertInterconnectAttachmentCallable();
    }

    @BetaApi
    public final ListInterconnectAttachmentsPagedResponse listInterconnectAttachments(ProjectRegionName region) {
        ListInterconnectAttachmentsHttpRequest request = ListInterconnectAttachmentsHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listInterconnectAttachments(request);
    }

    @BetaApi
    public final ListInterconnectAttachmentsPagedResponse listInterconnectAttachments(String region) {
        ListInterconnectAttachmentsHttpRequest request = ListInterconnectAttachmentsHttpRequest.newBuilder().setRegion(region).build();
        return this.listInterconnectAttachments(request);
    }

    @BetaApi
    public final ListInterconnectAttachmentsPagedResponse listInterconnectAttachments(ListInterconnectAttachmentsHttpRequest request) {
        return (ListInterconnectAttachmentsPagedResponse)((Object)this.listInterconnectAttachmentsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListInterconnectAttachmentsHttpRequest, ListInterconnectAttachmentsPagedResponse> listInterconnectAttachmentsPagedCallable() {
        return this.stub.listInterconnectAttachmentsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList> listInterconnectAttachmentsCallable() {
        return this.stub.listInterconnectAttachmentsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInterconnectAttachmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachment, ListInterconnectAttachmentsPage, ListInterconnectAttachmentsFixedSizeCollection> {
        private ListInterconnectAttachmentsFixedSizeCollection(List<ListInterconnectAttachmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInterconnectAttachmentsFixedSizeCollection createEmptyCollection() {
            return new ListInterconnectAttachmentsFixedSizeCollection(null, 0);
        }

        protected ListInterconnectAttachmentsFixedSizeCollection createCollection(List<ListInterconnectAttachmentsPage> pages, int collectionSize) {
            return new ListInterconnectAttachmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInterconnectAttachmentsPage
    extends AbstractPage<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachment, ListInterconnectAttachmentsPage> {
        private ListInterconnectAttachmentsPage(PageContext<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachment> context, InterconnectAttachmentList response) {
            super(context, (Object)response);
        }

        private static ListInterconnectAttachmentsPage createEmptyPage() {
            return new ListInterconnectAttachmentsPage(null, null);
        }

        protected ListInterconnectAttachmentsPage createPage(PageContext<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachment> context, InterconnectAttachmentList response) {
            return new ListInterconnectAttachmentsPage(context, response);
        }

        public ApiFuture<ListInterconnectAttachmentsPage> createPageAsync(PageContext<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachment> context, ApiFuture<InterconnectAttachmentList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInterconnectAttachmentsPagedResponse
    extends AbstractPagedListResponse<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachment, ListInterconnectAttachmentsPage, ListInterconnectAttachmentsFixedSizeCollection> {
        public static ApiFuture<ListInterconnectAttachmentsPagedResponse> createAsync(PageContext<ListInterconnectAttachmentsHttpRequest, InterconnectAttachmentList, InterconnectAttachment> context, ApiFuture<InterconnectAttachmentList> futureResponse) {
            ApiFuture<ListInterconnectAttachmentsPage> futurePage = ListInterconnectAttachmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInterconnectAttachmentsPage, ListInterconnectAttachmentsPagedResponse>(){

                public ListInterconnectAttachmentsPagedResponse apply(ListInterconnectAttachmentsPage input) {
                    return new ListInterconnectAttachmentsPagedResponse(input);
                }
            });
        }

        private ListInterconnectAttachmentsPagedResponse(ListInterconnectAttachmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInterconnectAttachmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListInterconnectAttachmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsScopedList, AggregatedListInterconnectAttachmentsPage, AggregatedListInterconnectAttachmentsFixedSizeCollection> {
        private AggregatedListInterconnectAttachmentsFixedSizeCollection(List<AggregatedListInterconnectAttachmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListInterconnectAttachmentsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListInterconnectAttachmentsFixedSizeCollection(null, 0);
        }

        protected AggregatedListInterconnectAttachmentsFixedSizeCollection createCollection(List<AggregatedListInterconnectAttachmentsPage> pages, int collectionSize) {
            return new AggregatedListInterconnectAttachmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListInterconnectAttachmentsPage
    extends AbstractPage<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsScopedList, AggregatedListInterconnectAttachmentsPage> {
        private AggregatedListInterconnectAttachmentsPage(PageContext<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsScopedList> context, InterconnectAttachmentAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListInterconnectAttachmentsPage createEmptyPage() {
            return new AggregatedListInterconnectAttachmentsPage(null, null);
        }

        protected AggregatedListInterconnectAttachmentsPage createPage(PageContext<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsScopedList> context, InterconnectAttachmentAggregatedList response) {
            return new AggregatedListInterconnectAttachmentsPage(context, response);
        }

        public ApiFuture<AggregatedListInterconnectAttachmentsPage> createPageAsync(PageContext<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsScopedList> context, ApiFuture<InterconnectAttachmentAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListInterconnectAttachmentsPagedResponse
    extends AbstractPagedListResponse<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsScopedList, AggregatedListInterconnectAttachmentsPage, AggregatedListInterconnectAttachmentsFixedSizeCollection> {
        public static ApiFuture<AggregatedListInterconnectAttachmentsPagedResponse> createAsync(PageContext<AggregatedListInterconnectAttachmentsHttpRequest, InterconnectAttachmentAggregatedList, InterconnectAttachmentsScopedList> context, ApiFuture<InterconnectAttachmentAggregatedList> futureResponse) {
            ApiFuture<AggregatedListInterconnectAttachmentsPage> futurePage = AggregatedListInterconnectAttachmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListInterconnectAttachmentsPage, AggregatedListInterconnectAttachmentsPagedResponse>(){

                public AggregatedListInterconnectAttachmentsPagedResponse apply(AggregatedListInterconnectAttachmentsPage input) {
                    return new AggregatedListInterconnectAttachmentsPagedResponse(input);
                }
            });
        }

        private AggregatedListInterconnectAttachmentsPagedResponse(AggregatedListInterconnectAttachmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListInterconnectAttachmentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

