/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListVpnTunnelsHttpRequest;
import com.google.cloud.compute.v1.DeleteVpnTunnelHttpRequest;
import com.google.cloud.compute.v1.GetVpnTunnelHttpRequest;
import com.google.cloud.compute.v1.InsertVpnTunnelHttpRequest;
import com.google.cloud.compute.v1.ListVpnTunnelsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.VpnTunnel;
import com.google.cloud.compute.v1.VpnTunnelAggregatedList;
import com.google.cloud.compute.v1.VpnTunnelClient;
import com.google.cloud.compute.v1.VpnTunnelList;
import com.google.cloud.compute.v1.VpnTunnelsScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonVpnTunnelStub;
import com.google.cloud.compute.v1.stub.VpnTunnelStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class VpnTunnelStubSettings
extends StubSettings<VpnTunnelStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelClient.AggregatedListVpnTunnelsPagedResponse> aggregatedListVpnTunnelsSettings;
    private final UnaryCallSettings<DeleteVpnTunnelHttpRequest, Operation> deleteVpnTunnelSettings;
    private final UnaryCallSettings<GetVpnTunnelHttpRequest, VpnTunnel> getVpnTunnelSettings;
    private final UnaryCallSettings<InsertVpnTunnelHttpRequest, Operation> insertVpnTunnelSettings;
    private final PagedCallSettings<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnelClient.ListVpnTunnelsPagedResponse> listVpnTunnelsSettings;
    private static final PagedListDescriptor<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelsScopedList> AGGREGATED_LIST_VPN_TUNNELS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListVpnTunnelsHttpRequest injectToken(AggregatedListVpnTunnelsHttpRequest payload, String token) {
            return AggregatedListVpnTunnelsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListVpnTunnelsHttpRequest injectPageSize(AggregatedListVpnTunnelsHttpRequest payload, int pageSize) {
            return AggregatedListVpnTunnelsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListVpnTunnelsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(VpnTunnelAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VpnTunnelsScopedList> extractResources(VpnTunnelAggregatedList payload) {
            return payload.getItemsMap().values();
        }
    };
    private static final PagedListDescriptor<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnel> LIST_VPN_TUNNELS_PAGE_STR_DESC = new PagedListDescriptor<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnel>(){

        public String emptyToken() {
            return "";
        }

        public ListVpnTunnelsHttpRequest injectToken(ListVpnTunnelsHttpRequest payload, String token) {
            return ListVpnTunnelsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListVpnTunnelsHttpRequest injectPageSize(ListVpnTunnelsHttpRequest payload, int pageSize) {
            return ListVpnTunnelsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListVpnTunnelsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(VpnTunnelList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VpnTunnel> extractResources(VpnTunnelList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelClient.AggregatedListVpnTunnelsPagedResponse> AGGREGATED_LIST_VPN_TUNNELS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelClient.AggregatedListVpnTunnelsPagedResponse>(){

        public ApiFuture<VpnTunnelClient.AggregatedListVpnTunnelsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList> callable, AggregatedListVpnTunnelsHttpRequest request, ApiCallContext context, ApiFuture<VpnTunnelAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_VPN_TUNNELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VpnTunnelClient.AggregatedListVpnTunnelsPagedResponse.createAsync((PageContext<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnelClient.ListVpnTunnelsPagedResponse> LIST_VPN_TUNNELS_PAGE_STR_FACT = new PagedListResponseFactory<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnelClient.ListVpnTunnelsPagedResponse>(){

        public ApiFuture<VpnTunnelClient.ListVpnTunnelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVpnTunnelsHttpRequest, VpnTunnelList> callable, ListVpnTunnelsHttpRequest request, ApiCallContext context, ApiFuture<VpnTunnelList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VPN_TUNNELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VpnTunnelClient.ListVpnTunnelsPagedResponse.createAsync((PageContext<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnel>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelClient.AggregatedListVpnTunnelsPagedResponse> aggregatedListVpnTunnelsSettings() {
        return this.aggregatedListVpnTunnelsSettings;
    }

    public UnaryCallSettings<DeleteVpnTunnelHttpRequest, Operation> deleteVpnTunnelSettings() {
        return this.deleteVpnTunnelSettings;
    }

    public UnaryCallSettings<GetVpnTunnelHttpRequest, VpnTunnel> getVpnTunnelSettings() {
        return this.getVpnTunnelSettings;
    }

    public UnaryCallSettings<InsertVpnTunnelHttpRequest, Operation> insertVpnTunnelSettings() {
        return this.insertVpnTunnelSettings;
    }

    public PagedCallSettings<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnelClient.ListVpnTunnelsPagedResponse> listVpnTunnelsSettings() {
        return this.listVpnTunnelsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VpnTunnelStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonVpnTunnelStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return VpnTunnelStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(VpnTunnelStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected VpnTunnelStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListVpnTunnelsSettings = settingsBuilder.aggregatedListVpnTunnelsSettings().build();
        this.deleteVpnTunnelSettings = settingsBuilder.deleteVpnTunnelSettings().build();
        this.getVpnTunnelSettings = settingsBuilder.getVpnTunnelSettings().build();
        this.insertVpnTunnelSettings = settingsBuilder.insertVpnTunnelSettings().build();
        this.listVpnTunnelsSettings = settingsBuilder.listVpnTunnelsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<VpnTunnelStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelClient.AggregatedListVpnTunnelsPagedResponse> aggregatedListVpnTunnelsSettings;
        private final UnaryCallSettings.Builder<DeleteVpnTunnelHttpRequest, Operation> deleteVpnTunnelSettings;
        private final UnaryCallSettings.Builder<GetVpnTunnelHttpRequest, VpnTunnel> getVpnTunnelSettings;
        private final UnaryCallSettings.Builder<InsertVpnTunnelHttpRequest, Operation> insertVpnTunnelSettings;
        private final PagedCallSettings.Builder<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnelClient.ListVpnTunnelsPagedResponse> listVpnTunnelsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListVpnTunnelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_VPN_TUNNELS_PAGE_STR_FACT);
            this.deleteVpnTunnelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getVpnTunnelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertVpnTunnelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listVpnTunnelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VPN_TUNNELS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListVpnTunnelsSettings, this.deleteVpnTunnelSettings, this.getVpnTunnelSettings, this.insertVpnTunnelSettings, this.listVpnTunnelsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(VpnTunnelStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)VpnTunnelStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)VpnTunnelStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(VpnTunnelStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListVpnTunnelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteVpnTunnelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getVpnTunnelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertVpnTunnelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listVpnTunnelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(VpnTunnelStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListVpnTunnelsSettings = settings.aggregatedListVpnTunnelsSettings.toBuilder();
            this.deleteVpnTunnelSettings = settings.deleteVpnTunnelSettings.toBuilder();
            this.getVpnTunnelSettings = settings.getVpnTunnelSettings.toBuilder();
            this.insertVpnTunnelSettings = settings.insertVpnTunnelSettings.toBuilder();
            this.listVpnTunnelsSettings = settings.listVpnTunnelsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListVpnTunnelsSettings, this.deleteVpnTunnelSettings, this.getVpnTunnelSettings, this.insertVpnTunnelSettings, this.listVpnTunnelsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelClient.AggregatedListVpnTunnelsPagedResponse> aggregatedListVpnTunnelsSettings() {
            return this.aggregatedListVpnTunnelsSettings;
        }

        public UnaryCallSettings.Builder<DeleteVpnTunnelHttpRequest, Operation> deleteVpnTunnelSettings() {
            return this.deleteVpnTunnelSettings;
        }

        public UnaryCallSettings.Builder<GetVpnTunnelHttpRequest, VpnTunnel> getVpnTunnelSettings() {
            return this.getVpnTunnelSettings;
        }

        public UnaryCallSettings.Builder<InsertVpnTunnelHttpRequest, Operation> insertVpnTunnelSettings() {
            return this.insertVpnTunnelSettings;
        }

        public PagedCallSettings.Builder<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnelClient.ListVpnTunnelsPagedResponse> listVpnTunnelsSettings() {
            return this.listVpnTunnelsSettings;
        }

        public VpnTunnelStubSettings build() throws IOException {
            return new VpnTunnelStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

