/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRouteHttpRequest;
import com.google.cloud.compute.v1.GetRouteHttpRequest;
import com.google.cloud.compute.v1.InsertRouteHttpRequest;
import com.google.cloud.compute.v1.ListRoutesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Route;
import com.google.cloud.compute.v1.RouteClient;
import com.google.cloud.compute.v1.RouteList;
import com.google.cloud.compute.v1.stub.HttpJsonRouteStub;
import com.google.cloud.compute.v1.stub.RouteStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RouteStubSettings
extends StubSettings<RouteStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRouteHttpRequest, Operation> deleteRouteSettings;
    private final UnaryCallSettings<GetRouteHttpRequest, Route> getRouteSettings;
    private final UnaryCallSettings<InsertRouteHttpRequest, Operation> insertRouteSettings;
    private final PagedCallSettings<ListRoutesHttpRequest, RouteList, RouteClient.ListRoutesPagedResponse> listRoutesSettings;
    private static final PagedListDescriptor<ListRoutesHttpRequest, RouteList, Route> LIST_ROUTES_PAGE_STR_DESC = new PagedListDescriptor<ListRoutesHttpRequest, RouteList, Route>(){

        public String emptyToken() {
            return "";
        }

        public ListRoutesHttpRequest injectToken(ListRoutesHttpRequest payload, String token) {
            return ListRoutesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRoutesHttpRequest injectPageSize(ListRoutesHttpRequest payload, int pageSize) {
            return ListRoutesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRoutesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RouteList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Route> extractResources(RouteList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRoutesHttpRequest, RouteList, RouteClient.ListRoutesPagedResponse> LIST_ROUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListRoutesHttpRequest, RouteList, RouteClient.ListRoutesPagedResponse>(){

        public ApiFuture<RouteClient.ListRoutesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRoutesHttpRequest, RouteList> callable, ListRoutesHttpRequest request, ApiCallContext context, ApiFuture<RouteList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RouteClient.ListRoutesPagedResponse.createAsync((PageContext<ListRoutesHttpRequest, RouteList, Route>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRouteHttpRequest, Operation> deleteRouteSettings() {
        return this.deleteRouteSettings;
    }

    public UnaryCallSettings<GetRouteHttpRequest, Route> getRouteSettings() {
        return this.getRouteSettings;
    }

    public UnaryCallSettings<InsertRouteHttpRequest, Operation> insertRouteSettings() {
        return this.insertRouteSettings;
    }

    public PagedCallSettings<ListRoutesHttpRequest, RouteList, RouteClient.ListRoutesPagedResponse> listRoutesSettings() {
        return this.listRoutesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RouteStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRouteStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RouteStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RouteStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RouteStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRouteSettings = settingsBuilder.deleteRouteSettings().build();
        this.getRouteSettings = settingsBuilder.getRouteSettings().build();
        this.insertRouteSettings = settingsBuilder.insertRouteSettings().build();
        this.listRoutesSettings = settingsBuilder.listRoutesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RouteStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRouteHttpRequest, Operation> deleteRouteSettings;
        private final UnaryCallSettings.Builder<GetRouteHttpRequest, Route> getRouteSettings;
        private final UnaryCallSettings.Builder<InsertRouteHttpRequest, Operation> insertRouteSettings;
        private final PagedCallSettings.Builder<ListRoutesHttpRequest, RouteList, RouteClient.ListRoutesPagedResponse> listRoutesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRoutesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROUTES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRouteSettings, this.getRouteSettings, this.insertRouteSettings, this.listRoutesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RouteStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RouteStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RouteStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RouteStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRoutesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RouteStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRouteSettings = settings.deleteRouteSettings.toBuilder();
            this.getRouteSettings = settings.getRouteSettings.toBuilder();
            this.insertRouteSettings = settings.insertRouteSettings.toBuilder();
            this.listRoutesSettings = settings.listRoutesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRouteSettings, this.getRouteSettings, this.insertRouteSettings, this.listRoutesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRouteHttpRequest, Operation> deleteRouteSettings() {
            return this.deleteRouteSettings;
        }

        public UnaryCallSettings.Builder<GetRouteHttpRequest, Route> getRouteSettings() {
            return this.getRouteSettings;
        }

        public UnaryCallSettings.Builder<InsertRouteHttpRequest, Operation> insertRouteSettings() {
            return this.insertRouteSettings;
        }

        public PagedCallSettings.Builder<ListRoutesHttpRequest, RouteList, RouteClient.ListRoutesPagedResponse> listRoutesSettings() {
            return this.listRoutesSettings;
        }

        public RouteStubSettings build() throws IOException {
            return new RouteStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

