/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListRoutersHttpRequest;
import com.google.cloud.compute.v1.DeleteRouterHttpRequest;
import com.google.cloud.compute.v1.GetRouterHttpRequest;
import com.google.cloud.compute.v1.GetRouterStatusRouterHttpRequest;
import com.google.cloud.compute.v1.InsertRouterHttpRequest;
import com.google.cloud.compute.v1.ListRoutersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRouterHttpRequest;
import com.google.cloud.compute.v1.PreviewRouterHttpRequest;
import com.google.cloud.compute.v1.Router;
import com.google.cloud.compute.v1.RouterAggregatedList;
import com.google.cloud.compute.v1.RouterClient;
import com.google.cloud.compute.v1.RouterList;
import com.google.cloud.compute.v1.RouterStatusResponse;
import com.google.cloud.compute.v1.RoutersPreviewResponse;
import com.google.cloud.compute.v1.RoutersScopedList;
import com.google.cloud.compute.v1.UpdateRouterHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRouterStub;
import com.google.cloud.compute.v1.stub.RouterStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RouterStubSettings
extends StubSettings<RouterStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListRoutersHttpRequest, RouterAggregatedList, RouterClient.AggregatedListRoutersPagedResponse> aggregatedListRoutersSettings;
    private final UnaryCallSettings<DeleteRouterHttpRequest, Operation> deleteRouterSettings;
    private final UnaryCallSettings<GetRouterHttpRequest, Router> getRouterSettings;
    private final UnaryCallSettings<GetRouterStatusRouterHttpRequest, RouterStatusResponse> getRouterStatusRouterSettings;
    private final UnaryCallSettings<InsertRouterHttpRequest, Operation> insertRouterSettings;
    private final PagedCallSettings<ListRoutersHttpRequest, RouterList, RouterClient.ListRoutersPagedResponse> listRoutersSettings;
    private final UnaryCallSettings<PatchRouterHttpRequest, Operation> patchRouterSettings;
    private final UnaryCallSettings<PreviewRouterHttpRequest, RoutersPreviewResponse> previewRouterSettings;
    private final UnaryCallSettings<UpdateRouterHttpRequest, Operation> updateRouterSettings;
    private static final PagedListDescriptor<AggregatedListRoutersHttpRequest, RouterAggregatedList, RoutersScopedList> AGGREGATED_LIST_ROUTERS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListRoutersHttpRequest, RouterAggregatedList, RoutersScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListRoutersHttpRequest injectToken(AggregatedListRoutersHttpRequest payload, String token) {
            return AggregatedListRoutersHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListRoutersHttpRequest injectPageSize(AggregatedListRoutersHttpRequest payload, int pageSize) {
            return AggregatedListRoutersHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListRoutersHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RouterAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RoutersScopedList> extractResources(RouterAggregatedList payload) {
            return payload.getItemsMap().values();
        }
    };
    private static final PagedListDescriptor<ListRoutersHttpRequest, RouterList, Router> LIST_ROUTERS_PAGE_STR_DESC = new PagedListDescriptor<ListRoutersHttpRequest, RouterList, Router>(){

        public String emptyToken() {
            return "";
        }

        public ListRoutersHttpRequest injectToken(ListRoutersHttpRequest payload, String token) {
            return ListRoutersHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRoutersHttpRequest injectPageSize(ListRoutersHttpRequest payload, int pageSize) {
            return ListRoutersHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRoutersHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RouterList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Router> extractResources(RouterList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListRoutersHttpRequest, RouterAggregatedList, RouterClient.AggregatedListRoutersPagedResponse> AGGREGATED_LIST_ROUTERS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListRoutersHttpRequest, RouterAggregatedList, RouterClient.AggregatedListRoutersPagedResponse>(){

        public ApiFuture<RouterClient.AggregatedListRoutersPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListRoutersHttpRequest, RouterAggregatedList> callable, AggregatedListRoutersHttpRequest request, ApiCallContext context, ApiFuture<RouterAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_ROUTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RouterClient.AggregatedListRoutersPagedResponse.createAsync((PageContext<AggregatedListRoutersHttpRequest, RouterAggregatedList, RoutersScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRoutersHttpRequest, RouterList, RouterClient.ListRoutersPagedResponse> LIST_ROUTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListRoutersHttpRequest, RouterList, RouterClient.ListRoutersPagedResponse>(){

        public ApiFuture<RouterClient.ListRoutersPagedResponse> getFuturePagedResponse(UnaryCallable<ListRoutersHttpRequest, RouterList> callable, ListRoutersHttpRequest request, ApiCallContext context, ApiFuture<RouterList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROUTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RouterClient.ListRoutersPagedResponse.createAsync((PageContext<ListRoutersHttpRequest, RouterList, Router>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListRoutersHttpRequest, RouterAggregatedList, RouterClient.AggregatedListRoutersPagedResponse> aggregatedListRoutersSettings() {
        return this.aggregatedListRoutersSettings;
    }

    public UnaryCallSettings<DeleteRouterHttpRequest, Operation> deleteRouterSettings() {
        return this.deleteRouterSettings;
    }

    public UnaryCallSettings<GetRouterHttpRequest, Router> getRouterSettings() {
        return this.getRouterSettings;
    }

    public UnaryCallSettings<GetRouterStatusRouterHttpRequest, RouterStatusResponse> getRouterStatusRouterSettings() {
        return this.getRouterStatusRouterSettings;
    }

    public UnaryCallSettings<InsertRouterHttpRequest, Operation> insertRouterSettings() {
        return this.insertRouterSettings;
    }

    public PagedCallSettings<ListRoutersHttpRequest, RouterList, RouterClient.ListRoutersPagedResponse> listRoutersSettings() {
        return this.listRoutersSettings;
    }

    public UnaryCallSettings<PatchRouterHttpRequest, Operation> patchRouterSettings() {
        return this.patchRouterSettings;
    }

    public UnaryCallSettings<PreviewRouterHttpRequest, RoutersPreviewResponse> previewRouterSettings() {
        return this.previewRouterSettings;
    }

    public UnaryCallSettings<UpdateRouterHttpRequest, Operation> updateRouterSettings() {
        return this.updateRouterSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RouterStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRouterStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RouterStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RouterStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RouterStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListRoutersSettings = settingsBuilder.aggregatedListRoutersSettings().build();
        this.deleteRouterSettings = settingsBuilder.deleteRouterSettings().build();
        this.getRouterSettings = settingsBuilder.getRouterSettings().build();
        this.getRouterStatusRouterSettings = settingsBuilder.getRouterStatusRouterSettings().build();
        this.insertRouterSettings = settingsBuilder.insertRouterSettings().build();
        this.listRoutersSettings = settingsBuilder.listRoutersSettings().build();
        this.patchRouterSettings = settingsBuilder.patchRouterSettings().build();
        this.previewRouterSettings = settingsBuilder.previewRouterSettings().build();
        this.updateRouterSettings = settingsBuilder.updateRouterSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RouterStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListRoutersHttpRequest, RouterAggregatedList, RouterClient.AggregatedListRoutersPagedResponse> aggregatedListRoutersSettings;
        private final UnaryCallSettings.Builder<DeleteRouterHttpRequest, Operation> deleteRouterSettings;
        private final UnaryCallSettings.Builder<GetRouterHttpRequest, Router> getRouterSettings;
        private final UnaryCallSettings.Builder<GetRouterStatusRouterHttpRequest, RouterStatusResponse> getRouterStatusRouterSettings;
        private final UnaryCallSettings.Builder<InsertRouterHttpRequest, Operation> insertRouterSettings;
        private final PagedCallSettings.Builder<ListRoutersHttpRequest, RouterList, RouterClient.ListRoutersPagedResponse> listRoutersSettings;
        private final UnaryCallSettings.Builder<PatchRouterHttpRequest, Operation> patchRouterSettings;
        private final UnaryCallSettings.Builder<PreviewRouterHttpRequest, RoutersPreviewResponse> previewRouterSettings;
        private final UnaryCallSettings.Builder<UpdateRouterHttpRequest, Operation> updateRouterSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListRoutersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_ROUTERS_PAGE_STR_FACT);
            this.deleteRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRouterStatusRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRoutersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROUTERS_PAGE_STR_FACT);
            this.patchRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.previewRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListRoutersSettings, this.deleteRouterSettings, this.getRouterSettings, this.getRouterStatusRouterSettings, this.insertRouterSettings, this.listRoutersSettings, this.patchRouterSettings, this.previewRouterSettings, this.updateRouterSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RouterStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RouterStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RouterStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RouterStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListRoutersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRouterStatusRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRoutersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.previewRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RouterStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListRoutersSettings = settings.aggregatedListRoutersSettings.toBuilder();
            this.deleteRouterSettings = settings.deleteRouterSettings.toBuilder();
            this.getRouterSettings = settings.getRouterSettings.toBuilder();
            this.getRouterStatusRouterSettings = settings.getRouterStatusRouterSettings.toBuilder();
            this.insertRouterSettings = settings.insertRouterSettings.toBuilder();
            this.listRoutersSettings = settings.listRoutersSettings.toBuilder();
            this.patchRouterSettings = settings.patchRouterSettings.toBuilder();
            this.previewRouterSettings = settings.previewRouterSettings.toBuilder();
            this.updateRouterSettings = settings.updateRouterSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListRoutersSettings, this.deleteRouterSettings, this.getRouterSettings, this.getRouterStatusRouterSettings, this.insertRouterSettings, this.listRoutersSettings, this.patchRouterSettings, this.previewRouterSettings, this.updateRouterSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListRoutersHttpRequest, RouterAggregatedList, RouterClient.AggregatedListRoutersPagedResponse> aggregatedListRoutersSettings() {
            return this.aggregatedListRoutersSettings;
        }

        public UnaryCallSettings.Builder<DeleteRouterHttpRequest, Operation> deleteRouterSettings() {
            return this.deleteRouterSettings;
        }

        public UnaryCallSettings.Builder<GetRouterHttpRequest, Router> getRouterSettings() {
            return this.getRouterSettings;
        }

        public UnaryCallSettings.Builder<GetRouterStatusRouterHttpRequest, RouterStatusResponse> getRouterStatusRouterSettings() {
            return this.getRouterStatusRouterSettings;
        }

        public UnaryCallSettings.Builder<InsertRouterHttpRequest, Operation> insertRouterSettings() {
            return this.insertRouterSettings;
        }

        public PagedCallSettings.Builder<ListRoutersHttpRequest, RouterList, RouterClient.ListRoutersPagedResponse> listRoutersSettings() {
            return this.listRoutersSettings;
        }

        public UnaryCallSettings.Builder<PatchRouterHttpRequest, Operation> patchRouterSettings() {
            return this.patchRouterSettings;
        }

        public UnaryCallSettings.Builder<PreviewRouterHttpRequest, RoutersPreviewResponse> previewRouterSettings() {
            return this.previewRouterSettings;
        }

        public UnaryCallSettings.Builder<UpdateRouterHttpRequest, Operation> updateRouterSettings() {
            return this.updateRouterSettings;
        }

        public RouterStubSettings build() throws IOException {
            return new RouterStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

