/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetRegionHttpRequest;
import com.google.cloud.compute.v1.ListRegionsHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.Region;
import com.google.cloud.compute.v1.RegionList;
import com.google.cloud.compute.v1.RegionSettings;
import com.google.cloud.compute.v1.stub.RegionStub;
import com.google.cloud.compute.v1.stub.RegionStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionClient
implements BackgroundResource {
    private final RegionSettings settings;
    private final RegionStub stub;

    public static final RegionClient create() throws IOException {
        return RegionClient.create(RegionSettings.newBuilder().build());
    }

    public static final RegionClient create(RegionSettings settings) throws IOException {
        return new RegionClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionClient create(RegionStub stub) {
        return new RegionClient(stub);
    }

    protected RegionClient(RegionSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionClient(RegionStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Region getRegion(ProjectRegionName region) {
        GetRegionHttpRequest request = GetRegionHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.getRegion(request);
    }

    @BetaApi
    public final Region getRegion(String region) {
        GetRegionHttpRequest request = GetRegionHttpRequest.newBuilder().setRegion(region).build();
        return this.getRegion(request);
    }

    @BetaApi
    public final Region getRegion(GetRegionHttpRequest request) {
        return (Region)this.getRegionCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionHttpRequest, Region> getRegionCallable() {
        return this.stub.getRegionCallable();
    }

    @BetaApi
    public final ListRegionsPagedResponse listRegions(ProjectName project) {
        ListRegionsHttpRequest request = ListRegionsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listRegions(request);
    }

    @BetaApi
    public final ListRegionsPagedResponse listRegions(String project) {
        ListRegionsHttpRequest request = ListRegionsHttpRequest.newBuilder().setProject(project).build();
        return this.listRegions(request);
    }

    @BetaApi
    public final ListRegionsPagedResponse listRegions(ListRegionsHttpRequest request) {
        return (ListRegionsPagedResponse)((Object)this.listRegionsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionsHttpRequest, ListRegionsPagedResponse> listRegionsPagedCallable() {
        return this.stub.listRegionsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionsHttpRequest, RegionList> listRegionsCallable() {
        return this.stub.listRegionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionsHttpRequest, RegionList, Region, ListRegionsPage, ListRegionsFixedSizeCollection> {
        private ListRegionsFixedSizeCollection(List<ListRegionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionsFixedSizeCollection createEmptyCollection() {
            return new ListRegionsFixedSizeCollection(null, 0);
        }

        protected ListRegionsFixedSizeCollection createCollection(List<ListRegionsPage> pages, int collectionSize) {
            return new ListRegionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionsPage
    extends AbstractPage<ListRegionsHttpRequest, RegionList, Region, ListRegionsPage> {
        private ListRegionsPage(PageContext<ListRegionsHttpRequest, RegionList, Region> context, RegionList response) {
            super(context, (Object)response);
        }

        private static ListRegionsPage createEmptyPage() {
            return new ListRegionsPage(null, null);
        }

        protected ListRegionsPage createPage(PageContext<ListRegionsHttpRequest, RegionList, Region> context, RegionList response) {
            return new ListRegionsPage(context, response);
        }

        public ApiFuture<ListRegionsPage> createPageAsync(PageContext<ListRegionsHttpRequest, RegionList, Region> context, ApiFuture<RegionList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionsPagedResponse
    extends AbstractPagedListResponse<ListRegionsHttpRequest, RegionList, Region, ListRegionsPage, ListRegionsFixedSizeCollection> {
        public static ApiFuture<ListRegionsPagedResponse> createAsync(PageContext<ListRegionsHttpRequest, RegionList, Region> context, ApiFuture<RegionList> futureResponse) {
            ApiFuture<ListRegionsPage> futurePage = ListRegionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionsPage, ListRegionsPagedResponse>(){

                public ListRegionsPagedResponse apply(ListRegionsPage input) {
                    return new ListRegionsPagedResponse(input);
                }
            });
        }

        private ListRegionsPagedResponse(ListRegionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

