/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetSslProxy
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String id;
    private final String kind;
    private final String name;
    private final String proxyHeader;
    private final String selfLink;
    private final String service;
    private final List<String> sslCertificates;
    private final String sslPolicy;
    private static final TargetSslProxy DEFAULT_INSTANCE = new TargetSslProxy();

    private TargetSslProxy() {
        this.creationTimestamp = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.proxyHeader = null;
        this.selfLink = null;
        this.service = null;
        this.sslCertificates = null;
        this.sslPolicy = null;
    }

    private TargetSslProxy(String creationTimestamp, String description, String id, String kind, String name, String proxyHeader, String selfLink, String service, List<String> sslCertificates, String sslPolicy) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.proxyHeader = proxyHeader;
        this.selfLink = selfLink;
        this.service = service;
        this.sslCertificates = sslCertificates;
        this.sslPolicy = sslPolicy;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("creationTimestamp")) {
            return this.creationTimestamp;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("proxyHeader")) {
            return this.proxyHeader;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        if (fieldName.equals("service")) {
            return this.service;
        }
        if (fieldName.equals("sslCertificates")) {
            return this.sslCertificates;
        }
        if (fieldName.equals("sslPolicy")) {
            return this.sslPolicy;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getProxyHeader() {
        return this.proxyHeader;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getService() {
        return this.service;
    }

    public List<String> getSslCertificatesList() {
        return this.sslCertificates;
    }

    public String getSslPolicy() {
        return this.sslPolicy;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetSslProxy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetSslProxy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetSslProxy{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", proxyHeader=" + this.proxyHeader + ", selfLink=" + this.selfLink + ", service=" + this.service + ", sslCertificates=" + this.sslCertificates + ", sslPolicy=" + this.sslPolicy + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetSslProxy) {
            TargetSslProxy that = (TargetSslProxy)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.proxyHeader, that.getProxyHeader()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.service, that.getService()) && Objects.equals(this.sslCertificates, that.getSslCertificatesList()) && Objects.equals(this.sslPolicy, that.getSslPolicy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.id, this.kind, this.name, this.proxyHeader, this.selfLink, this.service, this.sslCertificates, this.sslPolicy);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String id;
        private String kind;
        private String name;
        private String proxyHeader;
        private String selfLink;
        private String service;
        private List<String> sslCertificates;
        private String sslPolicy;

        Builder() {
        }

        public Builder mergeFrom(TargetSslProxy other) {
            if (other == TargetSslProxy.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getProxyHeader() != null) {
                this.proxyHeader = other.proxyHeader;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getService() != null) {
                this.service = other.service;
            }
            if (other.getSslCertificatesList() != null) {
                this.sslCertificates = other.sslCertificates;
            }
            if (other.getSslPolicy() != null) {
                this.sslPolicy = other.sslPolicy;
            }
            return this;
        }

        Builder(TargetSslProxy source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.proxyHeader = source.proxyHeader;
            this.selfLink = source.selfLink;
            this.service = source.service;
            this.sslCertificates = source.sslCertificates;
            this.sslPolicy = source.sslPolicy;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getProxyHeader() {
            return this.proxyHeader;
        }

        public Builder setProxyHeader(String proxyHeader) {
            this.proxyHeader = proxyHeader;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getService() {
            return this.service;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public List<String> getSslCertificatesList() {
            return this.sslCertificates;
        }

        public Builder addAllSslCertificates(List<String> sslCertificates) {
            if (this.sslCertificates == null) {
                this.sslCertificates = new ArrayList<String>(sslCertificates.size());
            }
            this.sslCertificates.addAll(sslCertificates);
            return this;
        }

        public Builder addSslCertificates(String sslCertificates) {
            this.sslCertificates.add(sslCertificates);
            return this;
        }

        public String getSslPolicy() {
            return this.sslPolicy;
        }

        public Builder setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public TargetSslProxy build() {
            return new TargetSslProxy(this.creationTimestamp, this.description, this.id, this.kind, this.name, this.proxyHeader, this.selfLink, this.service, this.sslCertificates, this.sslPolicy);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setProxyHeader(this.proxyHeader);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setService(this.service);
            newBuilder.addAllSslCertificates(this.sslCertificates);
            newBuilder.setSslPolicy(this.sslPolicy);
            return newBuilder;
        }
    }
}

