/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInfo;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;

public class Network
extends NetworkInfo {
    private static final long serialVersionUID = 8608280908101278096L;
    private final ComputeOptions options;
    private transient Compute compute;

    Network(Compute compute, NetworkInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.options();
    }

    public boolean exists() {
        return this.reload(Compute.NetworkOption.fields(new Compute.NetworkField[0])) != null;
    }

    public Network reload(Compute.NetworkOption ... options) {
        return this.compute.getNetwork(this.networkId().network(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteNetwork(this.networkId().network(), options);
    }

    public Operation createSubnetwork(SubnetworkId subnetworkId, String ipRange, Compute.OperationOption ... options) {
        return this.compute.create(SubnetworkInfo.of(subnetworkId, this.networkId(), ipRange), options);
    }

    public Compute compute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Network.class)) {
            return false;
        }
        Network other = (Network)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.service();
    }

    static Network fromPb(Compute compute, com.google.api.services.compute.model.Network networkPb) {
        return new Network(compute, new NetworkInfo.BuilderImpl(networkPb));
    }

    public static class Builder
    extends NetworkInfo.Builder {
        private final Compute compute;
        private final NetworkInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, NetworkId networkId, NetworkConfiguration configuration) {
            this.compute = compute;
            this.infoBuilder = new NetworkInfo.BuilderImpl(networkId, configuration);
            this.infoBuilder.networkId(networkId);
            this.infoBuilder.configuration(configuration);
        }

        Builder(Network subnetwork) {
            this.compute = subnetwork.compute;
            this.infoBuilder = new NetworkInfo.BuilderImpl(subnetwork);
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        Builder creationTimestamp(Long creationTimestamp) {
            this.infoBuilder.creationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        public Builder networkId(NetworkId networkId) {
            this.infoBuilder.networkId(networkId);
            return this;
        }

        @Override
        public Builder description(String description) {
            this.infoBuilder.description(description);
            return this;
        }

        @Override
        public Builder configuration(NetworkConfiguration configuration) {
            this.infoBuilder.configuration(configuration);
            return this;
        }

        @Override
        public Network build() {
            return new Network(this.compute, this.infoBuilder);
        }
    }
}

