/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.core.ApiClock;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.BaseService;
import com.google.cloud.PageImpl;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.compute.Address;
import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.AddressInfo;
import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeException;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.Disk;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskInfo;
import com.google.cloud.compute.DiskType;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.Image;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.Instance;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.InstanceInfo;
import com.google.cloud.compute.License;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.MachineType;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.Metadata;
import com.google.cloud.compute.Network;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInfo;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.Option;
import com.google.cloud.compute.Region;
import com.google.cloud.compute.RegionAddressId;
import com.google.cloud.compute.RegionOperationId;
import com.google.cloud.compute.SchedulingOptions;
import com.google.cloud.compute.Snapshot;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.cloud.compute.Subnetwork;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import com.google.cloud.compute.Tags;
import com.google.cloud.compute.Zone;
import com.google.cloud.compute.ZoneOperationId;
import com.google.cloud.compute.spi.v1.ComputeRpc;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.Callable;

final class ComputeImpl
extends BaseService<ComputeOptions>
implements Compute {
    private final ComputeRpc computeRpc;

    ComputeImpl(ComputeOptions options) {
        super((ServiceOptions)options);
        this.computeRpc = options.getComputeRpcV1();
    }

    @Override
    public DiskType getDiskType(final DiskTypeId diskTypeId, Compute.DiskTypeOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.DiskType answer = (com.google.api.services.compute.model.DiskType)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.DiskType>(){

                @Override
                public com.google.api.services.compute.model.DiskType call() {
                    return ComputeImpl.this.computeRpc.getDiskType(diskTypeId.getZone(), diskTypeId.getType(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : DiskType.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public DiskType getDiskType(String zone, String diskType, Compute.DiskTypeOption ... options) {
        return this.getDiskType(DiskTypeId.of(zone, diskType), options);
    }

    @Override
    public Page<DiskType> listDiskTypes(String zone, Compute.DiskTypeListOption ... options) {
        return ComputeImpl.listDiskTypes(zone, (ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<DiskType> listDiskTypes(final String zone, final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.DiskType>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.DiskType>> call() {
                    return serviceOptions.getComputeRpcV1().listDiskTypes(zone, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable diskTypes = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), (Function)new Function<com.google.api.services.compute.model.DiskType, DiskType>(){

                public DiskType apply(com.google.api.services.compute.model.DiskType diskType) {
                    return DiskType.fromPb(diskType);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new DiskTypePageFetcher(zone, serviceOptions, cursor, optionsMap), cursor, diskTypes);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<DiskType> listDiskTypes(Compute.DiskTypeAggregatedListOption ... options) {
        return ComputeImpl.listDiskTypes((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<DiskType> listDiskTypes(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.DiskType>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.DiskType>> call() {
                    return serviceOptions.getComputeRpcV1().listDiskTypes(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable diskTypes = Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.compute.model.DiskType, DiskType>(){

                public DiskType apply(com.google.api.services.compute.model.DiskType diskType) {
                    return DiskType.fromPb(diskType);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new AggregatedDiskTypePageFetcher(serviceOptions, cursor, optionsMap), cursor, diskTypes);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public MachineType getMachineType(final MachineTypeId machineType, Compute.MachineTypeOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.MachineType answer = (com.google.api.services.compute.model.MachineType)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.MachineType>(){

                @Override
                public com.google.api.services.compute.model.MachineType call() {
                    return ComputeImpl.this.computeRpc.getMachineType(machineType.getZone(), machineType.getType(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : MachineType.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public MachineType getMachineType(String zone, String machineType, Compute.MachineTypeOption ... options) {
        return this.getMachineType(MachineTypeId.of(zone, machineType), options);
    }

    @Override
    public Page<MachineType> listMachineTypes(String zone, Compute.MachineTypeListOption ... options) {
        return ComputeImpl.listMachineTypes(zone, (ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<MachineType> listMachineTypes(final String zone, final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.MachineType>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.MachineType>> call() {
                    return serviceOptions.getComputeRpcV1().listMachineTypes(zone, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable machineTypes = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), (Function)new Function<com.google.api.services.compute.model.MachineType, MachineType>(){

                public MachineType apply(com.google.api.services.compute.model.MachineType machineType) {
                    return MachineType.fromPb(machineType);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new MachineTypePageFetcher(zone, serviceOptions, cursor, optionsMap), cursor, machineTypes);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<MachineType> listMachineTypes(Compute.MachineTypeAggregatedListOption ... options) {
        return ComputeImpl.listMachineTypes((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<MachineType> listMachineTypes(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.MachineType>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.MachineType>> call() {
                    return serviceOptions.getComputeRpcV1().listMachineTypes(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable machineTypes = Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.compute.model.MachineType, MachineType>(){

                public MachineType apply(com.google.api.services.compute.model.MachineType machineType) {
                    return MachineType.fromPb(machineType);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new AggregatedMachineTypePageFetcher(serviceOptions, cursor, optionsMap), cursor, machineTypes);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Region getRegion(final String region, Compute.RegionOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Region answer = (com.google.api.services.compute.model.Region)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Region>(){

                @Override
                public com.google.api.services.compute.model.Region call() {
                    return ComputeImpl.this.computeRpc.getRegion(region, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Region.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Region> listRegions(Compute.RegionListOption ... options) {
        return ComputeImpl.listRegions((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Region> listRegions(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Region>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Region>> call() {
                    return serviceOptions.getComputeRpcV1().listRegions(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable regions = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), (Function)new Function<com.google.api.services.compute.model.Region, Region>(){

                public Region apply(com.google.api.services.compute.model.Region region) {
                    return Region.fromPb(region);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new RegionPageFetcher(serviceOptions, cursor, optionsMap), cursor, regions);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Zone getZone(final String zone, Compute.ZoneOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Zone answer = (com.google.api.services.compute.model.Zone)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Zone>(){

                @Override
                public com.google.api.services.compute.model.Zone call() {
                    return ComputeImpl.this.computeRpc.getZone(zone, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Zone.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Zone> listZones(Compute.ZoneListOption ... options) {
        return ComputeImpl.listZones((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Zone> listZones(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Zone>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Zone>> call() {
                    return serviceOptions.getComputeRpcV1().listZones(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable zones = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), (Function)new Function<com.google.api.services.compute.model.Zone, Zone>(){

                public Zone apply(com.google.api.services.compute.model.Zone zone) {
                    return Zone.fromPb(zone);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new ZonePageFetcher(serviceOptions, cursor, optionsMap), cursor, zones);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public License getLicense(String license, Compute.LicenseOption ... options) {
        return this.getLicense(LicenseId.of(license), options);
    }

    @Override
    public License getLicense(LicenseId license, Compute.LicenseOption ... options) {
        final LicenseId completeId = license.setProjectId(((ComputeOptions)this.getOptions()).getProjectId());
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.License answer = (com.google.api.services.compute.model.License)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.License>(){

                @Override
                public com.google.api.services.compute.model.License call() {
                    return ComputeImpl.this.computeRpc.getLicense(completeId.getProject(), completeId.getLicense(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : License.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation getOperation(final OperationId operationId, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    switch (operationId.getType()) {
                        case REGION: {
                            RegionOperationId regionOperationId = (RegionOperationId)operationId;
                            return ComputeImpl.this.computeRpc.getRegionOperation(regionOperationId.getRegion(), regionOperationId.getOperation(), optionsMap);
                        }
                        case ZONE: {
                            ZoneOperationId zoneOperationId = (ZoneOperationId)operationId;
                            return ComputeImpl.this.computeRpc.getZoneOperation(zoneOperationId.getZone(), zoneOperationId.getOperation(), optionsMap);
                        }
                        case GLOBAL: {
                            return ComputeImpl.this.computeRpc.getGlobalOperation(operationId.getOperation(), optionsMap);
                        }
                    }
                    throw new IllegalArgumentException("Unexpected operation identity type");
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    private static Function<com.google.api.services.compute.model.Operation, Operation> operationFromPb(final ComputeOptions serviceOptions) {
        return new Function<com.google.api.services.compute.model.Operation, Operation>(){

            public Operation apply(com.google.api.services.compute.model.Operation operation) {
                return Operation.fromPb((Compute)serviceOptions.getService(), operation);
            }
        };
    }

    @Override
    public Page<Operation> listGlobalOperations(Compute.OperationListOption ... options) {
        return ComputeImpl.listGlobalOperations((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Operation> listGlobalOperations(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Operation>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Operation>> call() {
                    return serviceOptions.getComputeRpcV1().listGlobalOperations(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable operations = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.operationFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new GlobalOperationPageFetcher(serviceOptions, cursor, optionsMap), cursor, operations);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Operation> listRegionOperations(String region, Compute.OperationListOption ... options) {
        return ComputeImpl.listRegionOperations(region, (ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Operation> listRegionOperations(final String region, final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Operation>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Operation>> call() {
                    return serviceOptions.getComputeRpcV1().listRegionOperations(region, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable operations = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.operationFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new RegionOperationPageFetcher(region, serviceOptions, cursor, optionsMap), cursor, operations);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Operation> listZoneOperations(String zone, Compute.OperationListOption ... options) {
        return ComputeImpl.listZoneOperations(zone, (ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Operation> listZoneOperations(final String zone, final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Operation>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Operation>> call() {
                    return serviceOptions.getComputeRpcV1().listZoneOperations(zone, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable operations = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.operationFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new ZoneOperationPageFetcher(zone, serviceOptions, cursor, optionsMap), cursor, operations);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public boolean deleteOperation(final OperationId operation) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    switch (operation.getType()) {
                        case REGION: {
                            RegionOperationId regionOperationId = (RegionOperationId)operation;
                            return ComputeImpl.this.computeRpc.deleteRegionOperation(regionOperationId.getRegion(), regionOperationId.getOperation());
                        }
                        case ZONE: {
                            ZoneOperationId zoneOperationId = (ZoneOperationId)operation;
                            return ComputeImpl.this.computeRpc.deleteZoneOperation(zoneOperationId.getZone(), zoneOperationId.getOperation());
                        }
                        case GLOBAL: {
                            return ComputeImpl.this.computeRpc.deleteGlobalOperation(operation.getOperation());
                        }
                    }
                    throw new IllegalArgumentException("Unexpected operation identity type");
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Address getAddress(final AddressId addressId, Compute.AddressOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Address answer = (com.google.api.services.compute.model.Address)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Address>(){

                @Override
                public com.google.api.services.compute.model.Address call() {
                    switch (addressId.getType()) {
                        case REGION: {
                            RegionAddressId regionAddressId = (RegionAddressId)addressId;
                            return ComputeImpl.this.computeRpc.getRegionAddress(regionAddressId.getRegion(), regionAddressId.getAddress(), optionsMap);
                        }
                        case GLOBAL: {
                            return ComputeImpl.this.computeRpc.getGlobalAddress(addressId.getAddress(), optionsMap);
                        }
                    }
                    throw new IllegalArgumentException("Unexpected address identity type");
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Address.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation create(final AddressInfo address, Compute.OperationOption ... options) {
        final com.google.api.services.compute.model.Address addressPb = address.setProjectId(((ComputeOptions)this.getOptions()).getProjectId()).toPb();
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return Operation.fromPb(this, (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    switch (((AddressId)address.getAddressId()).getType()) {
                        case REGION: {
                            RegionAddressId regionAddressId = (RegionAddressId)address.getAddressId();
                            return ComputeImpl.this.computeRpc.createRegionAddress(regionAddressId.getRegion(), addressPb, optionsMap);
                        }
                        case GLOBAL: {
                            return ComputeImpl.this.computeRpc.createGlobalAddress(addressPb, optionsMap);
                        }
                    }
                    throw new IllegalArgumentException("Unexpected address identity type");
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    private static Function<com.google.api.services.compute.model.Address, Address> addressFromPb(final ComputeOptions serviceOptions) {
        return new Function<com.google.api.services.compute.model.Address, Address>(){

            public Address apply(com.google.api.services.compute.model.Address address) {
                return Address.fromPb((Compute)serviceOptions.getService(), address);
            }
        };
    }

    @Override
    public Page<Address> listGlobalAddresses(Compute.AddressListOption ... options) {
        return ComputeImpl.listGlobalAddresses((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Address> listGlobalAddresses(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Address>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Address>> call() {
                    return serviceOptions.getComputeRpcV1().listGlobalAddresses(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable operations = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.addressFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new GlobalAddressPageFetcher(serviceOptions, cursor, optionsMap), cursor, operations);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Address> listRegionAddresses(String region, Compute.AddressListOption ... options) {
        return ComputeImpl.listRegionAddresses(region, (ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Address> listRegionAddresses(final String region, final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Address>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Address>> call() {
                    return serviceOptions.getComputeRpcV1().listRegionAddresses(region, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable operations = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.addressFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new RegionAddressPageFetcher(region, serviceOptions, cursor, optionsMap), cursor, operations);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Address> listAddresses(Compute.AddressAggregatedListOption ... options) {
        return ComputeImpl.listAddresses((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Address> listAddresses(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Address>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Address>> call() {
                    return serviceOptions.getComputeRpcV1().listAddresses(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable operations = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), (Function)new Function<com.google.api.services.compute.model.Address, Address>(){

                public Address apply(com.google.api.services.compute.model.Address address) {
                    return Address.fromPb((Compute)serviceOptions.getService(), address);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new AggregatedAddressPageFetcher(serviceOptions, cursor, optionsMap), cursor, operations);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation deleteAddress(final AddressId addressId, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    switch (addressId.getType()) {
                        case REGION: {
                            RegionAddressId regionAddressId = (RegionAddressId)addressId;
                            return ComputeImpl.this.computeRpc.deleteRegionAddress(regionAddressId.getRegion(), regionAddressId.getAddress(), optionsMap);
                        }
                        case GLOBAL: {
                            return ComputeImpl.this.computeRpc.deleteGlobalAddress(addressId.getAddress(), optionsMap);
                        }
                    }
                    throw new IllegalArgumentException("Unexpected address identity type");
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation create(SnapshotInfo snapshot, Compute.OperationOption ... options) {
        final SnapshotInfo completeSnapshot = snapshot.setProjectId(((ComputeOptions)this.getOptions()).getProjectId());
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.createSnapshot(completeSnapshot.getSourceDisk().getZone(), completeSnapshot.getSourceDisk().getDisk(), completeSnapshot.getSnapshotId().getSnapshot(), completeSnapshot.getDescription(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Snapshot getSnapshot(final String snapshot, Compute.SnapshotOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Snapshot answer = (com.google.api.services.compute.model.Snapshot)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Snapshot>(){

                @Override
                public com.google.api.services.compute.model.Snapshot call() {
                    return ComputeImpl.this.computeRpc.getSnapshot(snapshot, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Snapshot.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Snapshot> listSnapshots(Compute.SnapshotListOption ... options) {
        return ComputeImpl.listSnapshots((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Snapshot> listSnapshots(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Snapshot>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Snapshot>> call() {
                    return serviceOptions.getComputeRpcV1().listSnapshots(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable snapshots = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), (Function)new Function<com.google.api.services.compute.model.Snapshot, Snapshot>(){

                public Snapshot apply(com.google.api.services.compute.model.Snapshot snapshot) {
                    return Snapshot.fromPb((Compute)serviceOptions.getService(), snapshot);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new SnapshotPageFetcher(serviceOptions, cursor, optionsMap), cursor, snapshots);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation deleteSnapshot(SnapshotId snapshot, Compute.OperationOption ... options) {
        return this.deleteSnapshot(snapshot.getSnapshot(), options);
    }

    @Override
    public Operation deleteSnapshot(final String snapshot, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.deleteSnapshot(snapshot, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation create(ImageInfo image, Compute.OperationOption ... options) {
        final ImageInfo completeImage = image.setProjectId(((ComputeOptions)this.getOptions()).getProjectId());
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.createImage(completeImage.toPb(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Image getImage(ImageId imageId, Compute.ImageOption ... options) {
        final ImageId completeImageId = imageId.setProjectId(((ComputeOptions)this.getOptions()).getProjectId());
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Image answer = (com.google.api.services.compute.model.Image)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Image>(){

                @Override
                public com.google.api.services.compute.model.Image call() {
                    return ComputeImpl.this.computeRpc.getImage(completeImageId.getProject(), completeImageId.getImage(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Image.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Image> listImages(String project, Compute.ImageListOption ... options) {
        return ComputeImpl.listImages(project, (ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    @Override
    public Page<Image> listImages(Compute.ImageListOption ... options) {
        return ComputeImpl.listImages(((ComputeOptions)this.getOptions()).getProjectId(), (ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Image> listImages(final String project, final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Image>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Image>> call() {
                    return serviceOptions.getComputeRpcV1().listImages(project, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable images = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), (Function)new Function<com.google.api.services.compute.model.Image, Image>(){

                public Image apply(com.google.api.services.compute.model.Image image) {
                    return Image.fromPb((Compute)serviceOptions.getService(), image);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new ImagePageFetcher(project, serviceOptions, cursor, optionsMap), cursor, images);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation deleteImage(ImageId image, Compute.OperationOption ... options) {
        final ImageId completeId = image.setProjectId(((ComputeOptions)this.getOptions()).getProjectId());
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.deleteImage(completeId.getProject(), completeId.getImage(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation deprecate(ImageId image, final DeprecationStatus<ImageId> deprecationStatus, Compute.OperationOption ... options) {
        final ImageId completeId = image.setProjectId(((ComputeOptions)this.getOptions()).getProjectId());
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.deprecateImage(completeId.getProject(), completeId.getImage(), deprecationStatus.toPb(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Disk getDisk(final DiskId diskId, Compute.DiskOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Disk answer = (com.google.api.services.compute.model.Disk)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Disk>(){

                @Override
                public com.google.api.services.compute.model.Disk call() {
                    return ComputeImpl.this.computeRpc.getDisk(diskId.getZone(), diskId.getDisk(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Disk.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation create(final DiskInfo disk, Compute.OperationOption ... options) {
        final com.google.api.services.compute.model.Disk diskPb = disk.setProjectId(((ComputeOptions)this.getOptions()).getProjectId()).toPb();
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return Operation.fromPb(this, (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.createDisk(disk.getDiskId().getZone(), diskPb, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    private static Function<com.google.api.services.compute.model.Disk, Disk> diskFromPb(final ComputeOptions serviceOptions) {
        return new Function<com.google.api.services.compute.model.Disk, Disk>(){

            public Disk apply(com.google.api.services.compute.model.Disk disk) {
                return Disk.fromPb((Compute)serviceOptions.getService(), disk);
            }
        };
    }

    @Override
    public Page<Disk> listDisks(String zone, Compute.DiskListOption ... options) {
        return ComputeImpl.listDisks(zone, (ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Disk> listDisks(final String zone, final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Disk>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Disk>> call() {
                    return serviceOptions.getComputeRpcV1().listDisks(zone, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable disks = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.diskFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new DiskPageFetcher(zone, serviceOptions, cursor, optionsMap), cursor, disks);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Disk> listDisks(Compute.DiskAggregatedListOption ... options) {
        return ComputeImpl.listDisks((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Disk> listDisks(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Disk>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Disk>> call() {
                    return serviceOptions.getComputeRpcV1().listDisks(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable disks = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.diskFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new AggregatedDiskPageFetcher(serviceOptions, cursor, optionsMap), cursor, disks);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation deleteDisk(final DiskId disk, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.deleteDisk(disk.getZone(), disk.getDisk(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation resize(final DiskId disk, final long sizeGb, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.resizeDisk(disk.getZone(), disk.getDisk(), sizeGb, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation create(SubnetworkInfo subnetwork, Compute.OperationOption ... options) {
        final SubnetworkInfo completeSubnetwork = subnetwork.setProjectId(((ComputeOptions)this.getOptions()).getProjectId());
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.createSubnetwork(completeSubnetwork.getSubnetworkId().getRegion(), completeSubnetwork.toPb(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Subnetwork getSubnetwork(final SubnetworkId subnetworkId, Compute.SubnetworkOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Subnetwork answer = (com.google.api.services.compute.model.Subnetwork)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Subnetwork>(){

                @Override
                public com.google.api.services.compute.model.Subnetwork call() {
                    return ComputeImpl.this.computeRpc.getSubnetwork(subnetworkId.getRegion(), subnetworkId.getSubnetwork(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Subnetwork.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    private static Function<com.google.api.services.compute.model.Subnetwork, Subnetwork> subnetworkFromPb(final ComputeOptions serviceOptions) {
        return new Function<com.google.api.services.compute.model.Subnetwork, Subnetwork>(){

            public Subnetwork apply(com.google.api.services.compute.model.Subnetwork subnetwork) {
                return Subnetwork.fromPb((Compute)serviceOptions.getService(), subnetwork);
            }
        };
    }

    @Override
    public Page<Subnetwork> listSubnetworks(String region, Compute.SubnetworkListOption ... options) {
        return ComputeImpl.listSubnetworks(region, (ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Subnetwork> listSubnetworks(final String region, final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Subnetwork>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Subnetwork>> call() {
                    return serviceOptions.getComputeRpcV1().listSubnetworks(region, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable subnetworks = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.subnetworkFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new SubnetworkPageFetcher(region, serviceOptions, cursor, optionsMap), cursor, subnetworks);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Subnetwork> listSubnetworks(Compute.SubnetworkAggregatedListOption ... options) {
        return ComputeImpl.listSubnetworks((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Subnetwork> listSubnetworks(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Subnetwork>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Subnetwork>> call() {
                    return serviceOptions.getComputeRpcV1().listSubnetworks(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable subnetworks = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.subnetworkFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new AggregatedSubnetworkPageFetcher(serviceOptions, cursor, optionsMap), cursor, subnetworks);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation deleteSubnetwork(final SubnetworkId subnetwork, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.deleteSubnetwork(subnetwork.getRegion(), subnetwork.getSubnetwork(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation create(NetworkInfo network, Compute.OperationOption ... options) {
        final NetworkInfo completeNetwork = network.setProjectId(((ComputeOptions)this.getOptions()).getProjectId());
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.createNetwork(completeNetwork.toPb(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Network getNetwork(final String network, Compute.NetworkOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Network answer = (com.google.api.services.compute.model.Network)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Network>(){

                @Override
                public com.google.api.services.compute.model.Network call() {
                    return ComputeImpl.this.computeRpc.getNetwork(network, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Network.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Network> listNetworks(Compute.NetworkListOption ... options) {
        return ComputeImpl.listNetworks((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Network> listNetworks(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Network>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Network>> call() {
                    return serviceOptions.getComputeRpcV1().listNetworks(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable networks = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), (Function)new Function<com.google.api.services.compute.model.Network, Network>(){

                public Network apply(com.google.api.services.compute.model.Network network) {
                    return Network.fromPb((Compute)serviceOptions.getService(), network);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new NetworkPageFetcher(serviceOptions, cursor, optionsMap), cursor, networks);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation deleteNetwork(final NetworkId network, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.deleteNetwork(network.getNetwork(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation deleteNetwork(String network, Compute.OperationOption ... options) {
        return this.deleteNetwork(NetworkId.of(network), new Compute.OperationOption[0]);
    }

    @Override
    public Operation create(InstanceInfo instance, Compute.OperationOption ... options) {
        final InstanceInfo completeInstance = instance.setProjectId(((ComputeOptions)this.getOptions()).getProjectId());
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.createInstance(completeInstance.getInstanceId().getZone(), completeInstance.toPb(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Instance getInstance(final InstanceId instance, Compute.InstanceOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Instance answer = (com.google.api.services.compute.model.Instance)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Instance>(){

                @Override
                public com.google.api.services.compute.model.Instance call() {
                    return ComputeImpl.this.computeRpc.getInstance(instance.getZone(), instance.getInstance(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Instance.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    private static Function<com.google.api.services.compute.model.Instance, Instance> instanceFromPb(final ComputeOptions serviceOptions) {
        return new Function<com.google.api.services.compute.model.Instance, Instance>(){

            public Instance apply(com.google.api.services.compute.model.Instance instance) {
                return Instance.fromPb((Compute)serviceOptions.getService(), instance);
            }
        };
    }

    @Override
    public Page<Instance> listInstances(String zone, Compute.InstanceListOption ... options) {
        return ComputeImpl.listInstances(zone, (ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Instance> listInstances(final String zone, final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Instance>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Instance>> call() {
                    return serviceOptions.getComputeRpcV1().listInstances(zone, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable instances = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.instanceFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new InstancePageFetcher(zone, serviceOptions, cursor, optionsMap), cursor, instances);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Instance> listInstances(Compute.InstanceAggregatedListOption ... options) {
        return ComputeImpl.listInstances((ComputeOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Instance> listInstances(final ComputeOptions serviceOptions, final Map<ComputeRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.compute.model.Instance>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.compute.model.Instance>> call() {
                    return serviceOptions.getComputeRpcV1().listInstances(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable instances = Iterables.transform((Iterable)(result.y() == null ? ImmutableList.of() : (Iterable)result.y()), ComputeImpl.instanceFromPb(serviceOptions));
            return new PageImpl((PageImpl.NextPageFetcher)new AggregatedInstancePageFetcher(serviceOptions, cursor, optionsMap), cursor, instances);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation deleteInstance(final InstanceId instance, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.deleteInstance(instance.getZone(), instance.getInstance(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation addAccessConfig(final InstanceId instance, final String networkInterface, final NetworkInterface.AccessConfig accessConfig, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.addAccessConfig(instance.getZone(), instance.getInstance(), networkInterface, accessConfig.toPb(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    private Operation attachDisk(final InstanceId instance, AttachedDisk diskToAttach, Compute.OperationOption ... options) {
        final AttachedDisk completeDisk = diskToAttach.setProjectId(((ComputeOptions)this.getOptions()).getProjectId());
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.attachDisk(instance.getZone(), instance.getInstance(), completeDisk.toPb(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation attachDisk(InstanceId instance, AttachedDisk.PersistentDiskConfiguration configuration, Compute.OperationOption ... options) {
        return this.attachDisk(instance, AttachedDisk.of(configuration), options);
    }

    @Override
    public Operation attachDisk(InstanceId instance, String deviceName, AttachedDisk.PersistentDiskConfiguration configuration, Compute.OperationOption ... options) {
        return this.attachDisk(instance, AttachedDisk.of(deviceName, configuration), options);
    }

    @Override
    public Operation attachDisk(InstanceId instance, String deviceName, AttachedDisk.PersistentDiskConfiguration configuration, int index, Compute.OperationOption ... options) {
        AttachedDisk attachedDisk = AttachedDisk.newBuilder(configuration).setDeviceName(deviceName).setIndex(index).build();
        return this.attachDisk(instance, attachedDisk, options);
    }

    @Override
    public Operation deleteAccessConfig(final InstanceId instance, final String networkInterface, final String accessConfig, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.deleteAccessConfig(instance.getZone(), instance.getInstance(), networkInterface, accessConfig, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation detachDisk(final InstanceId instance, final String deviceName, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.detachDisk(instance.getZone(), instance.getInstance(), deviceName, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public String getSerialPortOutput(final InstanceId instance, final int port) {
        try {
            return (String)RetryHelper.runWithRetries((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return ComputeImpl.this.computeRpc.getSerialPortOutput(instance.getZone(), instance.getInstance(), port, ComputeImpl.this.optionMap(new Option[0]));
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public String getSerialPortOutput(final InstanceId instance) {
        try {
            return (String)RetryHelper.runWithRetries((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return ComputeImpl.this.computeRpc.getSerialPortOutput(instance.getZone(), instance.getInstance(), null, ComputeImpl.this.optionMap(new Option[0]));
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation reset(final InstanceId instance, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.reset(instance.getZone(), instance.getInstance(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation setDiskAutoDelete(final InstanceId instance, final String deviceName, final boolean autoDelete, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.setDiskAutoDelete(instance.getZone(), instance.getInstance(), deviceName, autoDelete, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation setMachineType(final InstanceId instance, MachineTypeId machineType, Compute.OperationOption ... options) {
        final String machineTypeUrl = machineType.setProjectId(((ComputeOptions)this.getOptions()).getProjectId()).getSelfLink();
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.setMachineType(instance.getZone(), instance.getInstance(), machineTypeUrl, optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation setMetadata(final InstanceId instance, final Metadata metadata, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.setMetadata(instance.getZone(), instance.getInstance(), metadata.toPb(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation setSchedulingOptions(final InstanceId instance, final SchedulingOptions schedulingOptions, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.setScheduling(instance.getZone(), instance.getInstance(), schedulingOptions.toPb(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation setTags(final InstanceId instance, final Tags tags, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.setTags(instance.getZone(), instance.getInstance(), tags.toPb(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation start(final InstanceId instance, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.start(instance.getZone(), instance.getInstance(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    @Override
    public Operation stop(final InstanceId instance, Compute.OperationOption ... options) {
        final Map<ComputeRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.compute.model.Operation answer = (com.google.api.services.compute.model.Operation)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.compute.model.Operation>(){

                @Override
                public com.google.api.services.compute.model.Operation call() {
                    return ComputeImpl.this.computeRpc.stop(instance.getZone(), instance.getInstance(), optionsMap);
                }
            }, (RetrySettings)((ComputeOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ComputeOptions)this.getOptions()).getClock());
            return answer == null ? null : Operation.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ComputeException.translateAndThrow(e);
        }
    }

    private Map<ComputeRpc.Option, ?> optionMap(Option ... options) {
        EnumMap optionMap = Maps.newEnumMap(ComputeRpc.Option.class);
        for (Option option : options) {
            Object prev = optionMap.put(option.getRpcOption(), option.getValue());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object)option);
        }
        return optionMap;
    }

    private static class AggregatedInstancePageFetcher
    implements PageImpl.NextPageFetcher<Instance> {
        private static final long serialVersionUID = 1863059389783095681L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        AggregatedInstancePageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Instance> getNextPage() {
            return ComputeImpl.listInstances(this.serviceOptions, this.requestOptions);
        }
    }

    private static class InstancePageFetcher
    implements PageImpl.NextPageFetcher<Instance> {
        private static final long serialVersionUID = 7563769742657453865L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;
        private final String zone;

        InstancePageFetcher(String zone, ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.zone = zone;
        }

        public Page<Instance> getNextPage() {
            return ComputeImpl.listInstances(this.zone, this.serviceOptions, this.requestOptions);
        }
    }

    private static class NetworkPageFetcher
    implements PageImpl.NextPageFetcher<Network> {
        private static final long serialVersionUID = 5580210850353114531L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        NetworkPageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Network> getNextPage() {
            return ComputeImpl.listNetworks(this.serviceOptions, this.requestOptions);
        }
    }

    private static class AggregatedSubnetworkPageFetcher
    implements PageImpl.NextPageFetcher<Subnetwork> {
        private static final long serialVersionUID = 771343548833894551L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        AggregatedSubnetworkPageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Subnetwork> getNextPage() {
            return ComputeImpl.listSubnetworks(this.serviceOptions, this.requestOptions);
        }
    }

    private static class SubnetworkPageFetcher
    implements PageImpl.NextPageFetcher<Subnetwork> {
        private static final long serialVersionUID = 3674038457884412651L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;
        private final String region;

        SubnetworkPageFetcher(String region, ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.region = region;
        }

        public Page<Subnetwork> getNextPage() {
            return ComputeImpl.listSubnetworks(this.region, this.serviceOptions, this.requestOptions);
        }
    }

    private static class AggregatedDiskPageFetcher
    implements PageImpl.NextPageFetcher<Disk> {
        private static final long serialVersionUID = -5240045334115926206L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        AggregatedDiskPageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Disk> getNextPage() {
            return ComputeImpl.listDisks(this.serviceOptions, this.requestOptions);
        }
    }

    private static class DiskPageFetcher
    implements PageImpl.NextPageFetcher<Disk> {
        private static final long serialVersionUID = 4146589787872718476L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;
        private final String zone;

        DiskPageFetcher(String zone, ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.zone = zone;
        }

        public Page<Disk> getNextPage() {
            return ComputeImpl.listDisks(this.zone, this.serviceOptions, this.requestOptions);
        }
    }

    private static class ImagePageFetcher
    implements PageImpl.NextPageFetcher<Image> {
        private static final long serialVersionUID = 6403679803137922023L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;
        private final String project;

        ImagePageFetcher(String project, ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.project = project;
        }

        public Page<Image> getNextPage() {
            return ComputeImpl.listImages(this.project, this.serviceOptions, this.requestOptions);
        }
    }

    private static class SnapshotPageFetcher
    implements PageImpl.NextPageFetcher<Snapshot> {
        private static final long serialVersionUID = 6205774609802216986L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        SnapshotPageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Snapshot> getNextPage() {
            return ComputeImpl.listSnapshots(this.serviceOptions, this.requestOptions);
        }
    }

    private static class AggregatedAddressPageFetcher
    implements PageImpl.NextPageFetcher<Address> {
        private static final long serialVersionUID = -5798942282919494950L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        AggregatedAddressPageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Address> getNextPage() {
            return ComputeImpl.listAddresses(this.serviceOptions, this.requestOptions);
        }
    }

    private static class RegionAddressPageFetcher
    implements PageImpl.NextPageFetcher<Address> {
        private static final long serialVersionUID = 7080596594494397027L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;
        private final String region;

        RegionAddressPageFetcher(String region, ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.region = region;
        }

        public Page<Address> getNextPage() {
            return ComputeImpl.listRegionAddresses(this.region, this.serviceOptions, this.requestOptions);
        }
    }

    private static class GlobalAddressPageFetcher
    implements PageImpl.NextPageFetcher<Address> {
        private static final long serialVersionUID = -3832055341507574454L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        GlobalAddressPageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Address> getNextPage() {
            return ComputeImpl.listGlobalAddresses(this.serviceOptions, this.requestOptions);
        }
    }

    private static class ZoneOperationPageFetcher
    implements PageImpl.NextPageFetcher<Operation> {
        private static final long serialVersionUID = -9012504536518197793L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;
        private final String zone;

        ZoneOperationPageFetcher(String zone, ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.zone = zone;
        }

        public Page<Operation> getNextPage() {
            return ComputeImpl.listZoneOperations(this.zone, this.serviceOptions, this.requestOptions);
        }
    }

    private static class RegionOperationPageFetcher
    implements PageImpl.NextPageFetcher<Operation> {
        private static final long serialVersionUID = 4111705358926164078L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;
        private final String region;

        RegionOperationPageFetcher(String region, ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.region = region;
        }

        public Page<Operation> getNextPage() {
            return ComputeImpl.listRegionOperations(this.region, this.serviceOptions, this.requestOptions);
        }
    }

    private static class ZonePageFetcher
    implements PageImpl.NextPageFetcher<Zone> {
        private static final long serialVersionUID = -3946202621600687597L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        ZonePageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Zone> getNextPage() {
            return ComputeImpl.listZones(this.serviceOptions, this.requestOptions);
        }
    }

    private static class RegionPageFetcher
    implements PageImpl.NextPageFetcher<Region> {
        private static final long serialVersionUID = 4180147045485258863L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        RegionPageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Region> getNextPage() {
            return ComputeImpl.listRegions(this.serviceOptions, this.requestOptions);
        }
    }

    private static class AggregatedMachineTypePageFetcher
    implements PageImpl.NextPageFetcher<MachineType> {
        private static final long serialVersionUID = 2919227789802660026L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        AggregatedMachineTypePageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<MachineType> getNextPage() {
            return ComputeImpl.listMachineTypes(this.serviceOptions, this.requestOptions);
        }
    }

    private static class MachineTypePageFetcher
    implements PageImpl.NextPageFetcher<MachineType> {
        private static final long serialVersionUID = -5048133000517001933L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;
        private final String zone;

        MachineTypePageFetcher(String zone, ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.zone = zone;
        }

        public Page<MachineType> getNextPage() {
            return ComputeImpl.listMachineTypes(this.zone, this.serviceOptions, this.requestOptions);
        }
    }

    private static class AggregatedDiskTypePageFetcher
    implements PageImpl.NextPageFetcher<DiskType> {
        private static final long serialVersionUID = -1664743503750307996L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        AggregatedDiskTypePageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<DiskType> getNextPage() {
            return ComputeImpl.listDiskTypes(this.serviceOptions, this.requestOptions);
        }
    }

    private static class DiskTypePageFetcher
    implements PageImpl.NextPageFetcher<DiskType> {
        private static final long serialVersionUID = -5253916264932522976L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;
        private final String zone;

        DiskTypePageFetcher(String zone, ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.zone = zone;
        }

        public Page<DiskType> getNextPage() {
            return ComputeImpl.listDiskTypes(this.zone, this.serviceOptions, this.requestOptions);
        }
    }

    private static class GlobalOperationPageFetcher
    implements PageImpl.NextPageFetcher<Operation> {
        private static final long serialVersionUID = -2488912172182315364L;
        private final Map<ComputeRpc.Option, ?> requestOptions;
        private final ComputeOptions serviceOptions;

        GlobalOperationPageFetcher(ComputeOptions serviceOptions, String cursor, Map<ComputeRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ComputeRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Operation> getNextPage() {
            return ComputeImpl.listGlobalOperations(this.serviceOptions, this.requestOptions);
        }
    }
}

