/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;

public class Snapshot
extends SnapshotInfo {
    private static final long serialVersionUID = -973924811396336695L;
    private final ComputeOptions options;
    private transient Compute compute;

    Snapshot(Compute compute, SnapshotInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.options();
    }

    public boolean exists() {
        return this.reload(Compute.SnapshotOption.fields(new Compute.SnapshotField[0])) != null;
    }

    public Snapshot reload(Compute.SnapshotOption ... options) {
        return this.compute.getSnapshot(this.snapshotId().snapshot(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteSnapshot(this.snapshotId(), options);
    }

    public Compute compute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Snapshot.class)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.service();
    }

    static Snapshot fromPb(Compute compute, com.google.api.services.compute.model.Snapshot snapshotPb) {
        return new Snapshot(compute, new SnapshotInfo.BuilderImpl(snapshotPb));
    }

    public static class Builder
    extends SnapshotInfo.Builder {
        private final Compute compute;
        private final SnapshotInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, SnapshotId snapshotId, DiskId sourceDisk) {
            this.compute = compute;
            this.infoBuilder = new SnapshotInfo.BuilderImpl();
            this.infoBuilder.snapshotId(snapshotId);
            this.infoBuilder.sourceDisk(sourceDisk);
        }

        Builder(Snapshot snapshot) {
            this.compute = snapshot.compute;
            this.infoBuilder = new SnapshotInfo.BuilderImpl(snapshot);
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        Builder creationTimestamp(Long creationTimestamp) {
            this.infoBuilder.creationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        public Builder snapshotId(SnapshotId snapshotId) {
            this.infoBuilder.snapshotId(snapshotId);
            return this;
        }

        @Override
        public Builder description(String description) {
            this.infoBuilder.description(description);
            return this;
        }

        @Override
        Builder status(SnapshotInfo.Status status) {
            this.infoBuilder.status(status);
            return this;
        }

        @Override
        Builder diskSizeGb(Long diskSizeGb) {
            this.infoBuilder.diskSizeGb(diskSizeGb);
            return this;
        }

        @Override
        Builder licenses(List<LicenseId> licenses) {
            this.infoBuilder.licenses((List)licenses);
            return this;
        }

        @Override
        public Builder sourceDisk(DiskId sourceDisk) {
            this.infoBuilder.sourceDisk(sourceDisk);
            return this;
        }

        @Override
        Builder sourceDiskId(String sourceDiskId) {
            this.infoBuilder.sourceDiskId(sourceDiskId);
            return this;
        }

        @Override
        Builder storageBytes(Long storageBytes) {
            this.infoBuilder.storageBytes(storageBytes);
            return this;
        }

        @Override
        Builder storageBytesStatus(SnapshotInfo.StorageBytesStatus storageBytesStatus) {
            this.infoBuilder.storageBytesStatus(storageBytesStatus);
            return this;
        }

        @Override
        public Snapshot build() {
            return new Snapshot(this.compute, this.infoBuilder);
        }
    }
}

