/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ZoneId
extends ResourceId {
    static final Function<String, ZoneId> FROM_URL_FUNCTION = new Function<String, ZoneId>(){

        public ZoneId apply(String pb) {
            return ZoneId.fromUrl(pb);
        }
    };
    static final Function<ZoneId, String> TO_URL_FUNCTION = new Function<ZoneId, String>(){

        public String apply(ZoneId zoneId) {
            return zoneId.getSelfLink();
        }
    };
    private static final String REGEX = ".*?projects/([^/]+)/zones/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/zones/([^/]+)");
    private static final long serialVersionUID = -7635391994812946733L;
    private final String zone;

    private ZoneId(String project, String zone) {
        super(project);
        this.zone = (String)Preconditions.checkNotNull((Object)zone);
    }

    public String getZone() {
        return this.zone;
    }

    @Override
    public String getSelfLink() {
        String string = String.valueOf(String.valueOf(super.getSelfLink()));
        String string2 = String.valueOf(String.valueOf(this.zone));
        return new StringBuilder(7 + string.length() + string2.length()).append(string).append("/zones/").append(string2).toString();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("zone", (Object)this.zone);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.zone);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ZoneId)) {
            return false;
        }
        ZoneId other = (ZoneId)obj;
        return this.baseEquals(other) && Objects.equals(this.zone, other.zone);
    }

    @Override
    ZoneId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return ZoneId.of(projectId, this.zone);
    }

    public static ZoneId of(String project, String zone) {
        return new ZoneId(project, zone);
    }

    public static ZoneId of(String zone) {
        return ZoneId.of(null, zone);
    }

    static boolean matchesUrl(String url) {
        return url.matches(REGEX);
    }

    static ZoneId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.valueOf(url).concat(" is not a valid zone URL"));
        }
        return ZoneId.of(matcher.group(1), matcher.group(2));
    }
}

