/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.AddressId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GlobalAddressId
extends AddressId {
    private static final String REGEX = ".*?projects/([^/]+)/global/addresses/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/global/addresses/([^/]+)");
    private static final long serialVersionUID = -2950815290049218593L;

    private GlobalAddressId(String project, String address) {
        super(project, address);
    }

    @Override
    public AddressId.Type getType() {
        return AddressId.Type.GLOBAL;
    }

    @Override
    public String getSelfLink() {
        String string = String.valueOf(String.valueOf(super.getSelfLink()));
        String string2 = String.valueOf(String.valueOf(this.getAddress()));
        return new StringBuilder(18 + string.length() + string2.length()).append(string).append("/global/addresses/").append(string2).toString();
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GlobalAddressId && this.baseEquals((GlobalAddressId)obj);
    }

    @Override
    GlobalAddressId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return GlobalAddressId.of(projectId, this.getAddress());
    }

    public static GlobalAddressId of(String address) {
        return new GlobalAddressId(null, address);
    }

    public static GlobalAddressId of(String project, String address) {
        return new GlobalAddressId(project, address);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static GlobalAddressId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.valueOf(url).concat(" is not a valid global address URL"));
        }
        return GlobalAddressId.of(matcher.group(1), matcher.group(2));
    }
}

