/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.gax.core.Page;
import com.google.cloud.FieldSelector;
import com.google.cloud.Service;
import com.google.cloud.compute.Address;
import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.AddressInfo;
import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.Disk;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskInfo;
import com.google.cloud.compute.DiskType;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.Image;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.Instance;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.InstanceInfo;
import com.google.cloud.compute.License;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.MachineType;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.Metadata;
import com.google.cloud.compute.Network;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInfo;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.Option;
import com.google.cloud.compute.Region;
import com.google.cloud.compute.SchedulingOptions;
import com.google.cloud.compute.Snapshot;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.cloud.compute.Subnetwork;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import com.google.cloud.compute.Tags;
import com.google.cloud.compute.Zone;
import com.google.cloud.compute.spi.v1.ComputeRpc;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public interface Compute
extends Service<ComputeOptions> {
    public DiskType getDiskType(DiskTypeId var1, DiskTypeOption ... var2);

    public DiskType getDiskType(String var1, String var2, DiskTypeOption ... var3);

    public Page<DiskType> listDiskTypes(String var1, DiskTypeListOption ... var2);

    public Page<DiskType> listDiskTypes(DiskTypeAggregatedListOption ... var1);

    public MachineType getMachineType(MachineTypeId var1, MachineTypeOption ... var2);

    public MachineType getMachineType(String var1, String var2, MachineTypeOption ... var3);

    public Page<MachineType> listMachineTypes(String var1, MachineTypeListOption ... var2);

    public Page<MachineType> listMachineTypes(MachineTypeAggregatedListOption ... var1);

    public Region getRegion(String var1, RegionOption ... var2);

    public Page<Region> listRegions(RegionListOption ... var1);

    public Zone getZone(String var1, ZoneOption ... var2);

    public Page<Zone> listZones(ZoneListOption ... var1);

    public License getLicense(String var1, LicenseOption ... var2);

    public License getLicense(LicenseId var1, LicenseOption ... var2);

    public Operation getOperation(OperationId var1, OperationOption ... var2);

    public Page<Operation> listGlobalOperations(OperationListOption ... var1);

    public Page<Operation> listRegionOperations(String var1, OperationListOption ... var2);

    public Page<Operation> listZoneOperations(String var1, OperationListOption ... var2);

    public boolean deleteOperation(OperationId var1);

    public Address getAddress(AddressId var1, AddressOption ... var2);

    public Operation create(AddressInfo var1, OperationOption ... var2);

    public Page<Address> listGlobalAddresses(AddressListOption ... var1);

    public Page<Address> listRegionAddresses(String var1, AddressListOption ... var2);

    public Page<Address> listAddresses(AddressAggregatedListOption ... var1);

    public Operation deleteAddress(AddressId var1, OperationOption ... var2);

    public Operation create(SnapshotInfo var1, OperationOption ... var2);

    public Snapshot getSnapshot(String var1, SnapshotOption ... var2);

    public Page<Snapshot> listSnapshots(SnapshotListOption ... var1);

    public Operation deleteSnapshot(SnapshotId var1, OperationOption ... var2);

    public Operation deleteSnapshot(String var1, OperationOption ... var2);

    public Operation create(ImageInfo var1, OperationOption ... var2);

    public Image getImage(ImageId var1, ImageOption ... var2);

    public Page<Image> listImages(String var1, ImageListOption ... var2);

    public Page<Image> listImages(ImageListOption ... var1);

    public Operation deleteImage(ImageId var1, OperationOption ... var2);

    public Operation deprecate(ImageId var1, DeprecationStatus<ImageId> var2, OperationOption ... var3);

    public Disk getDisk(DiskId var1, DiskOption ... var2);

    public Operation create(DiskInfo var1, OperationOption ... var2);

    public Page<Disk> listDisks(String var1, DiskListOption ... var2);

    public Page<Disk> listDisks(DiskAggregatedListOption ... var1);

    public Operation deleteDisk(DiskId var1, OperationOption ... var2);

    public Operation resize(DiskId var1, long var2, OperationOption ... var4);

    public Operation create(SubnetworkInfo var1, OperationOption ... var2);

    public Subnetwork getSubnetwork(SubnetworkId var1, SubnetworkOption ... var2);

    public Page<Subnetwork> listSubnetworks(String var1, SubnetworkListOption ... var2);

    public Page<Subnetwork> listSubnetworks(SubnetworkAggregatedListOption ... var1);

    public Operation deleteSubnetwork(SubnetworkId var1, OperationOption ... var2);

    public Operation create(NetworkInfo var1, OperationOption ... var2);

    public Network getNetwork(String var1, NetworkOption ... var2);

    public Page<Network> listNetworks(NetworkListOption ... var1);

    public Operation deleteNetwork(String var1, OperationOption ... var2);

    public Operation deleteNetwork(NetworkId var1, OperationOption ... var2);

    public Operation create(InstanceInfo var1, OperationOption ... var2);

    public Instance getInstance(InstanceId var1, InstanceOption ... var2);

    public Page<Instance> listInstances(String var1, InstanceListOption ... var2);

    public Page<Instance> listInstances(InstanceAggregatedListOption ... var1);

    public Operation deleteInstance(InstanceId var1, OperationOption ... var2);

    public Operation addAccessConfig(InstanceId var1, String var2, NetworkInterface.AccessConfig var3, OperationOption ... var4);

    public Operation attachDisk(InstanceId var1, AttachedDisk.PersistentDiskConfiguration var2, OperationOption ... var3);

    public Operation attachDisk(InstanceId var1, String var2, AttachedDisk.PersistentDiskConfiguration var3, OperationOption ... var4);

    public Operation attachDisk(InstanceId var1, String var2, AttachedDisk.PersistentDiskConfiguration var3, int var4, OperationOption ... var5);

    public Operation deleteAccessConfig(InstanceId var1, String var2, String var3, OperationOption ... var4);

    public Operation detachDisk(InstanceId var1, String var2, OperationOption ... var3);

    public String getSerialPortOutput(InstanceId var1, int var2);

    public String getSerialPortOutput(InstanceId var1);

    public Operation reset(InstanceId var1, OperationOption ... var2);

    public Operation setDiskAutoDelete(InstanceId var1, String var2, boolean var3, OperationOption ... var4);

    public Operation setMachineType(InstanceId var1, MachineTypeId var2, OperationOption ... var3);

    public Operation setMetadata(InstanceId var1, Metadata var2, OperationOption ... var3);

    public Operation setSchedulingOptions(InstanceId var1, SchedulingOptions var2, OperationOption ... var3);

    public Operation setTags(InstanceId var1, Tags var2, OperationOption ... var3);

    public Operation start(InstanceId var1, OperationOption ... var2);

    public Operation stop(InstanceId var1, OperationOption ... var2);

    public static class InstanceAggregatedListOption
    extends Option {
        private static final long serialVersionUID = -2020005298975967713L;

        private InstanceAggregatedListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static InstanceAggregatedListOption filter(InstanceFilter filter) {
            return new InstanceAggregatedListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static InstanceAggregatedListOption pageSize(long pageSize) {
            return new InstanceAggregatedListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static InstanceAggregatedListOption pageToken(String pageToken) {
            return new InstanceAggregatedListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }
    }

    public static class InstanceListOption
    extends Option {
        private static final long serialVersionUID = -1096684312959047430L;

        private InstanceListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static InstanceListOption filter(InstanceFilter filter) {
            return new InstanceListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static InstanceListOption pageSize(long pageSize) {
            return new InstanceListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static InstanceListOption pageToken(String pageToken) {
            return new InstanceListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static InstanceListOption fields(InstanceField ... fields) {
            return new InstanceListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", InstanceField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class InstanceOption
    extends Option {
        private static final long serialVersionUID = -5277658025892081493L;

        private InstanceOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static InstanceOption fields(InstanceField ... fields) {
            return new InstanceOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(InstanceField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class NetworkListOption
    extends Option {
        private static final long serialVersionUID = -4291731916527773896L;

        private NetworkListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static NetworkListOption filter(NetworkFilter filter) {
            return new NetworkListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static NetworkListOption pageSize(long pageSize) {
            return new NetworkListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static NetworkListOption pageToken(String pageToken) {
            return new NetworkListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static NetworkListOption fields(NetworkField ... fields) {
            return new NetworkListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", NetworkField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class NetworkOption
    extends Option {
        private static final long serialVersionUID = 5346750551643875754L;

        private NetworkOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static NetworkOption fields(NetworkField ... fields) {
            return new NetworkOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(NetworkField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class SubnetworkAggregatedListOption
    extends Option {
        private static final long serialVersionUID = -4033514850525545027L;

        private SubnetworkAggregatedListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static SubnetworkAggregatedListOption filter(SubnetworkFilter filter) {
            return new SubnetworkAggregatedListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static SubnetworkAggregatedListOption pageSize(long pageSize) {
            return new SubnetworkAggregatedListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static SubnetworkAggregatedListOption pageToken(String pageToken) {
            return new SubnetworkAggregatedListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }
    }

    public static class SubnetworkListOption
    extends Option {
        private static final long serialVersionUID = -2978666213373829606L;

        private SubnetworkListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static SubnetworkListOption filter(SubnetworkFilter filter) {
            return new SubnetworkListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static SubnetworkListOption pageSize(long pageSize) {
            return new SubnetworkListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static SubnetworkListOption pageToken(String pageToken) {
            return new SubnetworkListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static SubnetworkListOption fields(SubnetworkField ... fields) {
            return new SubnetworkListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", SubnetworkField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class SubnetworkOption
    extends Option {
        private static final long serialVersionUID = 1994416967962074717L;

        private SubnetworkOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static SubnetworkOption fields(SubnetworkField ... fields) {
            return new SubnetworkOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(SubnetworkField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class DiskAggregatedListOption
    extends Option {
        private static final long serialVersionUID = 1163784797870242766L;

        private DiskAggregatedListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static DiskAggregatedListOption filter(DiskFilter filter) {
            return new DiskAggregatedListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static DiskAggregatedListOption pageSize(long pageSize) {
            return new DiskAggregatedListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static DiskAggregatedListOption pageToken(String pageToken) {
            return new DiskAggregatedListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }
    }

    public static class DiskListOption
    extends Option {
        private static final long serialVersionUID = -5148497888688645905L;

        private DiskListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static DiskListOption filter(DiskFilter filter) {
            return new DiskListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static DiskListOption pageSize(long pageSize) {
            return new DiskListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static DiskListOption pageToken(String pageToken) {
            return new DiskListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static DiskListOption fields(DiskField ... fields) {
            return new DiskListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", DiskField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class DiskOption
    extends Option {
        private static final long serialVersionUID = -4354796876226661667L;

        private DiskOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static DiskOption fields(DiskField ... fields) {
            return new DiskOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(DiskField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class ImageListOption
    extends Option {
        private static final long serialVersionUID = -4927977224287915654L;

        private ImageListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static ImageListOption filter(ImageFilter filter) {
            return new ImageListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static ImageListOption pageSize(long pageSize) {
            return new ImageListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static ImageListOption pageToken(String pageToken) {
            return new ImageListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static ImageListOption fields(ImageField ... fields) {
            return new ImageListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", ImageField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class ImageOption
    extends Option {
        private static final long serialVersionUID = -7622190783089299272L;

        private ImageOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static ImageOption fields(ImageField ... fields) {
            return new ImageOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(ImageField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class SnapshotListOption
    extends Option {
        private static final long serialVersionUID = 8278588147660831257L;

        private SnapshotListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static SnapshotListOption filter(SnapshotFilter filter) {
            return new SnapshotListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static SnapshotListOption pageSize(long pageSize) {
            return new SnapshotListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static SnapshotListOption pageToken(String pageToken) {
            return new SnapshotListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static SnapshotListOption fields(SnapshotField ... fields) {
            return new SnapshotListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", SnapshotField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class SnapshotOption
    extends Option {
        private static final long serialVersionUID = -3505179459035500945L;

        private SnapshotOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static SnapshotOption fields(SnapshotField ... fields) {
            return new SnapshotOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(SnapshotField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class AddressAggregatedListOption
    extends Option {
        private static final long serialVersionUID = -95538941541279561L;

        private AddressAggregatedListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static AddressAggregatedListOption filter(AddressFilter filter) {
            return new AddressAggregatedListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static AddressAggregatedListOption pageSize(long pageSize) {
            return new AddressAggregatedListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static AddressAggregatedListOption pageToken(String pageToken) {
            return new AddressAggregatedListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }
    }

    public static class AddressListOption
    extends Option {
        private static final long serialVersionUID = -4281322966374929346L;

        private AddressListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static AddressListOption filter(AddressFilter filter) {
            return new AddressListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static AddressListOption pageSize(long pageSize) {
            return new AddressListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static AddressListOption pageToken(String pageToken) {
            return new AddressListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static AddressListOption fields(AddressField ... fields) {
            return new AddressListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", AddressField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class AddressOption
    extends Option {
        private static final long serialVersionUID = -5755491818692494389L;

        private AddressOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static AddressOption fields(AddressField ... fields) {
            return new AddressOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(AddressField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class OperationListOption
    extends Option {
        private static final long serialVersionUID = -1509532420587265823L;

        private OperationListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static OperationListOption filter(OperationFilter filter) {
            return new OperationListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static OperationListOption pageSize(long pageSize) {
            return new OperationListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static OperationListOption pageToken(String pageToken) {
            return new OperationListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static OperationListOption fields(OperationField ... fields) {
            return new OperationListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", OperationField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class OperationOption
    extends Option {
        private static final long serialVersionUID = -4572636917684779912L;

        private OperationOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static OperationOption fields(OperationField ... fields) {
            return new OperationOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(OperationField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class LicenseOption
    extends Option {
        private static final long serialVersionUID = -2968652076389846258L;

        private LicenseOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static LicenseOption fields(LicenseField ... fields) {
            return new LicenseOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(LicenseField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class ZoneListOption
    extends Option {
        private static final long serialVersionUID = -4721971371200905764L;

        private ZoneListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static ZoneListOption filter(ZoneFilter filter) {
            return new ZoneListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static ZoneListOption pageSize(long pageSize) {
            return new ZoneListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static ZoneListOption pageToken(String pageToken) {
            return new ZoneListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static ZoneListOption fields(ZoneField ... fields) {
            return new ZoneListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", ZoneField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class ZoneOption
    extends Option {
        private static final long serialVersionUID = -2968652076389846258L;

        private ZoneOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static ZoneOption fields(ZoneField ... fields) {
            return new ZoneOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(ZoneField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class RegionListOption
    extends Option {
        private static final long serialVersionUID = 3348089279267170211L;

        private RegionListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static RegionListOption filter(RegionFilter filter) {
            return new RegionListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static RegionListOption pageSize(long pageSize) {
            return new RegionListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static RegionListOption pageToken(String pageToken) {
            return new RegionListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static RegionListOption fields(RegionField ... fields) {
            return new RegionListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", RegionField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class RegionOption
    extends Option {
        private static final long serialVersionUID = 2025084807788610826L;

        private RegionOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static RegionOption fields(RegionField ... fields) {
            return new RegionOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(RegionField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class MachineTypeAggregatedListOption
    extends Option {
        private static final long serialVersionUID = 8492257475500296057L;

        private MachineTypeAggregatedListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static MachineTypeAggregatedListOption filter(MachineTypeFilter filter) {
            return new MachineTypeAggregatedListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static MachineTypeAggregatedListOption pageSize(long pageSize) {
            return new MachineTypeAggregatedListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static MachineTypeAggregatedListOption pageToken(String pageToken) {
            return new MachineTypeAggregatedListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }
    }

    public static class MachineTypeListOption
    extends Option {
        private static final long serialVersionUID = -2974553049419897902L;

        private MachineTypeListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static MachineTypeListOption filter(MachineTypeFilter filter) {
            return new MachineTypeListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static MachineTypeListOption pageSize(long pageSize) {
            return new MachineTypeListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static MachineTypeListOption pageToken(String pageToken) {
            return new MachineTypeListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static MachineTypeListOption fields(MachineTypeField ... fields) {
            return new MachineTypeListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", MachineTypeField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class MachineTypeOption
    extends Option {
        private static final long serialVersionUID = 7349162455602991554L;

        private MachineTypeOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static MachineTypeOption fields(MachineTypeField ... fields) {
            return new MachineTypeOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(MachineTypeField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class DiskTypeAggregatedListOption
    extends Option {
        private static final long serialVersionUID = 7611137483018305170L;

        private DiskTypeAggregatedListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static DiskTypeAggregatedListOption filter(DiskTypeFilter filter) {
            return new DiskTypeAggregatedListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static DiskTypeAggregatedListOption pageSize(long pageSize) {
            return new DiskTypeAggregatedListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static DiskTypeAggregatedListOption pageToken(String pageToken) {
            return new DiskTypeAggregatedListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }
    }

    public static class DiskTypeListOption
    extends Option {
        private static final long serialVersionUID = 9051194230847610951L;

        private DiskTypeListOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static DiskTypeListOption filter(DiskTypeFilter filter) {
            return new DiskTypeListOption(ComputeRpc.Option.FILTER, filter.toPb());
        }

        public static DiskTypeListOption pageSize(long pageSize) {
            return new DiskTypeListOption(ComputeRpc.Option.MAX_RESULTS, pageSize);
        }

        public static DiskTypeListOption pageToken(String pageToken) {
            return new DiskTypeListOption(ComputeRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static DiskTypeListOption fields(DiskTypeField ... fields) {
            return new DiskTypeListOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", DiskTypeField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class DiskTypeOption
    extends Option {
        private static final long serialVersionUID = 7349162455602991554L;

        private DiskTypeOption(ComputeRpc.Option option, Object value) {
            super(option, value);
        }

        public static DiskTypeOption fields(DiskTypeField ... fields) {
            return new DiskTypeOption(ComputeRpc.Option.FIELDS, FieldSelector.Helper.selector(DiskTypeField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class InstanceFilter
    extends ListFilter {
        private static final long serialVersionUID = 679008888882025686L;

        private InstanceFilter(InstanceField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static InstanceFilter equals(InstanceField field, String value) {
            return new InstanceFilter((InstanceField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static InstanceFilter notEquals(InstanceField field, String value) {
            return new InstanceFilter((InstanceField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }

        public static InstanceFilter equals(InstanceField field, boolean value) {
            return new InstanceFilter((InstanceField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, (Object)value);
        }

        public static InstanceFilter notEquals(InstanceField field, boolean value) {
            return new InstanceFilter((InstanceField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, (Object)value);
        }
    }

    public static class NetworkFilter
    extends ListFilter {
        private static final long serialVersionUID = 7921406498804130930L;

        private NetworkFilter(NetworkField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static NetworkFilter equals(NetworkField field, String value) {
            return new NetworkFilter((NetworkField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static NetworkFilter notEquals(NetworkField field, String value) {
            return new NetworkFilter((NetworkField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }

        public static NetworkFilter equals(NetworkField field, boolean value) {
            return new NetworkFilter((NetworkField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, (Object)value);
        }

        public static NetworkFilter notEquals(NetworkField field, boolean value) {
            return new NetworkFilter((NetworkField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, (Object)value);
        }
    }

    public static class SubnetworkFilter
    extends ListFilter {
        private static final long serialVersionUID = 979448583739105481L;

        private SubnetworkFilter(SubnetworkField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static SubnetworkFilter equals(SubnetworkField field, String value) {
            return new SubnetworkFilter((SubnetworkField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static SubnetworkFilter notEquals(SubnetworkField field, String value) {
            return new SubnetworkFilter((SubnetworkField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }
    }

    public static class DiskFilter
    extends ListFilter {
        private static final long serialVersionUID = 5856790665396877913L;

        private DiskFilter(DiskField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static DiskFilter equals(DiskField field, String value) {
            return new DiskFilter((DiskField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static DiskFilter notEquals(DiskField field, String value) {
            return new DiskFilter((DiskField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }

        public static DiskFilter equals(DiskField field, long value) {
            return new DiskFilter((DiskField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, (Object)value);
        }

        public static DiskFilter notEquals(DiskField field, long value) {
            return new DiskFilter((DiskField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, (Object)value);
        }
    }

    public static class ImageFilter
    extends ListFilter {
        private static final long serialVersionUID = -3601427417234098397L;

        private ImageFilter(ImageField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static ImageFilter equals(ImageField field, String value) {
            return new ImageFilter((ImageField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static ImageFilter notEquals(ImageField field, String value) {
            return new ImageFilter((ImageField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }

        public static ImageFilter equals(ImageField field, long value) {
            return new ImageFilter((ImageField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, (Object)value);
        }

        public static ImageFilter notEquals(ImageField field, long value) {
            return new ImageFilter((ImageField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, (Object)value);
        }
    }

    public static class SnapshotFilter
    extends ListFilter {
        private static final long serialVersionUID = 8757711630092406747L;

        private SnapshotFilter(SnapshotField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static SnapshotFilter equals(SnapshotField field, String value) {
            return new SnapshotFilter((SnapshotField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static SnapshotFilter notEquals(SnapshotField field, String value) {
            return new SnapshotFilter((SnapshotField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }

        public static SnapshotFilter equals(SnapshotField field, long value) {
            return new SnapshotFilter((SnapshotField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, (Object)value);
        }

        public static SnapshotFilter notEquals(SnapshotField field, long value) {
            return new SnapshotFilter((SnapshotField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, (Object)value);
        }
    }

    public static class AddressFilter
    extends ListFilter {
        private static final long serialVersionUID = -227481644259653765L;

        private AddressFilter(AddressField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static AddressFilter equals(AddressField field, String value) {
            return new AddressFilter((AddressField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static AddressFilter notEquals(AddressField field, String value) {
            return new AddressFilter((AddressField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }
    }

    public static class OperationFilter
    extends ListFilter {
        private static final long serialVersionUID = -3202249202748346427L;

        private OperationFilter(OperationField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static OperationFilter equals(OperationField field, String value) {
            return new OperationFilter((OperationField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static OperationFilter notEquals(OperationField field, String value) {
            return new OperationFilter((OperationField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }

        public static OperationFilter equals(OperationField field, long value) {
            return new OperationFilter((OperationField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, (Object)value);
        }

        public static OperationFilter notEquals(OperationField field, long value) {
            return new OperationFilter((OperationField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, (Object)value);
        }
    }

    public static class ZoneFilter
    extends ListFilter {
        private static final long serialVersionUID = -3927428278548808737L;

        private ZoneFilter(ZoneField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static ZoneFilter equals(ZoneField field, String value) {
            return new ZoneFilter((ZoneField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static ZoneFilter notEquals(ZoneField field, String value) {
            return new ZoneFilter((ZoneField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }
    }

    public static class RegionFilter
    extends ListFilter {
        private static final long serialVersionUID = 4464892812442567172L;

        private RegionFilter(RegionField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static RegionFilter equals(RegionField field, String value) {
            return new RegionFilter((RegionField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, (Object)value);
        }

        public static RegionFilter notEquals(RegionField field, String value) {
            return new RegionFilter((RegionField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }
    }

    public static class MachineTypeFilter
    extends ListFilter {
        private static final long serialVersionUID = 7346062041571853235L;

        private MachineTypeFilter(MachineTypeField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static MachineTypeFilter equals(MachineTypeField field, String value) {
            return new MachineTypeFilter((MachineTypeField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static MachineTypeFilter notEquals(MachineTypeField field, String value) {
            return new MachineTypeFilter((MachineTypeField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }

        public static MachineTypeFilter equals(MachineTypeField field, long value) {
            return new MachineTypeFilter((MachineTypeField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, (Object)value);
        }

        public static MachineTypeFilter notEquals(MachineTypeField field, long value) {
            return new MachineTypeFilter((MachineTypeField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, (Object)value);
        }
    }

    public static class DiskTypeFilter
    extends ListFilter {
        private static final long serialVersionUID = 4847837203592234453L;

        private DiskTypeFilter(DiskTypeField field, ListFilter.ComparisonOperator operator, Object value) {
            super(field.getSelector(), operator, value);
        }

        public static DiskTypeFilter equals(DiskTypeField field, String value) {
            return new DiskTypeFilter((DiskTypeField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, Preconditions.checkNotNull((Object)value));
        }

        public static DiskTypeFilter notEquals(DiskTypeField field, String value) {
            return new DiskTypeFilter((DiskTypeField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, Preconditions.checkNotNull((Object)value));
        }

        public static DiskTypeFilter equals(DiskTypeField field, long value) {
            return new DiskTypeFilter((DiskTypeField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.EQ, (Object)value);
        }

        public static DiskTypeFilter notEquals(DiskTypeField field, long value) {
            return new DiskTypeFilter((DiskTypeField)((Object)Preconditions.checkNotNull((Object)((Object)field))), ListFilter.ComparisonOperator.NE, (Object)value);
        }
    }

    public static abstract class ListFilter
    implements Serializable {
        private static final long serialVersionUID = -238638392811165127L;
        private final String field;
        private final ComparisonOperator operator;
        private final Object value;

        ListFilter(String field, ComparisonOperator operator, Object value) {
            this.field = field;
            this.operator = operator;
            this.value = value;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.field, this.operator, this.value});
        }

        public boolean equals(Object obj) {
            return obj instanceof ListFilter && this.toPb().equals(((ListFilter)obj).toPb());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).add("operator", (Object)this.operator).add("value", this.value).toString();
        }

        String toPb() {
            return this.field + ' ' + this.operator.name().toLowerCase() + ' ' + this.value.toString();
        }

        static enum ComparisonOperator {
            EQ,
            NE;

        }
    }

    public static enum InstanceField implements FieldSelector
    {
        CAN_IP_FORWARD("canIpForward"),
        CPU_PLATFORM("cpuPlatform"),
        CREATION_TIMESTAMP("creationTimestamp"),
        DESCRIPTION("description"),
        DISKS("disks"),
        ID("id"),
        MACHINE_TYPE("machineType"),
        METADATA("metadata"),
        NAME("name"),
        NETWORK_INTERFACES("networkInterfaces"),
        SCHEDULING("scheduling"),
        SELF_LINK("selfLink"),
        SERVICE_ACCOUNTS("serviceAccounts"),
        STATUS("status"),
        STATUS_MESSAGE("statusMessage"),
        TAGS("tags"),
        ZONE("zone");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private InstanceField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK));
        }
    }

    public static enum NetworkField implements FieldSelector
    {
        IPV4_RANGE("IPv4Range"),
        AUTO_CREATE_SUBNETWORKS("autoCreateSubnetworks"),
        CREATION_TIMESTAMP("creationTimestamp"),
        DESCRIPTION("description"),
        GATEWAY_IPV4("gatewayIPv4"),
        ID("id"),
        NAME("name"),
        SELF_LINK("selfLink"),
        SUBNETWORKS("subnetworks");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private NetworkField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK), (Object)((Object)IPV4_RANGE), (Object)((Object)AUTO_CREATE_SUBNETWORKS));
        }
    }

    public static enum SubnetworkField implements FieldSelector
    {
        CREATION_TIMESTAMP("creationTimestamp"),
        DESCRIPTION("description"),
        GATEWAY_ADDRESS("gatewayAddress"),
        ID("id"),
        IP_CIDR_RANGE("ipCidrRange"),
        NAME("name"),
        NETWORK("network"),
        REGION("region"),
        SELF_LINK("selfLink");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private SubnetworkField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK));
        }
    }

    public static enum ImageField implements FieldSelector
    {
        ARCHIVE_SIZE_BYTES("archiveSizeBytes"),
        CREATION_TIMESTAMP("creationTimestamp"),
        DEPRECATED("deprecated"),
        DESCRIPTION("description"),
        DISK_SIZE_GB("diskSizeGb"),
        ID("id"),
        LICENSES("licenses"),
        NAME("name"),
        RAW_DISK("rawDisk"),
        SELF_LINK("selfLink"),
        SOURCE_DISK("sourceDisk"),
        SOURCE_DISK_ID("sourceDiskId"),
        SOURCE_TYPE("sourceType");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private ImageField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK), (Object)((Object)SOURCE_DISK), (Object)((Object)RAW_DISK));
        }
    }

    public static enum SnapshotField implements FieldSelector
    {
        CREATION_TIMESTAMP("creationTimestamp"),
        DESCRIPTION("description"),
        DISK_SIZE_GB("diskSizeGb"),
        ID("id"),
        LICENSES("licenses"),
        NAME("name"),
        SELF_LINK("selfLink"),
        SOURCE_DISK("sourceDisk"),
        SOURCE_DISK_ID("sourceDiskId"),
        STATUS("status"),
        STORAGE_BYTES("storageBytes"),
        STORAGE_BYTES_STATUS("storageBytesStatus");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private SnapshotField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK));
        }
    }

    public static enum DiskField implements FieldSelector
    {
        CREATION_TIMESTAMP("creationTimestamp"),
        DESCRIPTION("description"),
        ID("id"),
        LAST_ATTACH_TIMESTAMP("lastAttachTimestamp"),
        LAST_DETACH_TIMESTAMP("lastDetachTimestamp"),
        LICENSES("licenses"),
        NAME("name"),
        OPTIONS("options"),
        SELF_LINK("selfLink"),
        SIZE_GB("sizeGb"),
        SOURCE_IMAGE("sourceImage"),
        SOURCE_IMAGE_ID("sourceImageId"),
        SOURCE_SNAPSHOT("sourceSnapshot"),
        SOURCE_SNAPSHOT_ID("sourceSnapshotId"),
        STATUS("status"),
        TYPE("type"),
        USERS("users"),
        ZONE("zone");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private DiskField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK), (Object)((Object)TYPE), (Object)((Object)SOURCE_IMAGE), (Object)((Object)SOURCE_SNAPSHOT));
        }
    }

    public static enum AddressField implements FieldSelector
    {
        ADDRESS("address"),
        CREATION_TIMESTAMP("creationTimestamp"),
        DESCRIPTION("description"),
        ID("id"),
        NAME("name"),
        REGION("region"),
        SELF_LINK("selfLink"),
        STATUS("status"),
        USERS("users");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private AddressField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK));
        }
    }

    public static enum OperationField implements FieldSelector
    {
        CLIENT_OPERATION_ID("clientOperationId"),
        DESCRIPTION("description"),
        END_TIME("endTime"),
        ERROR("error"),
        HTTP_ERROR_MESSAGE("httpErrorMessage"),
        HTTP_ERROR_STATUS_CODE("httpErrorStatusCode"),
        ID("id"),
        INSERT_TIME("insertTime"),
        NAME("name"),
        OPERATION_TYPE("operationType"),
        PROGRESS("progress"),
        REGION("region"),
        SELF_LINK("selfLink"),
        START_TIME("startTime"),
        STATUS("status"),
        STATUS_MESSAGE("statusMessage"),
        TARGET_ID("targetId"),
        TARGET_LINK("targetLink"),
        USER("user"),
        WARNINGS("warnings"),
        ZONE("zone");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private OperationField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK));
        }
    }

    public static enum LicenseField implements FieldSelector
    {
        CHARGES_USE_FEE("chargesUseFee"),
        NAME("name"),
        SELF_LINK("selfLink");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private LicenseField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK));
        }
    }

    public static enum ZoneField implements FieldSelector
    {
        CREATION_TIMESTAMP("creationTimestamp"),
        DESCRIPTION("description"),
        ID("id"),
        NAME("name"),
        REGION("region"),
        SELF_LINK("selfLink"),
        STATUS("status"),
        DEPRECATED("deprecated");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private ZoneField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK));
        }
    }

    public static enum RegionField implements FieldSelector
    {
        CREATION_TIMESTAMP("creationTimestamp"),
        DESCRIPTION("description"),
        ID("id"),
        NAME("name"),
        QUOTAS("quotas"),
        SELF_LINK("selfLink"),
        STATUS("status"),
        ZONES("zones"),
        DEPRECATED("deprecated");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private RegionField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK));
        }
    }

    public static enum MachineTypeField implements FieldSelector
    {
        CREATION_TIMESTAMP("creationTimestamp"),
        DESCRIPTION("description"),
        GUEST_CPUS("guestCpus"),
        ID("id"),
        IMAGE_SPACE_GB("imageSpaceGb"),
        MAXIMUM_PERSISTENT_DISKS("maximumPersistentDisks"),
        MAXIMUM_PERSISTENT_DISKS_SIZE_GB("maximumPersistentDisksSizeGb"),
        MEMORY_MB("memoryMb"),
        NAME("name"),
        SCRATCH_DISKS("scratchDisks"),
        SELF_LINK("selfLink"),
        ZONE("zone"),
        DEPRECATED("deprecated");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private MachineTypeField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK));
        }
    }

    public static enum DiskTypeField implements FieldSelector
    {
        CREATION_TIMESTAMP("creationTimestamp"),
        DEFAULT_DISK_SIZE_GB("defaultDiskSizeGb"),
        DESCRIPTION("description"),
        ID("id"),
        NAME("name"),
        SELF_LINK("selfLink"),
        VALID_DISK_SIZE("validDiskSize"),
        ZONE("zone"),
        DEPRECATED("deprecated");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private DiskTypeField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)SELF_LINK));
        }
    }
}

