/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetHttpsProxiesHttpRequest;
import com.google.cloud.compute.v1.DeleteTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.GetTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.InsertTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.ListTargetHttpsProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalTargetHttpsProxyName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectTargetHttpsProxyName;
import com.google.cloud.compute.v1.SetQuicOverrideTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.SetSslCertificatesTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.SetSslPolicyTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.SetUrlMapTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.SslPolicyReference;
import com.google.cloud.compute.v1.TargetHttpsProxiesScopedList;
import com.google.cloud.compute.v1.TargetHttpsProxiesSetQuicOverrideRequest;
import com.google.cloud.compute.v1.TargetHttpsProxiesSetSslCertificatesRequest;
import com.google.cloud.compute.v1.TargetHttpsProxy;
import com.google.cloud.compute.v1.TargetHttpsProxyAggregatedList;
import com.google.cloud.compute.v1.TargetHttpsProxyList;
import com.google.cloud.compute.v1.TargetHttpsProxySettings;
import com.google.cloud.compute.v1.UrlMapReference;
import com.google.cloud.compute.v1.stub.TargetHttpsProxyStub;
import com.google.cloud.compute.v1.stub.TargetHttpsProxyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TargetHttpsProxyClient
implements BackgroundResource {
    private final TargetHttpsProxySettings settings;
    private final TargetHttpsProxyStub stub;

    public static final TargetHttpsProxyClient create() throws IOException {
        return TargetHttpsProxyClient.create(TargetHttpsProxySettings.newBuilder().build());
    }

    public static final TargetHttpsProxyClient create(TargetHttpsProxySettings settings) throws IOException {
        return new TargetHttpsProxyClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetHttpsProxyClient create(TargetHttpsProxyStub stub) {
        return new TargetHttpsProxyClient(stub);
    }

    protected TargetHttpsProxyClient(TargetHttpsProxySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetHttpsProxyStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetHttpsProxyClient(TargetHttpsProxyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetHttpsProxySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetHttpsProxyStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListTargetHttpsProxiesPagedResponse aggregatedListTargetHttpsProxies(Boolean includeAllScopes, ProjectName project) {
        AggregatedListTargetHttpsProxiesHttpRequest request = AggregatedListTargetHttpsProxiesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListTargetHttpsProxies(request);
    }

    @BetaApi
    public final AggregatedListTargetHttpsProxiesPagedResponse aggregatedListTargetHttpsProxies(Boolean includeAllScopes, String project) {
        AggregatedListTargetHttpsProxiesHttpRequest request = AggregatedListTargetHttpsProxiesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListTargetHttpsProxies(request);
    }

    @BetaApi
    public final AggregatedListTargetHttpsProxiesPagedResponse aggregatedListTargetHttpsProxies(AggregatedListTargetHttpsProxiesHttpRequest request) {
        return (AggregatedListTargetHttpsProxiesPagedResponse)((Object)this.aggregatedListTargetHttpsProxiesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListTargetHttpsProxiesHttpRequest, AggregatedListTargetHttpsProxiesPagedResponse> aggregatedListTargetHttpsProxiesPagedCallable() {
        return this.stub.aggregatedListTargetHttpsProxiesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListTargetHttpsProxiesHttpRequest, TargetHttpsProxyAggregatedList> aggregatedListTargetHttpsProxiesCallable() {
        return this.stub.aggregatedListTargetHttpsProxiesCallable();
    }

    @BetaApi
    public final Operation deleteTargetHttpsProxy(ProjectGlobalTargetHttpsProxyName targetHttpsProxy) {
        DeleteTargetHttpsProxyHttpRequest request = DeleteTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy == null ? null : targetHttpsProxy.toString()).build();
        return this.deleteTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation deleteTargetHttpsProxy(String targetHttpsProxy) {
        DeleteTargetHttpsProxyHttpRequest request = DeleteTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy).build();
        return this.deleteTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation deleteTargetHttpsProxy(DeleteTargetHttpsProxyHttpRequest request) {
        return (Operation)this.deleteTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteTargetHttpsProxyHttpRequest, Operation> deleteTargetHttpsProxyCallable() {
        return this.stub.deleteTargetHttpsProxyCallable();
    }

    @BetaApi
    public final TargetHttpsProxy getTargetHttpsProxy(ProjectGlobalTargetHttpsProxyName targetHttpsProxy) {
        GetTargetHttpsProxyHttpRequest request = GetTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy == null ? null : targetHttpsProxy.toString()).build();
        return this.getTargetHttpsProxy(request);
    }

    @BetaApi
    public final TargetHttpsProxy getTargetHttpsProxy(String targetHttpsProxy) {
        GetTargetHttpsProxyHttpRequest request = GetTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy).build();
        return this.getTargetHttpsProxy(request);
    }

    @BetaApi
    public final TargetHttpsProxy getTargetHttpsProxy(GetTargetHttpsProxyHttpRequest request) {
        return (TargetHttpsProxy)this.getTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetTargetHttpsProxyHttpRequest, TargetHttpsProxy> getTargetHttpsProxyCallable() {
        return this.stub.getTargetHttpsProxyCallable();
    }

    @BetaApi
    public final Operation insertTargetHttpsProxy(ProjectName project, TargetHttpsProxy targetHttpsProxyResource) {
        InsertTargetHttpsProxyHttpRequest request = InsertTargetHttpsProxyHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setTargetHttpsProxyResource(targetHttpsProxyResource).build();
        return this.insertTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation insertTargetHttpsProxy(String project, TargetHttpsProxy targetHttpsProxyResource) {
        InsertTargetHttpsProxyHttpRequest request = InsertTargetHttpsProxyHttpRequest.newBuilder().setProject(project).setTargetHttpsProxyResource(targetHttpsProxyResource).build();
        return this.insertTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation insertTargetHttpsProxy(InsertTargetHttpsProxyHttpRequest request) {
        return (Operation)this.insertTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertTargetHttpsProxyHttpRequest, Operation> insertTargetHttpsProxyCallable() {
        return this.stub.insertTargetHttpsProxyCallable();
    }

    @BetaApi
    public final ListTargetHttpsProxiesPagedResponse listTargetHttpsProxies(ProjectName project) {
        ListTargetHttpsProxiesHttpRequest request = ListTargetHttpsProxiesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listTargetHttpsProxies(request);
    }

    @BetaApi
    public final ListTargetHttpsProxiesPagedResponse listTargetHttpsProxies(String project) {
        ListTargetHttpsProxiesHttpRequest request = ListTargetHttpsProxiesHttpRequest.newBuilder().setProject(project).build();
        return this.listTargetHttpsProxies(request);
    }

    @BetaApi
    public final ListTargetHttpsProxiesPagedResponse listTargetHttpsProxies(ListTargetHttpsProxiesHttpRequest request) {
        return (ListTargetHttpsProxiesPagedResponse)((Object)this.listTargetHttpsProxiesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListTargetHttpsProxiesHttpRequest, ListTargetHttpsProxiesPagedResponse> listTargetHttpsProxiesPagedCallable() {
        return this.stub.listTargetHttpsProxiesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList> listTargetHttpsProxiesCallable() {
        return this.stub.listTargetHttpsProxiesCallable();
    }

    @BetaApi
    public final Operation setQuicOverrideTargetHttpsProxy(ProjectGlobalTargetHttpsProxyName targetHttpsProxy, TargetHttpsProxiesSetQuicOverrideRequest targetHttpsProxiesSetQuicOverrideRequestResource) {
        SetQuicOverrideTargetHttpsProxyHttpRequest request = SetQuicOverrideTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy == null ? null : targetHttpsProxy.toString()).setTargetHttpsProxiesSetQuicOverrideRequestResource(targetHttpsProxiesSetQuicOverrideRequestResource).build();
        return this.setQuicOverrideTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setQuicOverrideTargetHttpsProxy(String targetHttpsProxy, TargetHttpsProxiesSetQuicOverrideRequest targetHttpsProxiesSetQuicOverrideRequestResource) {
        SetQuicOverrideTargetHttpsProxyHttpRequest request = SetQuicOverrideTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy).setTargetHttpsProxiesSetQuicOverrideRequestResource(targetHttpsProxiesSetQuicOverrideRequestResource).build();
        return this.setQuicOverrideTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setQuicOverrideTargetHttpsProxy(SetQuicOverrideTargetHttpsProxyHttpRequest request) {
        return (Operation)this.setQuicOverrideTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetQuicOverrideTargetHttpsProxyHttpRequest, Operation> setQuicOverrideTargetHttpsProxyCallable() {
        return this.stub.setQuicOverrideTargetHttpsProxyCallable();
    }

    @BetaApi
    public final Operation setSslCertificatesTargetHttpsProxy(ProjectTargetHttpsProxyName targetHttpsProxy, TargetHttpsProxiesSetSslCertificatesRequest targetHttpsProxiesSetSslCertificatesRequestResource) {
        SetSslCertificatesTargetHttpsProxyHttpRequest request = SetSslCertificatesTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy == null ? null : targetHttpsProxy.toString()).setTargetHttpsProxiesSetSslCertificatesRequestResource(targetHttpsProxiesSetSslCertificatesRequestResource).build();
        return this.setSslCertificatesTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setSslCertificatesTargetHttpsProxy(String targetHttpsProxy, TargetHttpsProxiesSetSslCertificatesRequest targetHttpsProxiesSetSslCertificatesRequestResource) {
        SetSslCertificatesTargetHttpsProxyHttpRequest request = SetSslCertificatesTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy).setTargetHttpsProxiesSetSslCertificatesRequestResource(targetHttpsProxiesSetSslCertificatesRequestResource).build();
        return this.setSslCertificatesTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setSslCertificatesTargetHttpsProxy(SetSslCertificatesTargetHttpsProxyHttpRequest request) {
        return (Operation)this.setSslCertificatesTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetSslCertificatesTargetHttpsProxyHttpRequest, Operation> setSslCertificatesTargetHttpsProxyCallable() {
        return this.stub.setSslCertificatesTargetHttpsProxyCallable();
    }

    @BetaApi
    public final Operation setSslPolicyTargetHttpsProxy(ProjectGlobalTargetHttpsProxyName targetHttpsProxy, SslPolicyReference sslPolicyReferenceResource) {
        SetSslPolicyTargetHttpsProxyHttpRequest request = SetSslPolicyTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy == null ? null : targetHttpsProxy.toString()).setSslPolicyReferenceResource(sslPolicyReferenceResource).build();
        return this.setSslPolicyTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setSslPolicyTargetHttpsProxy(String targetHttpsProxy, SslPolicyReference sslPolicyReferenceResource) {
        SetSslPolicyTargetHttpsProxyHttpRequest request = SetSslPolicyTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy).setSslPolicyReferenceResource(sslPolicyReferenceResource).build();
        return this.setSslPolicyTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setSslPolicyTargetHttpsProxy(SetSslPolicyTargetHttpsProxyHttpRequest request) {
        return (Operation)this.setSslPolicyTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetSslPolicyTargetHttpsProxyHttpRequest, Operation> setSslPolicyTargetHttpsProxyCallable() {
        return this.stub.setSslPolicyTargetHttpsProxyCallable();
    }

    @BetaApi
    public final Operation setUrlMapTargetHttpsProxy(ProjectTargetHttpsProxyName targetHttpsProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapTargetHttpsProxyHttpRequest request = SetUrlMapTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy == null ? null : targetHttpsProxy.toString()).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMapTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setUrlMapTargetHttpsProxy(String targetHttpsProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapTargetHttpsProxyHttpRequest request = SetUrlMapTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMapTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setUrlMapTargetHttpsProxy(SetUrlMapTargetHttpsProxyHttpRequest request) {
        return (Operation)this.setUrlMapTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetUrlMapTargetHttpsProxyHttpRequest, Operation> setUrlMapTargetHttpsProxyCallable() {
        return this.stub.setUrlMapTargetHttpsProxyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTargetHttpsProxiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy, ListTargetHttpsProxiesPage, ListTargetHttpsProxiesFixedSizeCollection> {
        private ListTargetHttpsProxiesFixedSizeCollection(List<ListTargetHttpsProxiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetHttpsProxiesFixedSizeCollection createEmptyCollection() {
            return new ListTargetHttpsProxiesFixedSizeCollection(null, 0);
        }

        protected ListTargetHttpsProxiesFixedSizeCollection createCollection(List<ListTargetHttpsProxiesPage> pages, int collectionSize) {
            return new ListTargetHttpsProxiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetHttpsProxiesPage
    extends AbstractPage<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy, ListTargetHttpsProxiesPage> {
        private ListTargetHttpsProxiesPage(PageContext<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy> context, TargetHttpsProxyList response) {
            super(context, (Object)response);
        }

        private static ListTargetHttpsProxiesPage createEmptyPage() {
            return new ListTargetHttpsProxiesPage(null, null);
        }

        protected ListTargetHttpsProxiesPage createPage(PageContext<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy> context, TargetHttpsProxyList response) {
            return new ListTargetHttpsProxiesPage(context, response);
        }

        public ApiFuture<ListTargetHttpsProxiesPage> createPageAsync(PageContext<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy> context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetHttpsProxiesPagedResponse
    extends AbstractPagedListResponse<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy, ListTargetHttpsProxiesPage, ListTargetHttpsProxiesFixedSizeCollection> {
        public static ApiFuture<ListTargetHttpsProxiesPagedResponse> createAsync(PageContext<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy> context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            ApiFuture<ListTargetHttpsProxiesPage> futurePage = ListTargetHttpsProxiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTargetHttpsProxiesPage, ListTargetHttpsProxiesPagedResponse>(){

                public ListTargetHttpsProxiesPagedResponse apply(ListTargetHttpsProxiesPage input) {
                    return new ListTargetHttpsProxiesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTargetHttpsProxiesPagedResponse(ListTargetHttpsProxiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetHttpsProxiesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListTargetHttpsProxiesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListTargetHttpsProxiesHttpRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesScopedList, AggregatedListTargetHttpsProxiesPage, AggregatedListTargetHttpsProxiesFixedSizeCollection> {
        private AggregatedListTargetHttpsProxiesFixedSizeCollection(List<AggregatedListTargetHttpsProxiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListTargetHttpsProxiesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListTargetHttpsProxiesFixedSizeCollection(null, 0);
        }

        protected AggregatedListTargetHttpsProxiesFixedSizeCollection createCollection(List<AggregatedListTargetHttpsProxiesPage> pages, int collectionSize) {
            return new AggregatedListTargetHttpsProxiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListTargetHttpsProxiesPage
    extends AbstractPage<AggregatedListTargetHttpsProxiesHttpRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesScopedList, AggregatedListTargetHttpsProxiesPage> {
        private AggregatedListTargetHttpsProxiesPage(PageContext<AggregatedListTargetHttpsProxiesHttpRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesScopedList> context, TargetHttpsProxyAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListTargetHttpsProxiesPage createEmptyPage() {
            return new AggregatedListTargetHttpsProxiesPage(null, null);
        }

        protected AggregatedListTargetHttpsProxiesPage createPage(PageContext<AggregatedListTargetHttpsProxiesHttpRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesScopedList> context, TargetHttpsProxyAggregatedList response) {
            return new AggregatedListTargetHttpsProxiesPage(context, response);
        }

        public ApiFuture<AggregatedListTargetHttpsProxiesPage> createPageAsync(PageContext<AggregatedListTargetHttpsProxiesHttpRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesScopedList> context, ApiFuture<TargetHttpsProxyAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListTargetHttpsProxiesPagedResponse
    extends AbstractPagedListResponse<AggregatedListTargetHttpsProxiesHttpRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesScopedList, AggregatedListTargetHttpsProxiesPage, AggregatedListTargetHttpsProxiesFixedSizeCollection> {
        public static ApiFuture<AggregatedListTargetHttpsProxiesPagedResponse> createAsync(PageContext<AggregatedListTargetHttpsProxiesHttpRequest, TargetHttpsProxyAggregatedList, TargetHttpsProxiesScopedList> context, ApiFuture<TargetHttpsProxyAggregatedList> futureResponse) {
            ApiFuture<AggregatedListTargetHttpsProxiesPage> futurePage = AggregatedListTargetHttpsProxiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListTargetHttpsProxiesPage, AggregatedListTargetHttpsProxiesPagedResponse>(){

                public AggregatedListTargetHttpsProxiesPagedResponse apply(AggregatedListTargetHttpsProxiesPage input) {
                    return new AggregatedListTargetHttpsProxiesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListTargetHttpsProxiesPagedResponse(AggregatedListTargetHttpsProxiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListTargetHttpsProxiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

