/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AccessConfig;
import com.google.cloud.compute.v1.AliasIpRange;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NetworkInterface
implements ApiMessage {
    private final List<AccessConfig> accessConfigs;
    private final List<AliasIpRange> aliasIpRanges;
    private final String fingerprint;
    private final String ipv6Address;
    private final String kind;
    private final String name;
    private final String network;
    private final String networkIP;
    private final String subnetwork;
    private static final NetworkInterface DEFAULT_INSTANCE = new NetworkInterface();

    private NetworkInterface() {
        this.accessConfigs = null;
        this.aliasIpRanges = null;
        this.fingerprint = null;
        this.ipv6Address = null;
        this.kind = null;
        this.name = null;
        this.network = null;
        this.networkIP = null;
        this.subnetwork = null;
    }

    private NetworkInterface(List<AccessConfig> accessConfigs, List<AliasIpRange> aliasIpRanges, String fingerprint, String ipv6Address, String kind, String name, String network, String networkIP, String subnetwork) {
        this.accessConfigs = accessConfigs;
        this.aliasIpRanges = aliasIpRanges;
        this.fingerprint = fingerprint;
        this.ipv6Address = ipv6Address;
        this.kind = kind;
        this.name = name;
        this.network = network;
        this.networkIP = networkIP;
        this.subnetwork = subnetwork;
    }

    public Object getFieldValue(String fieldName) {
        if ("accessConfigs".equals(fieldName)) {
            return this.accessConfigs;
        }
        if ("aliasIpRanges".equals(fieldName)) {
            return this.aliasIpRanges;
        }
        if ("fingerprint".equals(fieldName)) {
            return this.fingerprint;
        }
        if ("ipv6Address".equals(fieldName)) {
            return this.ipv6Address;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("network".equals(fieldName)) {
            return this.network;
        }
        if ("networkIP".equals(fieldName)) {
            return this.networkIP;
        }
        if ("subnetwork".equals(fieldName)) {
            return this.subnetwork;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<AccessConfig> getAccessConfigsList() {
        return this.accessConfigs;
    }

    public List<AliasIpRange> getAliasIpRangesList() {
        return this.aliasIpRanges;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getIpv6Address() {
        return this.ipv6Address;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getNetworkIP() {
        return this.networkIP;
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NetworkInterface prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NetworkInterface getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NetworkInterface{accessConfigs=" + this.accessConfigs + ", aliasIpRanges=" + this.aliasIpRanges + ", fingerprint=" + this.fingerprint + ", ipv6Address=" + this.ipv6Address + ", kind=" + this.kind + ", name=" + this.name + ", network=" + this.network + ", networkIP=" + this.networkIP + ", subnetwork=" + this.subnetwork + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkInterface) {
            NetworkInterface that = (NetworkInterface)o;
            return Objects.equals(this.accessConfigs, that.getAccessConfigsList()) && Objects.equals(this.aliasIpRanges, that.getAliasIpRangesList()) && Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.ipv6Address, that.getIpv6Address()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.networkIP, that.getNetworkIP()) && Objects.equals(this.subnetwork, that.getSubnetwork());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.accessConfigs, this.aliasIpRanges, this.fingerprint, this.ipv6Address, this.kind, this.name, this.network, this.networkIP, this.subnetwork);
    }

    public static class Builder {
        private List<AccessConfig> accessConfigs;
        private List<AliasIpRange> aliasIpRanges;
        private String fingerprint;
        private String ipv6Address;
        private String kind;
        private String name;
        private String network;
        private String networkIP;
        private String subnetwork;

        Builder() {
        }

        public Builder mergeFrom(NetworkInterface other) {
            if (other == NetworkInterface.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessConfigsList() != null) {
                this.accessConfigs = other.accessConfigs;
            }
            if (other.getAliasIpRangesList() != null) {
                this.aliasIpRanges = other.aliasIpRanges;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getIpv6Address() != null) {
                this.ipv6Address = other.ipv6Address;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getNetworkIP() != null) {
                this.networkIP = other.networkIP;
            }
            if (other.getSubnetwork() != null) {
                this.subnetwork = other.subnetwork;
            }
            return this;
        }

        Builder(NetworkInterface source) {
            this.accessConfigs = source.accessConfigs;
            this.aliasIpRanges = source.aliasIpRanges;
            this.fingerprint = source.fingerprint;
            this.ipv6Address = source.ipv6Address;
            this.kind = source.kind;
            this.name = source.name;
            this.network = source.network;
            this.networkIP = source.networkIP;
            this.subnetwork = source.subnetwork;
        }

        public List<AccessConfig> getAccessConfigsList() {
            return this.accessConfigs;
        }

        public Builder addAllAccessConfigs(List<AccessConfig> accessConfigs) {
            if (this.accessConfigs == null) {
                this.accessConfigs = new LinkedList<AccessConfig>();
            }
            this.accessConfigs.addAll(accessConfigs);
            return this;
        }

        public Builder addAccessConfigs(AccessConfig accessConfigs) {
            if (this.accessConfigs == null) {
                this.accessConfigs = new LinkedList<AccessConfig>();
            }
            this.accessConfigs.add(accessConfigs);
            return this;
        }

        public List<AliasIpRange> getAliasIpRangesList() {
            return this.aliasIpRanges;
        }

        public Builder addAllAliasIpRanges(List<AliasIpRange> aliasIpRanges) {
            if (this.aliasIpRanges == null) {
                this.aliasIpRanges = new LinkedList<AliasIpRange>();
            }
            this.aliasIpRanges.addAll(aliasIpRanges);
            return this;
        }

        public Builder addAliasIpRanges(AliasIpRange aliasIpRanges) {
            if (this.aliasIpRanges == null) {
                this.aliasIpRanges = new LinkedList<AliasIpRange>();
            }
            this.aliasIpRanges.add(aliasIpRanges);
            return this;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public String getIpv6Address() {
            return this.ipv6Address;
        }

        public Builder setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getNetworkIP() {
            return this.networkIP;
        }

        public Builder setNetworkIP(String networkIP) {
            this.networkIP = networkIP;
            return this;
        }

        public String getSubnetwork() {
            return this.subnetwork;
        }

        public Builder setSubnetwork(String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        public NetworkInterface build() {
            return new NetworkInterface(this.accessConfigs, this.aliasIpRanges, this.fingerprint, this.ipv6Address, this.kind, this.name, this.network, this.networkIP, this.subnetwork);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAccessConfigs(this.accessConfigs);
            newBuilder.addAllAliasIpRanges(this.aliasIpRanges);
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.setIpv6Address(this.ipv6Address);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setNetworkIP(this.networkIP);
            newBuilder.setSubnetwork(this.subnetwork);
            return newBuilder;
        }
    }
}

