/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HealthChecksScopedList
implements ApiMessage {
    private final List<HealthCheck> healthChecks;
    private final Warning warning;
    private static final HealthChecksScopedList DEFAULT_INSTANCE = new HealthChecksScopedList();

    private HealthChecksScopedList() {
        this.healthChecks = null;
        this.warning = null;
    }

    private HealthChecksScopedList(List<HealthCheck> healthChecks, Warning warning) {
        this.healthChecks = healthChecks;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("healthChecks".equals(fieldName)) {
            return this.healthChecks;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<HealthCheck> getHealthChecksList() {
        return this.healthChecks;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HealthChecksScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HealthChecksScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HealthChecksScopedList{healthChecks=" + this.healthChecks + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HealthChecksScopedList) {
            HealthChecksScopedList that = (HealthChecksScopedList)o;
            return Objects.equals(this.healthChecks, that.getHealthChecksList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.healthChecks, this.warning);
    }

    public static class Builder {
        private List<HealthCheck> healthChecks;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(HealthChecksScopedList other) {
            if (other == HealthChecksScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getHealthChecksList() != null) {
                this.healthChecks = other.healthChecks;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(HealthChecksScopedList source) {
            this.healthChecks = source.healthChecks;
            this.warning = source.warning;
        }

        public List<HealthCheck> getHealthChecksList() {
            return this.healthChecks;
        }

        public Builder addAllHealthChecks(List<HealthCheck> healthChecks) {
            if (this.healthChecks == null) {
                this.healthChecks = new LinkedList<HealthCheck>();
            }
            this.healthChecks.addAll(healthChecks);
            return this;
        }

        public Builder addHealthChecks(HealthCheck healthChecks) {
            if (this.healthChecks == null) {
                this.healthChecks = new LinkedList<HealthCheck>();
            }
            this.healthChecks.add(healthChecks);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public HealthChecksScopedList build() {
            return new HealthChecksScopedList(this.healthChecks, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllHealthChecks(this.healthChecks);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

