/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteGlobalForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.ForwardingRule;
import com.google.cloud.compute.v1.ForwardingRuleList;
import com.google.cloud.compute.v1.GetGlobalForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.GlobalForwardingRuleClient;
import com.google.cloud.compute.v1.InsertGlobalForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.ListGlobalForwardingRulesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchGlobalForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.SetTargetGlobalForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.stub.GlobalForwardingRuleStub;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalForwardingRuleStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class GlobalForwardingRuleStubSettings
extends StubSettings<GlobalForwardingRuleStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteGlobalForwardingRuleHttpRequest, Operation> deleteGlobalForwardingRuleSettings;
    private final UnaryCallSettings<GetGlobalForwardingRuleHttpRequest, ForwardingRule> getGlobalForwardingRuleSettings;
    private final UnaryCallSettings<InsertGlobalForwardingRuleHttpRequest, Operation> insertGlobalForwardingRuleSettings;
    private final PagedCallSettings<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, GlobalForwardingRuleClient.ListGlobalForwardingRulesPagedResponse> listGlobalForwardingRulesSettings;
    private final UnaryCallSettings<PatchGlobalForwardingRuleHttpRequest, Operation> patchGlobalForwardingRuleSettings;
    private final UnaryCallSettings<SetTargetGlobalForwardingRuleHttpRequest, Operation> setTargetGlobalForwardingRuleSettings;
    private static final PagedListDescriptor<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule> LIST_GLOBAL_FORWARDING_RULES_PAGE_STR_DESC = new PagedListDescriptor<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule>(){

        public String emptyToken() {
            return "";
        }

        public ListGlobalForwardingRulesHttpRequest injectToken(ListGlobalForwardingRulesHttpRequest payload, String token) {
            return ListGlobalForwardingRulesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListGlobalForwardingRulesHttpRequest injectPageSize(ListGlobalForwardingRulesHttpRequest payload, int pageSize) {
            return ListGlobalForwardingRulesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListGlobalForwardingRulesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ForwardingRuleList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ForwardingRule> extractResources(ForwardingRuleList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, GlobalForwardingRuleClient.ListGlobalForwardingRulesPagedResponse> LIST_GLOBAL_FORWARDING_RULES_PAGE_STR_FACT = new PagedListResponseFactory<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, GlobalForwardingRuleClient.ListGlobalForwardingRulesPagedResponse>(){

        public ApiFuture<GlobalForwardingRuleClient.ListGlobalForwardingRulesPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList> callable, ListGlobalForwardingRulesHttpRequest request, ApiCallContext context, ApiFuture<ForwardingRuleList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GLOBAL_FORWARDING_RULES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GlobalForwardingRuleClient.ListGlobalForwardingRulesPagedResponse.createAsync((PageContext<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteGlobalForwardingRuleHttpRequest, Operation> deleteGlobalForwardingRuleSettings() {
        return this.deleteGlobalForwardingRuleSettings;
    }

    public UnaryCallSettings<GetGlobalForwardingRuleHttpRequest, ForwardingRule> getGlobalForwardingRuleSettings() {
        return this.getGlobalForwardingRuleSettings;
    }

    public UnaryCallSettings<InsertGlobalForwardingRuleHttpRequest, Operation> insertGlobalForwardingRuleSettings() {
        return this.insertGlobalForwardingRuleSettings;
    }

    public PagedCallSettings<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, GlobalForwardingRuleClient.ListGlobalForwardingRulesPagedResponse> listGlobalForwardingRulesSettings() {
        return this.listGlobalForwardingRulesSettings;
    }

    public UnaryCallSettings<PatchGlobalForwardingRuleHttpRequest, Operation> patchGlobalForwardingRuleSettings() {
        return this.patchGlobalForwardingRuleSettings;
    }

    public UnaryCallSettings<SetTargetGlobalForwardingRuleHttpRequest, Operation> setTargetGlobalForwardingRuleSettings() {
        return this.setTargetGlobalForwardingRuleSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalForwardingRuleStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGlobalForwardingRuleStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GlobalForwardingRuleStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GlobalForwardingRuleStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GlobalForwardingRuleStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteGlobalForwardingRuleSettings = settingsBuilder.deleteGlobalForwardingRuleSettings().build();
        this.getGlobalForwardingRuleSettings = settingsBuilder.getGlobalForwardingRuleSettings().build();
        this.insertGlobalForwardingRuleSettings = settingsBuilder.insertGlobalForwardingRuleSettings().build();
        this.listGlobalForwardingRulesSettings = settingsBuilder.listGlobalForwardingRulesSettings().build();
        this.patchGlobalForwardingRuleSettings = settingsBuilder.patchGlobalForwardingRuleSettings().build();
        this.setTargetGlobalForwardingRuleSettings = settingsBuilder.setTargetGlobalForwardingRuleSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GlobalForwardingRuleStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteGlobalForwardingRuleHttpRequest, Operation> deleteGlobalForwardingRuleSettings;
        private final UnaryCallSettings.Builder<GetGlobalForwardingRuleHttpRequest, ForwardingRule> getGlobalForwardingRuleSettings;
        private final UnaryCallSettings.Builder<InsertGlobalForwardingRuleHttpRequest, Operation> insertGlobalForwardingRuleSettings;
        private final PagedCallSettings.Builder<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, GlobalForwardingRuleClient.ListGlobalForwardingRulesPagedResponse> listGlobalForwardingRulesSettings;
        private final UnaryCallSettings.Builder<PatchGlobalForwardingRuleHttpRequest, Operation> patchGlobalForwardingRuleSettings;
        private final UnaryCallSettings.Builder<SetTargetGlobalForwardingRuleHttpRequest, Operation> setTargetGlobalForwardingRuleSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteGlobalForwardingRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGlobalForwardingRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertGlobalForwardingRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGlobalForwardingRulesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GLOBAL_FORWARDING_RULES_PAGE_STR_FACT);
            this.patchGlobalForwardingRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setTargetGlobalForwardingRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteGlobalForwardingRuleSettings, this.getGlobalForwardingRuleSettings, this.insertGlobalForwardingRuleSettings, this.listGlobalForwardingRulesSettings, this.patchGlobalForwardingRuleSettings, this.setTargetGlobalForwardingRuleSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GlobalForwardingRuleStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GlobalForwardingRuleStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GlobalForwardingRuleStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GlobalForwardingRuleStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteGlobalForwardingRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getGlobalForwardingRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertGlobalForwardingRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listGlobalForwardingRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchGlobalForwardingRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setTargetGlobalForwardingRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(GlobalForwardingRuleStubSettings settings) {
            super((StubSettings)settings);
            this.deleteGlobalForwardingRuleSettings = settings.deleteGlobalForwardingRuleSettings.toBuilder();
            this.getGlobalForwardingRuleSettings = settings.getGlobalForwardingRuleSettings.toBuilder();
            this.insertGlobalForwardingRuleSettings = settings.insertGlobalForwardingRuleSettings.toBuilder();
            this.listGlobalForwardingRulesSettings = settings.listGlobalForwardingRulesSettings.toBuilder();
            this.patchGlobalForwardingRuleSettings = settings.patchGlobalForwardingRuleSettings.toBuilder();
            this.setTargetGlobalForwardingRuleSettings = settings.setTargetGlobalForwardingRuleSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteGlobalForwardingRuleSettings, this.getGlobalForwardingRuleSettings, this.insertGlobalForwardingRuleSettings, this.listGlobalForwardingRulesSettings, this.patchGlobalForwardingRuleSettings, this.setTargetGlobalForwardingRuleSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteGlobalForwardingRuleHttpRequest, Operation> deleteGlobalForwardingRuleSettings() {
            return this.deleteGlobalForwardingRuleSettings;
        }

        public UnaryCallSettings.Builder<GetGlobalForwardingRuleHttpRequest, ForwardingRule> getGlobalForwardingRuleSettings() {
            return this.getGlobalForwardingRuleSettings;
        }

        public UnaryCallSettings.Builder<InsertGlobalForwardingRuleHttpRequest, Operation> insertGlobalForwardingRuleSettings() {
            return this.insertGlobalForwardingRuleSettings;
        }

        public PagedCallSettings.Builder<ListGlobalForwardingRulesHttpRequest, ForwardingRuleList, GlobalForwardingRuleClient.ListGlobalForwardingRulesPagedResponse> listGlobalForwardingRulesSettings() {
            return this.listGlobalForwardingRulesSettings;
        }

        public UnaryCallSettings.Builder<PatchGlobalForwardingRuleHttpRequest, Operation> patchGlobalForwardingRuleSettings() {
            return this.patchGlobalForwardingRuleSettings;
        }

        public UnaryCallSettings.Builder<SetTargetGlobalForwardingRuleHttpRequest, Operation> setTargetGlobalForwardingRuleSettings() {
            return this.setTargetGlobalForwardingRuleSettings;
        }

        public GlobalForwardingRuleStubSettings build() throws IOException {
            return new GlobalForwardingRuleStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

