/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ShieldedInstanceIdentityEntry
implements ApiMessage {
    private final String ekCert;
    private final String ekPub;
    private static final ShieldedInstanceIdentityEntry DEFAULT_INSTANCE = new ShieldedInstanceIdentityEntry();

    private ShieldedInstanceIdentityEntry() {
        this.ekCert = null;
        this.ekPub = null;
    }

    private ShieldedInstanceIdentityEntry(String ekCert, String ekPub) {
        this.ekCert = ekCert;
        this.ekPub = ekPub;
    }

    public Object getFieldValue(String fieldName) {
        if ("ekCert".equals(fieldName)) {
            return this.ekCert;
        }
        if ("ekPub".equals(fieldName)) {
            return this.ekPub;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getEkCert() {
        return this.ekCert;
    }

    public String getEkPub() {
        return this.ekPub;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ShieldedInstanceIdentityEntry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ShieldedInstanceIdentityEntry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ShieldedInstanceIdentityEntry{ekCert=" + this.ekCert + ", ekPub=" + this.ekPub + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ShieldedInstanceIdentityEntry) {
            ShieldedInstanceIdentityEntry that = (ShieldedInstanceIdentityEntry)o;
            return Objects.equals(this.ekCert, that.getEkCert()) && Objects.equals(this.ekPub, that.getEkPub());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.ekCert, this.ekPub);
    }

    public static class Builder {
        private String ekCert;
        private String ekPub;

        Builder() {
        }

        public Builder mergeFrom(ShieldedInstanceIdentityEntry other) {
            if (other == ShieldedInstanceIdentityEntry.getDefaultInstance()) {
                return this;
            }
            if (other.getEkCert() != null) {
                this.ekCert = other.ekCert;
            }
            if (other.getEkPub() != null) {
                this.ekPub = other.ekPub;
            }
            return this;
        }

        Builder(ShieldedInstanceIdentityEntry source) {
            this.ekCert = source.ekCert;
            this.ekPub = source.ekPub;
        }

        public String getEkCert() {
            return this.ekCert;
        }

        public Builder setEkCert(String ekCert) {
            this.ekCert = ekCert;
            return this;
        }

        public String getEkPub() {
            return this.ekPub;
        }

        public Builder setEkPub(String ekPub) {
            this.ekPub = ekPub;
            return this;
        }

        public ShieldedInstanceIdentityEntry build() {
            return new ShieldedInstanceIdentityEntry(this.ekCert, this.ekPub);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setEkCert(this.ekCert);
            newBuilder.setEkPub(this.ekPub);
            return newBuilder;
        }
    }
}

