/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AcceleratorType;
import com.google.cloud.compute.v1.AcceleratorTypeAggregatedList;
import com.google.cloud.compute.v1.AcceleratorTypeList;
import com.google.cloud.compute.v1.AcceleratorTypeSettings;
import com.google.cloud.compute.v1.AcceleratorTypesScopedList;
import com.google.cloud.compute.v1.AggregatedListAcceleratorTypesHttpRequest;
import com.google.cloud.compute.v1.GetAcceleratorTypeHttpRequest;
import com.google.cloud.compute.v1.ListAcceleratorTypesHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneAcceleratorTypeName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.stub.AcceleratorTypeStub;
import com.google.cloud.compute.v1.stub.AcceleratorTypeStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AcceleratorTypeClient
implements BackgroundResource {
    private final AcceleratorTypeSettings settings;
    private final AcceleratorTypeStub stub;

    public static final AcceleratorTypeClient create() throws IOException {
        return AcceleratorTypeClient.create(AcceleratorTypeSettings.newBuilder().build());
    }

    public static final AcceleratorTypeClient create(AcceleratorTypeSettings settings) throws IOException {
        return new AcceleratorTypeClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AcceleratorTypeClient create(AcceleratorTypeStub stub) {
        return new AcceleratorTypeClient(stub);
    }

    protected AcceleratorTypeClient(AcceleratorTypeSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AcceleratorTypeStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AcceleratorTypeClient(AcceleratorTypeStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AcceleratorTypeSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AcceleratorTypeStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListAcceleratorTypesPagedResponse aggregatedListAcceleratorTypes(Boolean includeAllScopes, ProjectName project) {
        AggregatedListAcceleratorTypesHttpRequest request = AggregatedListAcceleratorTypesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListAcceleratorTypes(request);
    }

    @BetaApi
    public final AggregatedListAcceleratorTypesPagedResponse aggregatedListAcceleratorTypes(Boolean includeAllScopes, String project) {
        AggregatedListAcceleratorTypesHttpRequest request = AggregatedListAcceleratorTypesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListAcceleratorTypes(request);
    }

    @BetaApi
    public final AggregatedListAcceleratorTypesPagedResponse aggregatedListAcceleratorTypes(AggregatedListAcceleratorTypesHttpRequest request) {
        return (AggregatedListAcceleratorTypesPagedResponse)((Object)this.aggregatedListAcceleratorTypesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListAcceleratorTypesHttpRequest, AggregatedListAcceleratorTypesPagedResponse> aggregatedListAcceleratorTypesPagedCallable() {
        return this.stub.aggregatedListAcceleratorTypesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList> aggregatedListAcceleratorTypesCallable() {
        return this.stub.aggregatedListAcceleratorTypesCallable();
    }

    @BetaApi
    public final AcceleratorType getAcceleratorType(ProjectZoneAcceleratorTypeName acceleratorType) {
        GetAcceleratorTypeHttpRequest request = GetAcceleratorTypeHttpRequest.newBuilder().setAcceleratorType(acceleratorType == null ? null : acceleratorType.toString()).build();
        return this.getAcceleratorType(request);
    }

    @BetaApi
    public final AcceleratorType getAcceleratorType(String acceleratorType) {
        GetAcceleratorTypeHttpRequest request = GetAcceleratorTypeHttpRequest.newBuilder().setAcceleratorType(acceleratorType).build();
        return this.getAcceleratorType(request);
    }

    @BetaApi
    public final AcceleratorType getAcceleratorType(GetAcceleratorTypeHttpRequest request) {
        return (AcceleratorType)this.getAcceleratorTypeCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetAcceleratorTypeHttpRequest, AcceleratorType> getAcceleratorTypeCallable() {
        return this.stub.getAcceleratorTypeCallable();
    }

    @BetaApi
    public final ListAcceleratorTypesPagedResponse listAcceleratorTypes(ProjectZoneName zone) {
        ListAcceleratorTypesHttpRequest request = ListAcceleratorTypesHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listAcceleratorTypes(request);
    }

    @BetaApi
    public final ListAcceleratorTypesPagedResponse listAcceleratorTypes(String zone) {
        ListAcceleratorTypesHttpRequest request = ListAcceleratorTypesHttpRequest.newBuilder().setZone(zone).build();
        return this.listAcceleratorTypes(request);
    }

    @BetaApi
    public final ListAcceleratorTypesPagedResponse listAcceleratorTypes(ListAcceleratorTypesHttpRequest request) {
        return (ListAcceleratorTypesPagedResponse)((Object)this.listAcceleratorTypesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListAcceleratorTypesHttpRequest, ListAcceleratorTypesPagedResponse> listAcceleratorTypesPagedCallable() {
        return this.stub.listAcceleratorTypesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListAcceleratorTypesHttpRequest, AcceleratorTypeList> listAcceleratorTypesCallable() {
        return this.stub.listAcceleratorTypesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAcceleratorTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorType, ListAcceleratorTypesPage, ListAcceleratorTypesFixedSizeCollection> {
        private ListAcceleratorTypesFixedSizeCollection(List<ListAcceleratorTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAcceleratorTypesFixedSizeCollection createEmptyCollection() {
            return new ListAcceleratorTypesFixedSizeCollection(null, 0);
        }

        protected ListAcceleratorTypesFixedSizeCollection createCollection(List<ListAcceleratorTypesPage> pages, int collectionSize) {
            return new ListAcceleratorTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAcceleratorTypesPage
    extends AbstractPage<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorType, ListAcceleratorTypesPage> {
        private ListAcceleratorTypesPage(PageContext<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorType> context, AcceleratorTypeList response) {
            super(context, (Object)response);
        }

        private static ListAcceleratorTypesPage createEmptyPage() {
            return new ListAcceleratorTypesPage(null, null);
        }

        protected ListAcceleratorTypesPage createPage(PageContext<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorType> context, AcceleratorTypeList response) {
            return new ListAcceleratorTypesPage(context, response);
        }

        public ApiFuture<ListAcceleratorTypesPage> createPageAsync(PageContext<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorType> context, ApiFuture<AcceleratorTypeList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAcceleratorTypesPagedResponse
    extends AbstractPagedListResponse<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorType, ListAcceleratorTypesPage, ListAcceleratorTypesFixedSizeCollection> {
        public static ApiFuture<ListAcceleratorTypesPagedResponse> createAsync(PageContext<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorType> context, ApiFuture<AcceleratorTypeList> futureResponse) {
            ApiFuture<ListAcceleratorTypesPage> futurePage = ListAcceleratorTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListAcceleratorTypesPage, ListAcceleratorTypesPagedResponse>(){

                public ListAcceleratorTypesPagedResponse apply(ListAcceleratorTypesPage input) {
                    return new ListAcceleratorTypesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListAcceleratorTypesPagedResponse(ListAcceleratorTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAcceleratorTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListAcceleratorTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypesScopedList, AggregatedListAcceleratorTypesPage, AggregatedListAcceleratorTypesFixedSizeCollection> {
        private AggregatedListAcceleratorTypesFixedSizeCollection(List<AggregatedListAcceleratorTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListAcceleratorTypesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListAcceleratorTypesFixedSizeCollection(null, 0);
        }

        protected AggregatedListAcceleratorTypesFixedSizeCollection createCollection(List<AggregatedListAcceleratorTypesPage> pages, int collectionSize) {
            return new AggregatedListAcceleratorTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListAcceleratorTypesPage
    extends AbstractPage<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypesScopedList, AggregatedListAcceleratorTypesPage> {
        private AggregatedListAcceleratorTypesPage(PageContext<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypesScopedList> context, AcceleratorTypeAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListAcceleratorTypesPage createEmptyPage() {
            return new AggregatedListAcceleratorTypesPage(null, null);
        }

        protected AggregatedListAcceleratorTypesPage createPage(PageContext<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypesScopedList> context, AcceleratorTypeAggregatedList response) {
            return new AggregatedListAcceleratorTypesPage(context, response);
        }

        public ApiFuture<AggregatedListAcceleratorTypesPage> createPageAsync(PageContext<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypesScopedList> context, ApiFuture<AcceleratorTypeAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListAcceleratorTypesPagedResponse
    extends AbstractPagedListResponse<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypesScopedList, AggregatedListAcceleratorTypesPage, AggregatedListAcceleratorTypesFixedSizeCollection> {
        public static ApiFuture<AggregatedListAcceleratorTypesPagedResponse> createAsync(PageContext<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypesScopedList> context, ApiFuture<AcceleratorTypeAggregatedList> futureResponse) {
            ApiFuture<AggregatedListAcceleratorTypesPage> futurePage = AggregatedListAcceleratorTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListAcceleratorTypesPage, AggregatedListAcceleratorTypesPagedResponse>(){

                public AggregatedListAcceleratorTypesPagedResponse apply(AggregatedListAcceleratorTypesPage input) {
                    return new AggregatedListAcceleratorTypesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListAcceleratorTypesPagedResponse(AggregatedListAcceleratorTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListAcceleratorTypesFixedSizeCollection.createEmptyCollection());
        }
    }
}

