/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HttpRedirectAction
implements ApiMessage {
    private final String hostRedirect;
    private final Boolean httpsRedirect;
    private final String pathRedirect;
    private final String prefixRedirect;
    private final String redirectResponseCode;
    private final Boolean stripQuery;
    private static final HttpRedirectAction DEFAULT_INSTANCE = new HttpRedirectAction();

    private HttpRedirectAction() {
        this.hostRedirect = null;
        this.httpsRedirect = null;
        this.pathRedirect = null;
        this.prefixRedirect = null;
        this.redirectResponseCode = null;
        this.stripQuery = null;
    }

    private HttpRedirectAction(String hostRedirect, Boolean httpsRedirect, String pathRedirect, String prefixRedirect, String redirectResponseCode, Boolean stripQuery) {
        this.hostRedirect = hostRedirect;
        this.httpsRedirect = httpsRedirect;
        this.pathRedirect = pathRedirect;
        this.prefixRedirect = prefixRedirect;
        this.redirectResponseCode = redirectResponseCode;
        this.stripQuery = stripQuery;
    }

    public Object getFieldValue(String fieldName) {
        if ("hostRedirect".equals(fieldName)) {
            return this.hostRedirect;
        }
        if ("httpsRedirect".equals(fieldName)) {
            return this.httpsRedirect;
        }
        if ("pathRedirect".equals(fieldName)) {
            return this.pathRedirect;
        }
        if ("prefixRedirect".equals(fieldName)) {
            return this.prefixRedirect;
        }
        if ("redirectResponseCode".equals(fieldName)) {
            return this.redirectResponseCode;
        }
        if ("stripQuery".equals(fieldName)) {
            return this.stripQuery;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getHostRedirect() {
        return this.hostRedirect;
    }

    public Boolean getHttpsRedirect() {
        return this.httpsRedirect;
    }

    public String getPathRedirect() {
        return this.pathRedirect;
    }

    public String getPrefixRedirect() {
        return this.prefixRedirect;
    }

    public String getRedirectResponseCode() {
        return this.redirectResponseCode;
    }

    public Boolean getStripQuery() {
        return this.stripQuery;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HttpRedirectAction prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HttpRedirectAction getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HttpRedirectAction{hostRedirect=" + this.hostRedirect + ", httpsRedirect=" + this.httpsRedirect + ", pathRedirect=" + this.pathRedirect + ", prefixRedirect=" + this.prefixRedirect + ", redirectResponseCode=" + this.redirectResponseCode + ", stripQuery=" + this.stripQuery + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRedirectAction) {
            HttpRedirectAction that = (HttpRedirectAction)o;
            return Objects.equals(this.hostRedirect, that.getHostRedirect()) && Objects.equals(this.httpsRedirect, that.getHttpsRedirect()) && Objects.equals(this.pathRedirect, that.getPathRedirect()) && Objects.equals(this.prefixRedirect, that.getPrefixRedirect()) && Objects.equals(this.redirectResponseCode, that.getRedirectResponseCode()) && Objects.equals(this.stripQuery, that.getStripQuery());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.hostRedirect, this.httpsRedirect, this.pathRedirect, this.prefixRedirect, this.redirectResponseCode, this.stripQuery);
    }

    public static class Builder {
        private String hostRedirect;
        private Boolean httpsRedirect;
        private String pathRedirect;
        private String prefixRedirect;
        private String redirectResponseCode;
        private Boolean stripQuery;

        Builder() {
        }

        public Builder mergeFrom(HttpRedirectAction other) {
            if (other == HttpRedirectAction.getDefaultInstance()) {
                return this;
            }
            if (other.getHostRedirect() != null) {
                this.hostRedirect = other.hostRedirect;
            }
            if (other.getHttpsRedirect() != null) {
                this.httpsRedirect = other.httpsRedirect;
            }
            if (other.getPathRedirect() != null) {
                this.pathRedirect = other.pathRedirect;
            }
            if (other.getPrefixRedirect() != null) {
                this.prefixRedirect = other.prefixRedirect;
            }
            if (other.getRedirectResponseCode() != null) {
                this.redirectResponseCode = other.redirectResponseCode;
            }
            if (other.getStripQuery() != null) {
                this.stripQuery = other.stripQuery;
            }
            return this;
        }

        Builder(HttpRedirectAction source) {
            this.hostRedirect = source.hostRedirect;
            this.httpsRedirect = source.httpsRedirect;
            this.pathRedirect = source.pathRedirect;
            this.prefixRedirect = source.prefixRedirect;
            this.redirectResponseCode = source.redirectResponseCode;
            this.stripQuery = source.stripQuery;
        }

        public String getHostRedirect() {
            return this.hostRedirect;
        }

        public Builder setHostRedirect(String hostRedirect) {
            this.hostRedirect = hostRedirect;
            return this;
        }

        public Boolean getHttpsRedirect() {
            return this.httpsRedirect;
        }

        public Builder setHttpsRedirect(Boolean httpsRedirect) {
            this.httpsRedirect = httpsRedirect;
            return this;
        }

        public String getPathRedirect() {
            return this.pathRedirect;
        }

        public Builder setPathRedirect(String pathRedirect) {
            this.pathRedirect = pathRedirect;
            return this;
        }

        public String getPrefixRedirect() {
            return this.prefixRedirect;
        }

        public Builder setPrefixRedirect(String prefixRedirect) {
            this.prefixRedirect = prefixRedirect;
            return this;
        }

        public String getRedirectResponseCode() {
            return this.redirectResponseCode;
        }

        public Builder setRedirectResponseCode(String redirectResponseCode) {
            this.redirectResponseCode = redirectResponseCode;
            return this;
        }

        public Boolean getStripQuery() {
            return this.stripQuery;
        }

        public Builder setStripQuery(Boolean stripQuery) {
            this.stripQuery = stripQuery;
            return this;
        }

        public HttpRedirectAction build() {
            return new HttpRedirectAction(this.hostRedirect, this.httpsRedirect, this.pathRedirect, this.prefixRedirect, this.redirectResponseCode, this.stripQuery);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setHostRedirect(this.hostRedirect);
            newBuilder.setHttpsRedirect(this.httpsRedirect);
            newBuilder.setPathRedirect(this.pathRedirect);
            newBuilder.setPrefixRedirect(this.prefixRedirect);
            newBuilder.setRedirectResponseCode(this.redirectResponseCode);
            newBuilder.setStripQuery(this.stripQuery);
            return newBuilder;
        }
    }
}

