/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NodeGroupAutoscalingPolicy
implements ApiMessage {
    private final Integer maxNodes;
    private final Integer minNodes;
    private final String mode;
    private static final NodeGroupAutoscalingPolicy DEFAULT_INSTANCE = new NodeGroupAutoscalingPolicy();

    private NodeGroupAutoscalingPolicy() {
        this.maxNodes = null;
        this.minNodes = null;
        this.mode = null;
    }

    private NodeGroupAutoscalingPolicy(Integer maxNodes, Integer minNodes, String mode) {
        this.maxNodes = maxNodes;
        this.minNodes = minNodes;
        this.mode = mode;
    }

    public Object getFieldValue(String fieldName) {
        if ("maxNodes".equals(fieldName)) {
            return this.maxNodes;
        }
        if ("minNodes".equals(fieldName)) {
            return this.minNodes;
        }
        if ("mode".equals(fieldName)) {
            return this.mode;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Integer getMaxNodes() {
        return this.maxNodes;
    }

    public Integer getMinNodes() {
        return this.minNodes;
    }

    public String getMode() {
        return this.mode;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NodeGroupAutoscalingPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NodeGroupAutoscalingPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NodeGroupAutoscalingPolicy{maxNodes=" + this.maxNodes + ", minNodes=" + this.minNodes + ", mode=" + this.mode + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NodeGroupAutoscalingPolicy) {
            NodeGroupAutoscalingPolicy that = (NodeGroupAutoscalingPolicy)o;
            return Objects.equals(this.maxNodes, that.getMaxNodes()) && Objects.equals(this.minNodes, that.getMinNodes()) && Objects.equals(this.mode, that.getMode());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.maxNodes, this.minNodes, this.mode);
    }

    public static class Builder {
        private Integer maxNodes;
        private Integer minNodes;
        private String mode;

        Builder() {
        }

        public Builder mergeFrom(NodeGroupAutoscalingPolicy other) {
            if (other == NodeGroupAutoscalingPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getMaxNodes() != null) {
                this.maxNodes = other.maxNodes;
            }
            if (other.getMinNodes() != null) {
                this.minNodes = other.minNodes;
            }
            if (other.getMode() != null) {
                this.mode = other.mode;
            }
            return this;
        }

        Builder(NodeGroupAutoscalingPolicy source) {
            this.maxNodes = source.maxNodes;
            this.minNodes = source.minNodes;
            this.mode = source.mode;
        }

        public Integer getMaxNodes() {
            return this.maxNodes;
        }

        public Builder setMaxNodes(Integer maxNodes) {
            this.maxNodes = maxNodes;
            return this;
        }

        public Integer getMinNodes() {
            return this.minNodes;
        }

        public Builder setMinNodes(Integer minNodes) {
            this.minNodes = minNodes;
            return this;
        }

        public String getMode() {
            return this.mode;
        }

        public Builder setMode(String mode) {
            this.mode = mode;
            return this;
        }

        public NodeGroupAutoscalingPolicy build() {
            return new NodeGroupAutoscalingPolicy(this.maxNodes, this.minNodes, this.mode);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setMaxNodes(this.maxNodes);
            newBuilder.setMinNodes(this.minNodes);
            newBuilder.setMode(this.mode);
            return newBuilder;
        }
    }
}

