/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.FixedOrPercent;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagerUpdatePolicy
implements ApiMessage {
    private final String instanceRedistributionType;
    private final FixedOrPercent maxSurge;
    private final FixedOrPercent maxUnavailable;
    private final String minimalAction;
    private final String replacementMethod;
    private final String type;
    private static final InstanceGroupManagerUpdatePolicy DEFAULT_INSTANCE = new InstanceGroupManagerUpdatePolicy();

    private InstanceGroupManagerUpdatePolicy() {
        this.instanceRedistributionType = null;
        this.maxSurge = null;
        this.maxUnavailable = null;
        this.minimalAction = null;
        this.replacementMethod = null;
        this.type = null;
    }

    private InstanceGroupManagerUpdatePolicy(String instanceRedistributionType, FixedOrPercent maxSurge, FixedOrPercent maxUnavailable, String minimalAction, String replacementMethod, String type) {
        this.instanceRedistributionType = instanceRedistributionType;
        this.maxSurge = maxSurge;
        this.maxUnavailable = maxUnavailable;
        this.minimalAction = minimalAction;
        this.replacementMethod = replacementMethod;
        this.type = type;
    }

    public Object getFieldValue(String fieldName) {
        if ("instanceRedistributionType".equals(fieldName)) {
            return this.instanceRedistributionType;
        }
        if ("maxSurge".equals(fieldName)) {
            return this.maxSurge;
        }
        if ("maxUnavailable".equals(fieldName)) {
            return this.maxUnavailable;
        }
        if ("minimalAction".equals(fieldName)) {
            return this.minimalAction;
        }
        if ("replacementMethod".equals(fieldName)) {
            return this.replacementMethod;
        }
        if ("type".equals(fieldName)) {
            return this.type;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getInstanceRedistributionType() {
        return this.instanceRedistributionType;
    }

    public FixedOrPercent getMaxSurge() {
        return this.maxSurge;
    }

    public FixedOrPercent getMaxUnavailable() {
        return this.maxUnavailable;
    }

    public String getMinimalAction() {
        return this.minimalAction;
    }

    public String getReplacementMethod() {
        return this.replacementMethod;
    }

    public String getType() {
        return this.type;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagerUpdatePolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagerUpdatePolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagerUpdatePolicy{instanceRedistributionType=" + this.instanceRedistributionType + ", maxSurge=" + this.maxSurge + ", maxUnavailable=" + this.maxUnavailable + ", minimalAction=" + this.minimalAction + ", replacementMethod=" + this.replacementMethod + ", type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagerUpdatePolicy) {
            InstanceGroupManagerUpdatePolicy that = (InstanceGroupManagerUpdatePolicy)o;
            return Objects.equals(this.instanceRedistributionType, that.getInstanceRedistributionType()) && Objects.equals(this.maxSurge, that.getMaxSurge()) && Objects.equals(this.maxUnavailable, that.getMaxUnavailable()) && Objects.equals(this.minimalAction, that.getMinimalAction()) && Objects.equals(this.replacementMethod, that.getReplacementMethod()) && Objects.equals(this.type, that.getType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceRedistributionType, this.maxSurge, this.maxUnavailable, this.minimalAction, this.replacementMethod, this.type);
    }

    public static class Builder {
        private String instanceRedistributionType;
        private FixedOrPercent maxSurge;
        private FixedOrPercent maxUnavailable;
        private String minimalAction;
        private String replacementMethod;
        private String type;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagerUpdatePolicy other) {
            if (other == InstanceGroupManagerUpdatePolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getInstanceRedistributionType() != null) {
                this.instanceRedistributionType = other.instanceRedistributionType;
            }
            if (other.getMaxSurge() != null) {
                this.maxSurge = other.maxSurge;
            }
            if (other.getMaxUnavailable() != null) {
                this.maxUnavailable = other.maxUnavailable;
            }
            if (other.getMinimalAction() != null) {
                this.minimalAction = other.minimalAction;
            }
            if (other.getReplacementMethod() != null) {
                this.replacementMethod = other.replacementMethod;
            }
            if (other.getType() != null) {
                this.type = other.type;
            }
            return this;
        }

        Builder(InstanceGroupManagerUpdatePolicy source) {
            this.instanceRedistributionType = source.instanceRedistributionType;
            this.maxSurge = source.maxSurge;
            this.maxUnavailable = source.maxUnavailable;
            this.minimalAction = source.minimalAction;
            this.replacementMethod = source.replacementMethod;
            this.type = source.type;
        }

        public String getInstanceRedistributionType() {
            return this.instanceRedistributionType;
        }

        public Builder setInstanceRedistributionType(String instanceRedistributionType) {
            this.instanceRedistributionType = instanceRedistributionType;
            return this;
        }

        public FixedOrPercent getMaxSurge() {
            return this.maxSurge;
        }

        public Builder setMaxSurge(FixedOrPercent maxSurge) {
            this.maxSurge = maxSurge;
            return this;
        }

        public FixedOrPercent getMaxUnavailable() {
            return this.maxUnavailable;
        }

        public Builder setMaxUnavailable(FixedOrPercent maxUnavailable) {
            this.maxUnavailable = maxUnavailable;
            return this;
        }

        public String getMinimalAction() {
            return this.minimalAction;
        }

        public Builder setMinimalAction(String minimalAction) {
            this.minimalAction = minimalAction;
            return this;
        }

        public String getReplacementMethod() {
            return this.replacementMethod;
        }

        public Builder setReplacementMethod(String replacementMethod) {
            this.replacementMethod = replacementMethod;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public InstanceGroupManagerUpdatePolicy build() {
            return new InstanceGroupManagerUpdatePolicy(this.instanceRedistributionType, this.maxSurge, this.maxUnavailable, this.minimalAction, this.replacementMethod, this.type);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setInstanceRedistributionType(this.instanceRedistributionType);
            newBuilder.setMaxSurge(this.maxSurge);
            newBuilder.setMaxUnavailable(this.maxUnavailable);
            newBuilder.setMinimalAction(this.minimalAction);
            newBuilder.setReplacementMethod(this.replacementMethod);
            newBuilder.setType(this.type);
            return newBuilder;
        }
    }
}

