/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetGrpcProxyHttpRequest;
import com.google.cloud.compute.v1.GetTargetGrpcProxyHttpRequest;
import com.google.cloud.compute.v1.InsertTargetGrpcProxyHttpRequest;
import com.google.cloud.compute.v1.ListTargetGrpcProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchTargetGrpcProxyHttpRequest;
import com.google.cloud.compute.v1.TargetGrpcProxy;
import com.google.cloud.compute.v1.TargetGrpcProxyClient;
import com.google.cloud.compute.v1.TargetGrpcProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetGrpcProxyStub;
import com.google.cloud.compute.v1.stub.TargetGrpcProxyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TargetGrpcProxyStubSettings
extends StubSettings<TargetGrpcProxyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteTargetGrpcProxyHttpRequest, Operation> deleteTargetGrpcProxySettings;
    private final UnaryCallSettings<GetTargetGrpcProxyHttpRequest, TargetGrpcProxy> getTargetGrpcProxySettings;
    private final UnaryCallSettings<InsertTargetGrpcProxyHttpRequest, Operation> insertTargetGrpcProxySettings;
    private final PagedCallSettings<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxyClient.ListTargetGrpcProxiesPagedResponse> listTargetGrpcProxiesSettings;
    private final UnaryCallSettings<PatchTargetGrpcProxyHttpRequest, Operation> patchTargetGrpcProxySettings;
    private static final PagedListDescriptor<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxy> LIST_TARGET_GRPC_PROXIES_PAGE_STR_DESC = new PagedListDescriptor<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetGrpcProxiesHttpRequest injectToken(ListTargetGrpcProxiesHttpRequest payload, String token) {
            return ListTargetGrpcProxiesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListTargetGrpcProxiesHttpRequest injectPageSize(ListTargetGrpcProxiesHttpRequest payload, int pageSize) {
            return ListTargetGrpcProxiesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetGrpcProxiesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetGrpcProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetGrpcProxy> extractResources(TargetGrpcProxyList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxyClient.ListTargetGrpcProxiesPagedResponse> LIST_TARGET_GRPC_PROXIES_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxyClient.ListTargetGrpcProxiesPagedResponse>(){

        public ApiFuture<TargetGrpcProxyClient.ListTargetGrpcProxiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList> callable, ListTargetGrpcProxiesHttpRequest request, ApiCallContext context, ApiFuture<TargetGrpcProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TARGET_GRPC_PROXIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetGrpcProxyClient.ListTargetGrpcProxiesPagedResponse.createAsync((PageContext<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteTargetGrpcProxyHttpRequest, Operation> deleteTargetGrpcProxySettings() {
        return this.deleteTargetGrpcProxySettings;
    }

    public UnaryCallSettings<GetTargetGrpcProxyHttpRequest, TargetGrpcProxy> getTargetGrpcProxySettings() {
        return this.getTargetGrpcProxySettings;
    }

    public UnaryCallSettings<InsertTargetGrpcProxyHttpRequest, Operation> insertTargetGrpcProxySettings() {
        return this.insertTargetGrpcProxySettings;
    }

    public PagedCallSettings<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxyClient.ListTargetGrpcProxiesPagedResponse> listTargetGrpcProxiesSettings() {
        return this.listTargetGrpcProxiesSettings;
    }

    public UnaryCallSettings<PatchTargetGrpcProxyHttpRequest, Operation> patchTargetGrpcProxySettings() {
        return this.patchTargetGrpcProxySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetGrpcProxyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetGrpcProxyStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetGrpcProxyStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetGrpcProxyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetGrpcProxyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteTargetGrpcProxySettings = settingsBuilder.deleteTargetGrpcProxySettings().build();
        this.getTargetGrpcProxySettings = settingsBuilder.getTargetGrpcProxySettings().build();
        this.insertTargetGrpcProxySettings = settingsBuilder.insertTargetGrpcProxySettings().build();
        this.listTargetGrpcProxiesSettings = settingsBuilder.listTargetGrpcProxiesSettings().build();
        this.patchTargetGrpcProxySettings = settingsBuilder.patchTargetGrpcProxySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetGrpcProxyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteTargetGrpcProxyHttpRequest, Operation> deleteTargetGrpcProxySettings;
        private final UnaryCallSettings.Builder<GetTargetGrpcProxyHttpRequest, TargetGrpcProxy> getTargetGrpcProxySettings;
        private final UnaryCallSettings.Builder<InsertTargetGrpcProxyHttpRequest, Operation> insertTargetGrpcProxySettings;
        private final PagedCallSettings.Builder<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxyClient.ListTargetGrpcProxiesPagedResponse> listTargetGrpcProxiesSettings;
        private final UnaryCallSettings.Builder<PatchTargetGrpcProxyHttpRequest, Operation> patchTargetGrpcProxySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteTargetGrpcProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTargetGrpcProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertTargetGrpcProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTargetGrpcProxiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TARGET_GRPC_PROXIES_PAGE_STR_FACT);
            this.patchTargetGrpcProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteTargetGrpcProxySettings, this.getTargetGrpcProxySettings, this.insertTargetGrpcProxySettings, this.listTargetGrpcProxiesSettings, this.patchTargetGrpcProxySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetGrpcProxyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetGrpcProxyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetGrpcProxyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TargetGrpcProxyStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteTargetGrpcProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTargetGrpcProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertTargetGrpcProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTargetGrpcProxiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchTargetGrpcProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(TargetGrpcProxyStubSettings settings) {
            super((StubSettings)settings);
            this.deleteTargetGrpcProxySettings = settings.deleteTargetGrpcProxySettings.toBuilder();
            this.getTargetGrpcProxySettings = settings.getTargetGrpcProxySettings.toBuilder();
            this.insertTargetGrpcProxySettings = settings.insertTargetGrpcProxySettings.toBuilder();
            this.listTargetGrpcProxiesSettings = settings.listTargetGrpcProxiesSettings.toBuilder();
            this.patchTargetGrpcProxySettings = settings.patchTargetGrpcProxySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteTargetGrpcProxySettings, this.getTargetGrpcProxySettings, this.insertTargetGrpcProxySettings, this.listTargetGrpcProxiesSettings, this.patchTargetGrpcProxySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteTargetGrpcProxyHttpRequest, Operation> deleteTargetGrpcProxySettings() {
            return this.deleteTargetGrpcProxySettings;
        }

        public UnaryCallSettings.Builder<GetTargetGrpcProxyHttpRequest, TargetGrpcProxy> getTargetGrpcProxySettings() {
            return this.getTargetGrpcProxySettings;
        }

        public UnaryCallSettings.Builder<InsertTargetGrpcProxyHttpRequest, Operation> insertTargetGrpcProxySettings() {
            return this.insertTargetGrpcProxySettings;
        }

        public PagedCallSettings.Builder<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxyClient.ListTargetGrpcProxiesPagedResponse> listTargetGrpcProxiesSettings() {
            return this.listTargetGrpcProxiesSettings;
        }

        public UnaryCallSettings.Builder<PatchTargetGrpcProxyHttpRequest, Operation> patchTargetGrpcProxySettings() {
            return this.patchTargetGrpcProxySettings;
        }

        public TargetGrpcProxyStubSettings build() throws IOException {
            return new TargetGrpcProxyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

