/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.RouterNatLogConfig;
import com.google.cloud.compute.v1.RouterNatSubnetworkToNat;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RouterNat
implements ApiMessage {
    private final List<String> drainNatIps;
    private final Integer icmpIdleTimeoutSec;
    private final RouterNatLogConfig logConfig;
    private final Integer minPortsPerVm;
    private final String name;
    private final String natIpAllocateOption;
    private final List<String> natIps;
    private final String sourceSubnetworkIpRangesToNat;
    private final List<RouterNatSubnetworkToNat> subnetworks;
    private final Integer tcpEstablishedIdleTimeoutSec;
    private final Integer tcpTransitoryIdleTimeoutSec;
    private final Integer udpIdleTimeoutSec;
    private static final RouterNat DEFAULT_INSTANCE = new RouterNat();

    private RouterNat() {
        this.drainNatIps = null;
        this.icmpIdleTimeoutSec = null;
        this.logConfig = null;
        this.minPortsPerVm = null;
        this.name = null;
        this.natIpAllocateOption = null;
        this.natIps = null;
        this.sourceSubnetworkIpRangesToNat = null;
        this.subnetworks = null;
        this.tcpEstablishedIdleTimeoutSec = null;
        this.tcpTransitoryIdleTimeoutSec = null;
        this.udpIdleTimeoutSec = null;
    }

    private RouterNat(List<String> drainNatIps, Integer icmpIdleTimeoutSec, RouterNatLogConfig logConfig, Integer minPortsPerVm, String name, String natIpAllocateOption, List<String> natIps, String sourceSubnetworkIpRangesToNat, List<RouterNatSubnetworkToNat> subnetworks, Integer tcpEstablishedIdleTimeoutSec, Integer tcpTransitoryIdleTimeoutSec, Integer udpIdleTimeoutSec) {
        this.drainNatIps = drainNatIps;
        this.icmpIdleTimeoutSec = icmpIdleTimeoutSec;
        this.logConfig = logConfig;
        this.minPortsPerVm = minPortsPerVm;
        this.name = name;
        this.natIpAllocateOption = natIpAllocateOption;
        this.natIps = natIps;
        this.sourceSubnetworkIpRangesToNat = sourceSubnetworkIpRangesToNat;
        this.subnetworks = subnetworks;
        this.tcpEstablishedIdleTimeoutSec = tcpEstablishedIdleTimeoutSec;
        this.tcpTransitoryIdleTimeoutSec = tcpTransitoryIdleTimeoutSec;
        this.udpIdleTimeoutSec = udpIdleTimeoutSec;
    }

    public Object getFieldValue(String fieldName) {
        if ("drainNatIps".equals(fieldName)) {
            return this.drainNatIps;
        }
        if ("icmpIdleTimeoutSec".equals(fieldName)) {
            return this.icmpIdleTimeoutSec;
        }
        if ("logConfig".equals(fieldName)) {
            return this.logConfig;
        }
        if ("minPortsPerVm".equals(fieldName)) {
            return this.minPortsPerVm;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("natIpAllocateOption".equals(fieldName)) {
            return this.natIpAllocateOption;
        }
        if ("natIps".equals(fieldName)) {
            return this.natIps;
        }
        if ("sourceSubnetworkIpRangesToNat".equals(fieldName)) {
            return this.sourceSubnetworkIpRangesToNat;
        }
        if ("subnetworks".equals(fieldName)) {
            return this.subnetworks;
        }
        if ("tcpEstablishedIdleTimeoutSec".equals(fieldName)) {
            return this.tcpEstablishedIdleTimeoutSec;
        }
        if ("tcpTransitoryIdleTimeoutSec".equals(fieldName)) {
            return this.tcpTransitoryIdleTimeoutSec;
        }
        if ("udpIdleTimeoutSec".equals(fieldName)) {
            return this.udpIdleTimeoutSec;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getDrainNatIpsList() {
        return this.drainNatIps;
    }

    public Integer getIcmpIdleTimeoutSec() {
        return this.icmpIdleTimeoutSec;
    }

    public RouterNatLogConfig getLogConfig() {
        return this.logConfig;
    }

    public Integer getMinPortsPerVm() {
        return this.minPortsPerVm;
    }

    public String getName() {
        return this.name;
    }

    public String getNatIpAllocateOption() {
        return this.natIpAllocateOption;
    }

    public List<String> getNatIpsList() {
        return this.natIps;
    }

    public String getSourceSubnetworkIpRangesToNat() {
        return this.sourceSubnetworkIpRangesToNat;
    }

    public List<RouterNatSubnetworkToNat> getSubnetworksList() {
        return this.subnetworks;
    }

    public Integer getTcpEstablishedIdleTimeoutSec() {
        return this.tcpEstablishedIdleTimeoutSec;
    }

    public Integer getTcpTransitoryIdleTimeoutSec() {
        return this.tcpTransitoryIdleTimeoutSec;
    }

    public Integer getUdpIdleTimeoutSec() {
        return this.udpIdleTimeoutSec;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RouterNat prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RouterNat getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RouterNat{drainNatIps=" + this.drainNatIps + ", icmpIdleTimeoutSec=" + this.icmpIdleTimeoutSec + ", logConfig=" + this.logConfig + ", minPortsPerVm=" + this.minPortsPerVm + ", name=" + this.name + ", natIpAllocateOption=" + this.natIpAllocateOption + ", natIps=" + this.natIps + ", sourceSubnetworkIpRangesToNat=" + this.sourceSubnetworkIpRangesToNat + ", subnetworks=" + this.subnetworks + ", tcpEstablishedIdleTimeoutSec=" + this.tcpEstablishedIdleTimeoutSec + ", tcpTransitoryIdleTimeoutSec=" + this.tcpTransitoryIdleTimeoutSec + ", udpIdleTimeoutSec=" + this.udpIdleTimeoutSec + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RouterNat) {
            RouterNat that = (RouterNat)o;
            return Objects.equals(this.drainNatIps, that.getDrainNatIpsList()) && Objects.equals(this.icmpIdleTimeoutSec, that.getIcmpIdleTimeoutSec()) && Objects.equals(this.logConfig, that.getLogConfig()) && Objects.equals(this.minPortsPerVm, that.getMinPortsPerVm()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.natIpAllocateOption, that.getNatIpAllocateOption()) && Objects.equals(this.natIps, that.getNatIpsList()) && Objects.equals(this.sourceSubnetworkIpRangesToNat, that.getSourceSubnetworkIpRangesToNat()) && Objects.equals(this.subnetworks, that.getSubnetworksList()) && Objects.equals(this.tcpEstablishedIdleTimeoutSec, that.getTcpEstablishedIdleTimeoutSec()) && Objects.equals(this.tcpTransitoryIdleTimeoutSec, that.getTcpTransitoryIdleTimeoutSec()) && Objects.equals(this.udpIdleTimeoutSec, that.getUdpIdleTimeoutSec());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.drainNatIps, this.icmpIdleTimeoutSec, this.logConfig, this.minPortsPerVm, this.name, this.natIpAllocateOption, this.natIps, this.sourceSubnetworkIpRangesToNat, this.subnetworks, this.tcpEstablishedIdleTimeoutSec, this.tcpTransitoryIdleTimeoutSec, this.udpIdleTimeoutSec);
    }

    public static class Builder {
        private List<String> drainNatIps;
        private Integer icmpIdleTimeoutSec;
        private RouterNatLogConfig logConfig;
        private Integer minPortsPerVm;
        private String name;
        private String natIpAllocateOption;
        private List<String> natIps;
        private String sourceSubnetworkIpRangesToNat;
        private List<RouterNatSubnetworkToNat> subnetworks;
        private Integer tcpEstablishedIdleTimeoutSec;
        private Integer tcpTransitoryIdleTimeoutSec;
        private Integer udpIdleTimeoutSec;

        Builder() {
        }

        public Builder mergeFrom(RouterNat other) {
            if (other == RouterNat.getDefaultInstance()) {
                return this;
            }
            if (other.getDrainNatIpsList() != null) {
                this.drainNatIps = other.drainNatIps;
            }
            if (other.getIcmpIdleTimeoutSec() != null) {
                this.icmpIdleTimeoutSec = other.icmpIdleTimeoutSec;
            }
            if (other.getLogConfig() != null) {
                this.logConfig = other.logConfig;
            }
            if (other.getMinPortsPerVm() != null) {
                this.minPortsPerVm = other.minPortsPerVm;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNatIpAllocateOption() != null) {
                this.natIpAllocateOption = other.natIpAllocateOption;
            }
            if (other.getNatIpsList() != null) {
                this.natIps = other.natIps;
            }
            if (other.getSourceSubnetworkIpRangesToNat() != null) {
                this.sourceSubnetworkIpRangesToNat = other.sourceSubnetworkIpRangesToNat;
            }
            if (other.getSubnetworksList() != null) {
                this.subnetworks = other.subnetworks;
            }
            if (other.getTcpEstablishedIdleTimeoutSec() != null) {
                this.tcpEstablishedIdleTimeoutSec = other.tcpEstablishedIdleTimeoutSec;
            }
            if (other.getTcpTransitoryIdleTimeoutSec() != null) {
                this.tcpTransitoryIdleTimeoutSec = other.tcpTransitoryIdleTimeoutSec;
            }
            if (other.getUdpIdleTimeoutSec() != null) {
                this.udpIdleTimeoutSec = other.udpIdleTimeoutSec;
            }
            return this;
        }

        Builder(RouterNat source) {
            this.drainNatIps = source.drainNatIps;
            this.icmpIdleTimeoutSec = source.icmpIdleTimeoutSec;
            this.logConfig = source.logConfig;
            this.minPortsPerVm = source.minPortsPerVm;
            this.name = source.name;
            this.natIpAllocateOption = source.natIpAllocateOption;
            this.natIps = source.natIps;
            this.sourceSubnetworkIpRangesToNat = source.sourceSubnetworkIpRangesToNat;
            this.subnetworks = source.subnetworks;
            this.tcpEstablishedIdleTimeoutSec = source.tcpEstablishedIdleTimeoutSec;
            this.tcpTransitoryIdleTimeoutSec = source.tcpTransitoryIdleTimeoutSec;
            this.udpIdleTimeoutSec = source.udpIdleTimeoutSec;
        }

        public List<String> getDrainNatIpsList() {
            return this.drainNatIps;
        }

        public Builder addAllDrainNatIps(List<String> drainNatIps) {
            if (this.drainNatIps == null) {
                this.drainNatIps = new LinkedList<String>();
            }
            this.drainNatIps.addAll(drainNatIps);
            return this;
        }

        public Builder addDrainNatIps(String drainNatIps) {
            if (this.drainNatIps == null) {
                this.drainNatIps = new LinkedList<String>();
            }
            this.drainNatIps.add(drainNatIps);
            return this;
        }

        public Integer getIcmpIdleTimeoutSec() {
            return this.icmpIdleTimeoutSec;
        }

        public Builder setIcmpIdleTimeoutSec(Integer icmpIdleTimeoutSec) {
            this.icmpIdleTimeoutSec = icmpIdleTimeoutSec;
            return this;
        }

        public RouterNatLogConfig getLogConfig() {
            return this.logConfig;
        }

        public Builder setLogConfig(RouterNatLogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public Integer getMinPortsPerVm() {
            return this.minPortsPerVm;
        }

        public Builder setMinPortsPerVm(Integer minPortsPerVm) {
            this.minPortsPerVm = minPortsPerVm;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNatIpAllocateOption() {
            return this.natIpAllocateOption;
        }

        public Builder setNatIpAllocateOption(String natIpAllocateOption) {
            this.natIpAllocateOption = natIpAllocateOption;
            return this;
        }

        public List<String> getNatIpsList() {
            return this.natIps;
        }

        public Builder addAllNatIps(List<String> natIps) {
            if (this.natIps == null) {
                this.natIps = new LinkedList<String>();
            }
            this.natIps.addAll(natIps);
            return this;
        }

        public Builder addNatIps(String natIps) {
            if (this.natIps == null) {
                this.natIps = new LinkedList<String>();
            }
            this.natIps.add(natIps);
            return this;
        }

        public String getSourceSubnetworkIpRangesToNat() {
            return this.sourceSubnetworkIpRangesToNat;
        }

        public Builder setSourceSubnetworkIpRangesToNat(String sourceSubnetworkIpRangesToNat) {
            this.sourceSubnetworkIpRangesToNat = sourceSubnetworkIpRangesToNat;
            return this;
        }

        public List<RouterNatSubnetworkToNat> getSubnetworksList() {
            return this.subnetworks;
        }

        public Builder addAllSubnetworks(List<RouterNatSubnetworkToNat> subnetworks) {
            if (this.subnetworks == null) {
                this.subnetworks = new LinkedList<RouterNatSubnetworkToNat>();
            }
            this.subnetworks.addAll(subnetworks);
            return this;
        }

        public Builder addSubnetworks(RouterNatSubnetworkToNat subnetworks) {
            if (this.subnetworks == null) {
                this.subnetworks = new LinkedList<RouterNatSubnetworkToNat>();
            }
            this.subnetworks.add(subnetworks);
            return this;
        }

        public Integer getTcpEstablishedIdleTimeoutSec() {
            return this.tcpEstablishedIdleTimeoutSec;
        }

        public Builder setTcpEstablishedIdleTimeoutSec(Integer tcpEstablishedIdleTimeoutSec) {
            this.tcpEstablishedIdleTimeoutSec = tcpEstablishedIdleTimeoutSec;
            return this;
        }

        public Integer getTcpTransitoryIdleTimeoutSec() {
            return this.tcpTransitoryIdleTimeoutSec;
        }

        public Builder setTcpTransitoryIdleTimeoutSec(Integer tcpTransitoryIdleTimeoutSec) {
            this.tcpTransitoryIdleTimeoutSec = tcpTransitoryIdleTimeoutSec;
            return this;
        }

        public Integer getUdpIdleTimeoutSec() {
            return this.udpIdleTimeoutSec;
        }

        public Builder setUdpIdleTimeoutSec(Integer udpIdleTimeoutSec) {
            this.udpIdleTimeoutSec = udpIdleTimeoutSec;
            return this;
        }

        public RouterNat build() {
            return new RouterNat(this.drainNatIps, this.icmpIdleTimeoutSec, this.logConfig, this.minPortsPerVm, this.name, this.natIpAllocateOption, this.natIps, this.sourceSubnetworkIpRangesToNat, this.subnetworks, this.tcpEstablishedIdleTimeoutSec, this.tcpTransitoryIdleTimeoutSec, this.udpIdleTimeoutSec);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllDrainNatIps(this.drainNatIps);
            newBuilder.setIcmpIdleTimeoutSec(this.icmpIdleTimeoutSec);
            newBuilder.setLogConfig(this.logConfig);
            newBuilder.setMinPortsPerVm(this.minPortsPerVm);
            newBuilder.setName(this.name);
            newBuilder.setNatIpAllocateOption(this.natIpAllocateOption);
            newBuilder.addAllNatIps(this.natIps);
            newBuilder.setSourceSubnetworkIpRangesToNat(this.sourceSubnetworkIpRangesToNat);
            newBuilder.addAllSubnetworks(this.subnetworks);
            newBuilder.setTcpEstablishedIdleTimeoutSec(this.tcpEstablishedIdleTimeoutSec);
            newBuilder.setTcpTransitoryIdleTimeoutSec(this.tcpTransitoryIdleTimeoutSec);
            newBuilder.setUdpIdleTimeoutSec(this.udpIdleTimeoutSec);
            return newBuilder;
        }
    }
}

