/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListDiskTypesHttpRequest;
import com.google.cloud.compute.v1.DiskType;
import com.google.cloud.compute.v1.DiskTypeAggregatedList;
import com.google.cloud.compute.v1.DiskTypeClient;
import com.google.cloud.compute.v1.DiskTypeList;
import com.google.cloud.compute.v1.DiskTypesScopedList;
import com.google.cloud.compute.v1.GetDiskTypeHttpRequest;
import com.google.cloud.compute.v1.ListDiskTypesHttpRequest;
import com.google.cloud.compute.v1.stub.DiskTypeStub;
import com.google.cloud.compute.v1.stub.HttpJsonDiskTypeStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DiskTypeStubSettings
extends StubSettings<DiskTypeStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypeClient.AggregatedListDiskTypesPagedResponse> aggregatedListDiskTypesSettings;
    private final UnaryCallSettings<GetDiskTypeHttpRequest, DiskType> getDiskTypeSettings;
    private final PagedCallSettings<ListDiskTypesHttpRequest, DiskTypeList, DiskTypeClient.ListDiskTypesPagedResponse> listDiskTypesSettings;
    private static final PagedListDescriptor<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypesScopedList> AGGREGATED_LIST_DISK_TYPES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListDiskTypesHttpRequest injectToken(AggregatedListDiskTypesHttpRequest payload, String token) {
            return AggregatedListDiskTypesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListDiskTypesHttpRequest injectPageSize(AggregatedListDiskTypesHttpRequest payload, int pageSize) {
            return AggregatedListDiskTypesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListDiskTypesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskTypeAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DiskTypesScopedList> extractResources(DiskTypeAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListDiskTypesHttpRequest, DiskTypeList, DiskType> LIST_DISK_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListDiskTypesHttpRequest, DiskTypeList, DiskType>(){

        public String emptyToken() {
            return "";
        }

        public ListDiskTypesHttpRequest injectToken(ListDiskTypesHttpRequest payload, String token) {
            return ListDiskTypesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListDiskTypesHttpRequest injectPageSize(ListDiskTypesHttpRequest payload, int pageSize) {
            return ListDiskTypesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListDiskTypesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskTypeList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DiskType> extractResources(DiskTypeList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypeClient.AggregatedListDiskTypesPagedResponse> AGGREGATED_LIST_DISK_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypeClient.AggregatedListDiskTypesPagedResponse>(){

        public ApiFuture<DiskTypeClient.AggregatedListDiskTypesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList> callable, AggregatedListDiskTypesHttpRequest request, ApiCallContext context, ApiFuture<DiskTypeAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_DISK_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DiskTypeClient.AggregatedListDiskTypesPagedResponse.createAsync((PageContext<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDiskTypesHttpRequest, DiskTypeList, DiskTypeClient.ListDiskTypesPagedResponse> LIST_DISK_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListDiskTypesHttpRequest, DiskTypeList, DiskTypeClient.ListDiskTypesPagedResponse>(){

        public ApiFuture<DiskTypeClient.ListDiskTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDiskTypesHttpRequest, DiskTypeList> callable, ListDiskTypesHttpRequest request, ApiCallContext context, ApiFuture<DiskTypeList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DISK_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DiskTypeClient.ListDiskTypesPagedResponse.createAsync((PageContext<ListDiskTypesHttpRequest, DiskTypeList, DiskType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypeClient.AggregatedListDiskTypesPagedResponse> aggregatedListDiskTypesSettings() {
        return this.aggregatedListDiskTypesSettings;
    }

    public UnaryCallSettings<GetDiskTypeHttpRequest, DiskType> getDiskTypeSettings() {
        return this.getDiskTypeSettings;
    }

    public PagedCallSettings<ListDiskTypesHttpRequest, DiskTypeList, DiskTypeClient.ListDiskTypesPagedResponse> listDiskTypesSettings() {
        return this.listDiskTypesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DiskTypeStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDiskTypeStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DiskTypeStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DiskTypeStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DiskTypeStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListDiskTypesSettings = settingsBuilder.aggregatedListDiskTypesSettings().build();
        this.getDiskTypeSettings = settingsBuilder.getDiskTypeSettings().build();
        this.listDiskTypesSettings = settingsBuilder.listDiskTypesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DiskTypeStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypeClient.AggregatedListDiskTypesPagedResponse> aggregatedListDiskTypesSettings;
        private final UnaryCallSettings.Builder<GetDiskTypeHttpRequest, DiskType> getDiskTypeSettings;
        private final PagedCallSettings.Builder<ListDiskTypesHttpRequest, DiskTypeList, DiskTypeClient.ListDiskTypesPagedResponse> listDiskTypesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListDiskTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_DISK_TYPES_PAGE_STR_FACT);
            this.getDiskTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDiskTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DISK_TYPES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListDiskTypesSettings, this.getDiskTypeSettings, this.listDiskTypesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DiskTypeStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DiskTypeStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DiskTypeStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DiskTypeStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListDiskTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getDiskTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listDiskTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(DiskTypeStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListDiskTypesSettings = settings.aggregatedListDiskTypesSettings.toBuilder();
            this.getDiskTypeSettings = settings.getDiskTypeSettings.toBuilder();
            this.listDiskTypesSettings = settings.listDiskTypesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListDiskTypesSettings, this.getDiskTypeSettings, this.listDiskTypesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListDiskTypesHttpRequest, DiskTypeAggregatedList, DiskTypeClient.AggregatedListDiskTypesPagedResponse> aggregatedListDiskTypesSettings() {
            return this.aggregatedListDiskTypesSettings;
        }

        public UnaryCallSettings.Builder<GetDiskTypeHttpRequest, DiskType> getDiskTypeSettings() {
            return this.getDiskTypeSettings;
        }

        public PagedCallSettings.Builder<ListDiskTypesHttpRequest, DiskTypeList, DiskTypeClient.ListDiskTypesPagedResponse> listDiskTypesSettings() {
            return this.listDiskTypesSettings;
        }

        public DiskTypeStubSettings build() throws IOException {
            return new DiskTypeStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

