/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionHealthCheckServiceHttpRequest;
import com.google.cloud.compute.v1.GetRegionHealthCheckServiceHttpRequest;
import com.google.cloud.compute.v1.HealthCheckService;
import com.google.cloud.compute.v1.HealthCheckServicesList;
import com.google.cloud.compute.v1.InsertRegionHealthCheckServiceHttpRequest;
import com.google.cloud.compute.v1.ListRegionHealthCheckServicesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionHealthCheckServiceHttpRequest;
import com.google.cloud.compute.v1.ProjectRegionHealthCheckServiceName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.RegionHealthCheckServiceSettings;
import com.google.cloud.compute.v1.stub.RegionHealthCheckServiceStub;
import com.google.cloud.compute.v1.stub.RegionHealthCheckServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionHealthCheckServiceClient
implements BackgroundResource {
    private final RegionHealthCheckServiceSettings settings;
    private final RegionHealthCheckServiceStub stub;

    public static final RegionHealthCheckServiceClient create() throws IOException {
        return RegionHealthCheckServiceClient.create(RegionHealthCheckServiceSettings.newBuilder().build());
    }

    public static final RegionHealthCheckServiceClient create(RegionHealthCheckServiceSettings settings) throws IOException {
        return new RegionHealthCheckServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionHealthCheckServiceClient create(RegionHealthCheckServiceStub stub) {
        return new RegionHealthCheckServiceClient(stub);
    }

    protected RegionHealthCheckServiceClient(RegionHealthCheckServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionHealthCheckServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionHealthCheckServiceClient(RegionHealthCheckServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionHealthCheckServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionHealthCheckServiceStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRegionHealthCheckService(ProjectRegionHealthCheckServiceName healthCheckService) {
        DeleteRegionHealthCheckServiceHttpRequest request = DeleteRegionHealthCheckServiceHttpRequest.newBuilder().setHealthCheckService(healthCheckService == null ? null : healthCheckService.toString()).build();
        return this.deleteRegionHealthCheckService(request);
    }

    @BetaApi
    public final Operation deleteRegionHealthCheckService(String healthCheckService) {
        DeleteRegionHealthCheckServiceHttpRequest request = DeleteRegionHealthCheckServiceHttpRequest.newBuilder().setHealthCheckService(healthCheckService).build();
        return this.deleteRegionHealthCheckService(request);
    }

    @BetaApi
    public final Operation deleteRegionHealthCheckService(DeleteRegionHealthCheckServiceHttpRequest request) {
        return (Operation)this.deleteRegionHealthCheckServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionHealthCheckServiceHttpRequest, Operation> deleteRegionHealthCheckServiceCallable() {
        return this.stub.deleteRegionHealthCheckServiceCallable();
    }

    @BetaApi
    public final HealthCheckService getRegionHealthCheckService(ProjectRegionHealthCheckServiceName healthCheckService) {
        GetRegionHealthCheckServiceHttpRequest request = GetRegionHealthCheckServiceHttpRequest.newBuilder().setHealthCheckService(healthCheckService == null ? null : healthCheckService.toString()).build();
        return this.getRegionHealthCheckService(request);
    }

    @BetaApi
    public final HealthCheckService getRegionHealthCheckService(String healthCheckService) {
        GetRegionHealthCheckServiceHttpRequest request = GetRegionHealthCheckServiceHttpRequest.newBuilder().setHealthCheckService(healthCheckService).build();
        return this.getRegionHealthCheckService(request);
    }

    @BetaApi
    public final HealthCheckService getRegionHealthCheckService(GetRegionHealthCheckServiceHttpRequest request) {
        return (HealthCheckService)this.getRegionHealthCheckServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionHealthCheckServiceHttpRequest, HealthCheckService> getRegionHealthCheckServiceCallable() {
        return this.stub.getRegionHealthCheckServiceCallable();
    }

    @BetaApi
    public final Operation insertRegionHealthCheckService(ProjectRegionName region, HealthCheckService healthCheckServiceResource) {
        InsertRegionHealthCheckServiceHttpRequest request = InsertRegionHealthCheckServiceHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setHealthCheckServiceResource(healthCheckServiceResource).build();
        return this.insertRegionHealthCheckService(request);
    }

    @BetaApi
    public final Operation insertRegionHealthCheckService(String region, HealthCheckService healthCheckServiceResource) {
        InsertRegionHealthCheckServiceHttpRequest request = InsertRegionHealthCheckServiceHttpRequest.newBuilder().setRegion(region).setHealthCheckServiceResource(healthCheckServiceResource).build();
        return this.insertRegionHealthCheckService(request);
    }

    @BetaApi
    public final Operation insertRegionHealthCheckService(InsertRegionHealthCheckServiceHttpRequest request) {
        return (Operation)this.insertRegionHealthCheckServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionHealthCheckServiceHttpRequest, Operation> insertRegionHealthCheckServiceCallable() {
        return this.stub.insertRegionHealthCheckServiceCallable();
    }

    @BetaApi
    public final ListRegionHealthCheckServicesPagedResponse listRegionHealthCheckServices(ProjectRegionName region) {
        ListRegionHealthCheckServicesHttpRequest request = ListRegionHealthCheckServicesHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionHealthCheckServices(request);
    }

    @BetaApi
    public final ListRegionHealthCheckServicesPagedResponse listRegionHealthCheckServices(String region) {
        ListRegionHealthCheckServicesHttpRequest request = ListRegionHealthCheckServicesHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionHealthCheckServices(request);
    }

    @BetaApi
    public final ListRegionHealthCheckServicesPagedResponse listRegionHealthCheckServices(ListRegionHealthCheckServicesHttpRequest request) {
        return (ListRegionHealthCheckServicesPagedResponse)((Object)this.listRegionHealthCheckServicesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionHealthCheckServicesHttpRequest, ListRegionHealthCheckServicesPagedResponse> listRegionHealthCheckServicesPagedCallable() {
        return this.stub.listRegionHealthCheckServicesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList> listRegionHealthCheckServicesCallable() {
        return this.stub.listRegionHealthCheckServicesCallable();
    }

    @BetaApi
    public final Operation patchRegionHealthCheckService(ProjectRegionHealthCheckServiceName healthCheckService, HealthCheckService healthCheckServiceResource, List<String> fieldMask) {
        PatchRegionHealthCheckServiceHttpRequest request = PatchRegionHealthCheckServiceHttpRequest.newBuilder().setHealthCheckService(healthCheckService == null ? null : healthCheckService.toString()).setHealthCheckServiceResource(healthCheckServiceResource).addAllFieldMask(fieldMask).build();
        return this.patchRegionHealthCheckService(request);
    }

    @BetaApi
    public final Operation patchRegionHealthCheckService(String healthCheckService, HealthCheckService healthCheckServiceResource, List<String> fieldMask) {
        PatchRegionHealthCheckServiceHttpRequest request = PatchRegionHealthCheckServiceHttpRequest.newBuilder().setHealthCheckService(healthCheckService).setHealthCheckServiceResource(healthCheckServiceResource).addAllFieldMask(fieldMask).build();
        return this.patchRegionHealthCheckService(request);
    }

    @BetaApi
    public final Operation patchRegionHealthCheckService(PatchRegionHealthCheckServiceHttpRequest request) {
        return (Operation)this.patchRegionHealthCheckServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchRegionHealthCheckServiceHttpRequest, Operation> patchRegionHealthCheckServiceCallable() {
        return this.stub.patchRegionHealthCheckServiceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionHealthCheckServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, HealthCheckService, ListRegionHealthCheckServicesPage, ListRegionHealthCheckServicesFixedSizeCollection> {
        private ListRegionHealthCheckServicesFixedSizeCollection(List<ListRegionHealthCheckServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionHealthCheckServicesFixedSizeCollection createEmptyCollection() {
            return new ListRegionHealthCheckServicesFixedSizeCollection(null, 0);
        }

        protected ListRegionHealthCheckServicesFixedSizeCollection createCollection(List<ListRegionHealthCheckServicesPage> pages, int collectionSize) {
            return new ListRegionHealthCheckServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionHealthCheckServicesPage
    extends AbstractPage<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, HealthCheckService, ListRegionHealthCheckServicesPage> {
        private ListRegionHealthCheckServicesPage(PageContext<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, HealthCheckService> context, HealthCheckServicesList response) {
            super(context, (Object)response);
        }

        private static ListRegionHealthCheckServicesPage createEmptyPage() {
            return new ListRegionHealthCheckServicesPage(null, null);
        }

        protected ListRegionHealthCheckServicesPage createPage(PageContext<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, HealthCheckService> context, HealthCheckServicesList response) {
            return new ListRegionHealthCheckServicesPage(context, response);
        }

        public ApiFuture<ListRegionHealthCheckServicesPage> createPageAsync(PageContext<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, HealthCheckService> context, ApiFuture<HealthCheckServicesList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionHealthCheckServicesPagedResponse
    extends AbstractPagedListResponse<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, HealthCheckService, ListRegionHealthCheckServicesPage, ListRegionHealthCheckServicesFixedSizeCollection> {
        public static ApiFuture<ListRegionHealthCheckServicesPagedResponse> createAsync(PageContext<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, HealthCheckService> context, ApiFuture<HealthCheckServicesList> futureResponse) {
            ApiFuture<ListRegionHealthCheckServicesPage> futurePage = ListRegionHealthCheckServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionHealthCheckServicesPage, ListRegionHealthCheckServicesPagedResponse>(){

                public ListRegionHealthCheckServicesPagedResponse apply(ListRegionHealthCheckServicesPage input) {
                    return new ListRegionHealthCheckServicesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionHealthCheckServicesPagedResponse(ListRegionHealthCheckServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionHealthCheckServicesFixedSizeCollection.createEmptyCollection());
        }
    }
}

