/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NetworkEndpointGroupCloudRun
implements ApiMessage {
    private final String service;
    private final String tag;
    private final String urlMask;
    private static final NetworkEndpointGroupCloudRun DEFAULT_INSTANCE = new NetworkEndpointGroupCloudRun();

    private NetworkEndpointGroupCloudRun() {
        this.service = null;
        this.tag = null;
        this.urlMask = null;
    }

    private NetworkEndpointGroupCloudRun(String service, String tag, String urlMask) {
        this.service = service;
        this.tag = tag;
        this.urlMask = urlMask;
    }

    public Object getFieldValue(String fieldName) {
        if ("service".equals(fieldName)) {
            return this.service;
        }
        if ("tag".equals(fieldName)) {
            return this.tag;
        }
        if ("urlMask".equals(fieldName)) {
            return this.urlMask;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getService() {
        return this.service;
    }

    public String getTag() {
        return this.tag;
    }

    public String getUrlMask() {
        return this.urlMask;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NetworkEndpointGroupCloudRun prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NetworkEndpointGroupCloudRun getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NetworkEndpointGroupCloudRun{service=" + this.service + ", tag=" + this.tag + ", urlMask=" + this.urlMask + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkEndpointGroupCloudRun) {
            NetworkEndpointGroupCloudRun that = (NetworkEndpointGroupCloudRun)o;
            return Objects.equals(this.service, that.getService()) && Objects.equals(this.tag, that.getTag()) && Objects.equals(this.urlMask, that.getUrlMask());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.service, this.tag, this.urlMask);
    }

    public static class Builder {
        private String service;
        private String tag;
        private String urlMask;

        Builder() {
        }

        public Builder mergeFrom(NetworkEndpointGroupCloudRun other) {
            if (other == NetworkEndpointGroupCloudRun.getDefaultInstance()) {
                return this;
            }
            if (other.getService() != null) {
                this.service = other.service;
            }
            if (other.getTag() != null) {
                this.tag = other.tag;
            }
            if (other.getUrlMask() != null) {
                this.urlMask = other.urlMask;
            }
            return this;
        }

        Builder(NetworkEndpointGroupCloudRun source) {
            this.service = source.service;
            this.tag = source.tag;
            this.urlMask = source.urlMask;
        }

        public String getService() {
            return this.service;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public String getTag() {
            return this.tag;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public String getUrlMask() {
            return this.urlMask;
        }

        public Builder setUrlMask(String urlMask) {
            this.urlMask = urlMask;
            return this;
        }

        public NetworkEndpointGroupCloudRun build() {
            return new NetworkEndpointGroupCloudRun(this.service, this.tag, this.urlMask);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setService(this.service);
            newBuilder.setTag(this.tag);
            newBuilder.setUrlMask(this.urlMask);
            return newBuilder;
        }
    }
}

