/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetGrpcProxyHttpRequest;
import com.google.cloud.compute.v1.GetTargetGrpcProxyHttpRequest;
import com.google.cloud.compute.v1.InsertTargetGrpcProxyHttpRequest;
import com.google.cloud.compute.v1.ListTargetGrpcProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchTargetGrpcProxyHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalTargetGrpcProxyName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.TargetGrpcProxy;
import com.google.cloud.compute.v1.TargetGrpcProxyList;
import com.google.cloud.compute.v1.TargetGrpcProxySettings;
import com.google.cloud.compute.v1.stub.TargetGrpcProxyStub;
import com.google.cloud.compute.v1.stub.TargetGrpcProxyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TargetGrpcProxyClient
implements BackgroundResource {
    private final TargetGrpcProxySettings settings;
    private final TargetGrpcProxyStub stub;

    public static final TargetGrpcProxyClient create() throws IOException {
        return TargetGrpcProxyClient.create(TargetGrpcProxySettings.newBuilder().build());
    }

    public static final TargetGrpcProxyClient create(TargetGrpcProxySettings settings) throws IOException {
        return new TargetGrpcProxyClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetGrpcProxyClient create(TargetGrpcProxyStub stub) {
        return new TargetGrpcProxyClient(stub);
    }

    protected TargetGrpcProxyClient(TargetGrpcProxySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetGrpcProxyStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetGrpcProxyClient(TargetGrpcProxyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetGrpcProxySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetGrpcProxyStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteTargetGrpcProxy(ProjectGlobalTargetGrpcProxyName targetGrpcProxy) {
        DeleteTargetGrpcProxyHttpRequest request = DeleteTargetGrpcProxyHttpRequest.newBuilder().setTargetGrpcProxy(targetGrpcProxy == null ? null : targetGrpcProxy.toString()).build();
        return this.deleteTargetGrpcProxy(request);
    }

    @BetaApi
    public final Operation deleteTargetGrpcProxy(String targetGrpcProxy) {
        DeleteTargetGrpcProxyHttpRequest request = DeleteTargetGrpcProxyHttpRequest.newBuilder().setTargetGrpcProxy(targetGrpcProxy).build();
        return this.deleteTargetGrpcProxy(request);
    }

    @BetaApi
    public final Operation deleteTargetGrpcProxy(DeleteTargetGrpcProxyHttpRequest request) {
        return (Operation)this.deleteTargetGrpcProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteTargetGrpcProxyHttpRequest, Operation> deleteTargetGrpcProxyCallable() {
        return this.stub.deleteTargetGrpcProxyCallable();
    }

    @BetaApi
    public final TargetGrpcProxy getTargetGrpcProxy(ProjectGlobalTargetGrpcProxyName targetGrpcProxy) {
        GetTargetGrpcProxyHttpRequest request = GetTargetGrpcProxyHttpRequest.newBuilder().setTargetGrpcProxy(targetGrpcProxy == null ? null : targetGrpcProxy.toString()).build();
        return this.getTargetGrpcProxy(request);
    }

    @BetaApi
    public final TargetGrpcProxy getTargetGrpcProxy(String targetGrpcProxy) {
        GetTargetGrpcProxyHttpRequest request = GetTargetGrpcProxyHttpRequest.newBuilder().setTargetGrpcProxy(targetGrpcProxy).build();
        return this.getTargetGrpcProxy(request);
    }

    @BetaApi
    public final TargetGrpcProxy getTargetGrpcProxy(GetTargetGrpcProxyHttpRequest request) {
        return (TargetGrpcProxy)this.getTargetGrpcProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetTargetGrpcProxyHttpRequest, TargetGrpcProxy> getTargetGrpcProxyCallable() {
        return this.stub.getTargetGrpcProxyCallable();
    }

    @BetaApi
    public final Operation insertTargetGrpcProxy(ProjectName project, TargetGrpcProxy targetGrpcProxyResource) {
        InsertTargetGrpcProxyHttpRequest request = InsertTargetGrpcProxyHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setTargetGrpcProxyResource(targetGrpcProxyResource).build();
        return this.insertTargetGrpcProxy(request);
    }

    @BetaApi
    public final Operation insertTargetGrpcProxy(String project, TargetGrpcProxy targetGrpcProxyResource) {
        InsertTargetGrpcProxyHttpRequest request = InsertTargetGrpcProxyHttpRequest.newBuilder().setProject(project).setTargetGrpcProxyResource(targetGrpcProxyResource).build();
        return this.insertTargetGrpcProxy(request);
    }

    @BetaApi
    public final Operation insertTargetGrpcProxy(InsertTargetGrpcProxyHttpRequest request) {
        return (Operation)this.insertTargetGrpcProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertTargetGrpcProxyHttpRequest, Operation> insertTargetGrpcProxyCallable() {
        return this.stub.insertTargetGrpcProxyCallable();
    }

    @BetaApi
    public final ListTargetGrpcProxiesPagedResponse listTargetGrpcProxies(ProjectName project) {
        ListTargetGrpcProxiesHttpRequest request = ListTargetGrpcProxiesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listTargetGrpcProxies(request);
    }

    @BetaApi
    public final ListTargetGrpcProxiesPagedResponse listTargetGrpcProxies(String project) {
        ListTargetGrpcProxiesHttpRequest request = ListTargetGrpcProxiesHttpRequest.newBuilder().setProject(project).build();
        return this.listTargetGrpcProxies(request);
    }

    @BetaApi
    public final ListTargetGrpcProxiesPagedResponse listTargetGrpcProxies(ListTargetGrpcProxiesHttpRequest request) {
        return (ListTargetGrpcProxiesPagedResponse)((Object)this.listTargetGrpcProxiesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListTargetGrpcProxiesHttpRequest, ListTargetGrpcProxiesPagedResponse> listTargetGrpcProxiesPagedCallable() {
        return this.stub.listTargetGrpcProxiesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList> listTargetGrpcProxiesCallable() {
        return this.stub.listTargetGrpcProxiesCallable();
    }

    @BetaApi
    public final Operation patchTargetGrpcProxy(ProjectGlobalTargetGrpcProxyName targetGrpcProxy, TargetGrpcProxy targetGrpcProxyResource, List<String> fieldMask) {
        PatchTargetGrpcProxyHttpRequest request = PatchTargetGrpcProxyHttpRequest.newBuilder().setTargetGrpcProxy(targetGrpcProxy == null ? null : targetGrpcProxy.toString()).setTargetGrpcProxyResource(targetGrpcProxyResource).addAllFieldMask(fieldMask).build();
        return this.patchTargetGrpcProxy(request);
    }

    @BetaApi
    public final Operation patchTargetGrpcProxy(String targetGrpcProxy, TargetGrpcProxy targetGrpcProxyResource, List<String> fieldMask) {
        PatchTargetGrpcProxyHttpRequest request = PatchTargetGrpcProxyHttpRequest.newBuilder().setTargetGrpcProxy(targetGrpcProxy).setTargetGrpcProxyResource(targetGrpcProxyResource).addAllFieldMask(fieldMask).build();
        return this.patchTargetGrpcProxy(request);
    }

    @BetaApi
    public final Operation patchTargetGrpcProxy(PatchTargetGrpcProxyHttpRequest request) {
        return (Operation)this.patchTargetGrpcProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchTargetGrpcProxyHttpRequest, Operation> patchTargetGrpcProxyCallable() {
        return this.stub.patchTargetGrpcProxyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTargetGrpcProxiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxy, ListTargetGrpcProxiesPage, ListTargetGrpcProxiesFixedSizeCollection> {
        private ListTargetGrpcProxiesFixedSizeCollection(List<ListTargetGrpcProxiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetGrpcProxiesFixedSizeCollection createEmptyCollection() {
            return new ListTargetGrpcProxiesFixedSizeCollection(null, 0);
        }

        protected ListTargetGrpcProxiesFixedSizeCollection createCollection(List<ListTargetGrpcProxiesPage> pages, int collectionSize) {
            return new ListTargetGrpcProxiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetGrpcProxiesPage
    extends AbstractPage<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxy, ListTargetGrpcProxiesPage> {
        private ListTargetGrpcProxiesPage(PageContext<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxy> context, TargetGrpcProxyList response) {
            super(context, (Object)response);
        }

        private static ListTargetGrpcProxiesPage createEmptyPage() {
            return new ListTargetGrpcProxiesPage(null, null);
        }

        protected ListTargetGrpcProxiesPage createPage(PageContext<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxy> context, TargetGrpcProxyList response) {
            return new ListTargetGrpcProxiesPage(context, response);
        }

        public ApiFuture<ListTargetGrpcProxiesPage> createPageAsync(PageContext<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxy> context, ApiFuture<TargetGrpcProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetGrpcProxiesPagedResponse
    extends AbstractPagedListResponse<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxy, ListTargetGrpcProxiesPage, ListTargetGrpcProxiesFixedSizeCollection> {
        public static ApiFuture<ListTargetGrpcProxiesPagedResponse> createAsync(PageContext<ListTargetGrpcProxiesHttpRequest, TargetGrpcProxyList, TargetGrpcProxy> context, ApiFuture<TargetGrpcProxyList> futureResponse) {
            ApiFuture<ListTargetGrpcProxiesPage> futurePage = ListTargetGrpcProxiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTargetGrpcProxiesPage, ListTargetGrpcProxiesPagedResponse>(){

                public ListTargetGrpcProxiesPagedResponse apply(ListTargetGrpcProxiesPage input) {
                    return new ListTargetGrpcProxiesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTargetGrpcProxiesPagedResponse(ListTargetGrpcProxiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetGrpcProxiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

