/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.PreservedState;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PerInstanceConfig
implements ApiMessage {
    private final String fingerprint;
    private final String name;
    private final PreservedState preservedState;
    private final String status;
    private static final PerInstanceConfig DEFAULT_INSTANCE = new PerInstanceConfig();

    private PerInstanceConfig() {
        this.fingerprint = null;
        this.name = null;
        this.preservedState = null;
        this.status = null;
    }

    private PerInstanceConfig(String fingerprint, String name, PreservedState preservedState, String status) {
        this.fingerprint = fingerprint;
        this.name = name;
        this.preservedState = preservedState;
        this.status = status;
    }

    public Object getFieldValue(String fieldName) {
        if ("fingerprint".equals(fieldName)) {
            return this.fingerprint;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("preservedState".equals(fieldName)) {
            return this.preservedState;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getName() {
        return this.name;
    }

    public PreservedState getPreservedState() {
        return this.preservedState;
    }

    public String getStatus() {
        return this.status;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PerInstanceConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PerInstanceConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PerInstanceConfig{fingerprint=" + this.fingerprint + ", name=" + this.name + ", preservedState=" + this.preservedState + ", status=" + this.status + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PerInstanceConfig) {
            PerInstanceConfig that = (PerInstanceConfig)o;
            return Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.preservedState, that.getPreservedState()) && Objects.equals(this.status, that.getStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.fingerprint, this.name, this.preservedState, this.status);
    }

    public static class Builder {
        private String fingerprint;
        private String name;
        private PreservedState preservedState;
        private String status;

        Builder() {
        }

        public Builder mergeFrom(PerInstanceConfig other) {
            if (other == PerInstanceConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getPreservedState() != null) {
                this.preservedState = other.preservedState;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            return this;
        }

        Builder(PerInstanceConfig source) {
            this.fingerprint = source.fingerprint;
            this.name = source.name;
            this.preservedState = source.preservedState;
            this.status = source.status;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public PreservedState getPreservedState() {
            return this.preservedState;
        }

        public Builder setPreservedState(PreservedState preservedState) {
            this.preservedState = preservedState;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public PerInstanceConfig build() {
            return new PerInstanceConfig(this.fingerprint, this.name, this.preservedState, this.status);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.setName(this.name);
            newBuilder.setPreservedState(this.preservedState);
            newBuilder.setStatus(this.status);
            return newBuilder;
        }
    }
}

