/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagersApplyUpdatesRequest
implements ApiMessage {
    private final List<String> instances;
    private final String minimalAction;
    private final String mostDisruptiveAllowedAction;
    private static final InstanceGroupManagersApplyUpdatesRequest DEFAULT_INSTANCE = new InstanceGroupManagersApplyUpdatesRequest();

    private InstanceGroupManagersApplyUpdatesRequest() {
        this.instances = null;
        this.minimalAction = null;
        this.mostDisruptiveAllowedAction = null;
    }

    private InstanceGroupManagersApplyUpdatesRequest(List<String> instances, String minimalAction, String mostDisruptiveAllowedAction) {
        this.instances = instances;
        this.minimalAction = minimalAction;
        this.mostDisruptiveAllowedAction = mostDisruptiveAllowedAction;
    }

    public Object getFieldValue(String fieldName) {
        if ("instances".equals(fieldName)) {
            return this.instances;
        }
        if ("minimalAction".equals(fieldName)) {
            return this.minimalAction;
        }
        if ("mostDisruptiveAllowedAction".equals(fieldName)) {
            return this.mostDisruptiveAllowedAction;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getInstancesList() {
        return this.instances;
    }

    public String getMinimalAction() {
        return this.minimalAction;
    }

    public String getMostDisruptiveAllowedAction() {
        return this.mostDisruptiveAllowedAction;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagersApplyUpdatesRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagersApplyUpdatesRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagersApplyUpdatesRequest{instances=" + this.instances + ", minimalAction=" + this.minimalAction + ", mostDisruptiveAllowedAction=" + this.mostDisruptiveAllowedAction + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagersApplyUpdatesRequest) {
            InstanceGroupManagersApplyUpdatesRequest that = (InstanceGroupManagersApplyUpdatesRequest)o;
            return Objects.equals(this.instances, that.getInstancesList()) && Objects.equals(this.minimalAction, that.getMinimalAction()) && Objects.equals(this.mostDisruptiveAllowedAction, that.getMostDisruptiveAllowedAction());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instances, this.minimalAction, this.mostDisruptiveAllowedAction);
    }

    public static class Builder {
        private List<String> instances;
        private String minimalAction;
        private String mostDisruptiveAllowedAction;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagersApplyUpdatesRequest other) {
            if (other == InstanceGroupManagersApplyUpdatesRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getInstancesList() != null) {
                this.instances = other.instances;
            }
            if (other.getMinimalAction() != null) {
                this.minimalAction = other.minimalAction;
            }
            if (other.getMostDisruptiveAllowedAction() != null) {
                this.mostDisruptiveAllowedAction = other.mostDisruptiveAllowedAction;
            }
            return this;
        }

        Builder(InstanceGroupManagersApplyUpdatesRequest source) {
            this.instances = source.instances;
            this.minimalAction = source.minimalAction;
            this.mostDisruptiveAllowedAction = source.mostDisruptiveAllowedAction;
        }

        public List<String> getInstancesList() {
            return this.instances;
        }

        public Builder addAllInstances(List<String> instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<String>();
            }
            this.instances.addAll(instances);
            return this;
        }

        public Builder addInstances(String instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<String>();
            }
            this.instances.add(instances);
            return this;
        }

        public String getMinimalAction() {
            return this.minimalAction;
        }

        public Builder setMinimalAction(String minimalAction) {
            this.minimalAction = minimalAction;
            return this;
        }

        public String getMostDisruptiveAllowedAction() {
            return this.mostDisruptiveAllowedAction;
        }

        public Builder setMostDisruptiveAllowedAction(String mostDisruptiveAllowedAction) {
            this.mostDisruptiveAllowedAction = mostDisruptiveAllowedAction;
            return this;
        }

        public InstanceGroupManagersApplyUpdatesRequest build() {
            return new InstanceGroupManagersApplyUpdatesRequest(this.instances, this.minimalAction, this.mostDisruptiveAllowedAction);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllInstances(this.instances);
            newBuilder.setMinimalAction(this.minimalAction);
            newBuilder.setMostDisruptiveAllowedAction(this.mostDisruptiveAllowedAction);
            return newBuilder;
        }
    }
}

