/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class CorsPolicy
implements ApiMessage {
    private final Boolean allowCredentials;
    private final List<String> allowHeaders;
    private final List<String> allowMethods;
    private final List<String> allowOriginRegexes;
    private final List<String> allowOrigins;
    private final Boolean disabled;
    private final List<String> exposeHeaders;
    private final Integer maxAge;
    private static final CorsPolicy DEFAULT_INSTANCE = new CorsPolicy();

    private CorsPolicy() {
        this.allowCredentials = null;
        this.allowHeaders = null;
        this.allowMethods = null;
        this.allowOriginRegexes = null;
        this.allowOrigins = null;
        this.disabled = null;
        this.exposeHeaders = null;
        this.maxAge = null;
    }

    private CorsPolicy(Boolean allowCredentials, List<String> allowHeaders, List<String> allowMethods, List<String> allowOriginRegexes, List<String> allowOrigins, Boolean disabled, List<String> exposeHeaders, Integer maxAge) {
        this.allowCredentials = allowCredentials;
        this.allowHeaders = allowHeaders;
        this.allowMethods = allowMethods;
        this.allowOriginRegexes = allowOriginRegexes;
        this.allowOrigins = allowOrigins;
        this.disabled = disabled;
        this.exposeHeaders = exposeHeaders;
        this.maxAge = maxAge;
    }

    public Object getFieldValue(String fieldName) {
        if ("allowCredentials".equals(fieldName)) {
            return this.allowCredentials;
        }
        if ("allowHeaders".equals(fieldName)) {
            return this.allowHeaders;
        }
        if ("allowMethods".equals(fieldName)) {
            return this.allowMethods;
        }
        if ("allowOriginRegexes".equals(fieldName)) {
            return this.allowOriginRegexes;
        }
        if ("allowOrigins".equals(fieldName)) {
            return this.allowOrigins;
        }
        if ("disabled".equals(fieldName)) {
            return this.disabled;
        }
        if ("exposeHeaders".equals(fieldName)) {
            return this.exposeHeaders;
        }
        if ("maxAge".equals(fieldName)) {
            return this.maxAge;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public List<String> getAllowHeadersList() {
        return this.allowHeaders;
    }

    public List<String> getAllowMethodsList() {
        return this.allowMethods;
    }

    public List<String> getAllowOriginRegexesList() {
        return this.allowOriginRegexes;
    }

    public List<String> getAllowOriginsList() {
        return this.allowOrigins;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public List<String> getExposeHeadersList() {
        return this.exposeHeaders;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CorsPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static CorsPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "CorsPolicy{allowCredentials=" + this.allowCredentials + ", allowHeaders=" + this.allowHeaders + ", allowMethods=" + this.allowMethods + ", allowOriginRegexes=" + this.allowOriginRegexes + ", allowOrigins=" + this.allowOrigins + ", disabled=" + this.disabled + ", exposeHeaders=" + this.exposeHeaders + ", maxAge=" + this.maxAge + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CorsPolicy) {
            CorsPolicy that = (CorsPolicy)o;
            return Objects.equals(this.allowCredentials, that.getAllowCredentials()) && Objects.equals(this.allowHeaders, that.getAllowHeadersList()) && Objects.equals(this.allowMethods, that.getAllowMethodsList()) && Objects.equals(this.allowOriginRegexes, that.getAllowOriginRegexesList()) && Objects.equals(this.allowOrigins, that.getAllowOriginsList()) && Objects.equals(this.disabled, that.getDisabled()) && Objects.equals(this.exposeHeaders, that.getExposeHeadersList()) && Objects.equals(this.maxAge, that.getMaxAge());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.allowCredentials, this.allowHeaders, this.allowMethods, this.allowOriginRegexes, this.allowOrigins, this.disabled, this.exposeHeaders, this.maxAge);
    }

    public static class Builder {
        private Boolean allowCredentials;
        private List<String> allowHeaders;
        private List<String> allowMethods;
        private List<String> allowOriginRegexes;
        private List<String> allowOrigins;
        private Boolean disabled;
        private List<String> exposeHeaders;
        private Integer maxAge;

        Builder() {
        }

        public Builder mergeFrom(CorsPolicy other) {
            if (other == CorsPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getAllowCredentials() != null) {
                this.allowCredentials = other.allowCredentials;
            }
            if (other.getAllowHeadersList() != null) {
                this.allowHeaders = other.allowHeaders;
            }
            if (other.getAllowMethodsList() != null) {
                this.allowMethods = other.allowMethods;
            }
            if (other.getAllowOriginRegexesList() != null) {
                this.allowOriginRegexes = other.allowOriginRegexes;
            }
            if (other.getAllowOriginsList() != null) {
                this.allowOrigins = other.allowOrigins;
            }
            if (other.getDisabled() != null) {
                this.disabled = other.disabled;
            }
            if (other.getExposeHeadersList() != null) {
                this.exposeHeaders = other.exposeHeaders;
            }
            if (other.getMaxAge() != null) {
                this.maxAge = other.maxAge;
            }
            return this;
        }

        Builder(CorsPolicy source) {
            this.allowCredentials = source.allowCredentials;
            this.allowHeaders = source.allowHeaders;
            this.allowMethods = source.allowMethods;
            this.allowOriginRegexes = source.allowOriginRegexes;
            this.allowOrigins = source.allowOrigins;
            this.disabled = source.disabled;
            this.exposeHeaders = source.exposeHeaders;
            this.maxAge = source.maxAge;
        }

        public Boolean getAllowCredentials() {
            return this.allowCredentials;
        }

        public Builder setAllowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public List<String> getAllowHeadersList() {
            return this.allowHeaders;
        }

        public Builder addAllAllowHeaders(List<String> allowHeaders) {
            if (this.allowHeaders == null) {
                this.allowHeaders = new LinkedList<String>();
            }
            this.allowHeaders.addAll(allowHeaders);
            return this;
        }

        public Builder addAllowHeaders(String allowHeaders) {
            if (this.allowHeaders == null) {
                this.allowHeaders = new LinkedList<String>();
            }
            this.allowHeaders.add(allowHeaders);
            return this;
        }

        public List<String> getAllowMethodsList() {
            return this.allowMethods;
        }

        public Builder addAllAllowMethods(List<String> allowMethods) {
            if (this.allowMethods == null) {
                this.allowMethods = new LinkedList<String>();
            }
            this.allowMethods.addAll(allowMethods);
            return this;
        }

        public Builder addAllowMethods(String allowMethods) {
            if (this.allowMethods == null) {
                this.allowMethods = new LinkedList<String>();
            }
            this.allowMethods.add(allowMethods);
            return this;
        }

        public List<String> getAllowOriginRegexesList() {
            return this.allowOriginRegexes;
        }

        public Builder addAllAllowOriginRegexes(List<String> allowOriginRegexes) {
            if (this.allowOriginRegexes == null) {
                this.allowOriginRegexes = new LinkedList<String>();
            }
            this.allowOriginRegexes.addAll(allowOriginRegexes);
            return this;
        }

        public Builder addAllowOriginRegexes(String allowOriginRegexes) {
            if (this.allowOriginRegexes == null) {
                this.allowOriginRegexes = new LinkedList<String>();
            }
            this.allowOriginRegexes.add(allowOriginRegexes);
            return this;
        }

        public List<String> getAllowOriginsList() {
            return this.allowOrigins;
        }

        public Builder addAllAllowOrigins(List<String> allowOrigins) {
            if (this.allowOrigins == null) {
                this.allowOrigins = new LinkedList<String>();
            }
            this.allowOrigins.addAll(allowOrigins);
            return this;
        }

        public Builder addAllowOrigins(String allowOrigins) {
            if (this.allowOrigins == null) {
                this.allowOrigins = new LinkedList<String>();
            }
            this.allowOrigins.add(allowOrigins);
            return this;
        }

        public Boolean getDisabled() {
            return this.disabled;
        }

        public Builder setDisabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public List<String> getExposeHeadersList() {
            return this.exposeHeaders;
        }

        public Builder addAllExposeHeaders(List<String> exposeHeaders) {
            if (this.exposeHeaders == null) {
                this.exposeHeaders = new LinkedList<String>();
            }
            this.exposeHeaders.addAll(exposeHeaders);
            return this;
        }

        public Builder addExposeHeaders(String exposeHeaders) {
            if (this.exposeHeaders == null) {
                this.exposeHeaders = new LinkedList<String>();
            }
            this.exposeHeaders.add(exposeHeaders);
            return this;
        }

        public Integer getMaxAge() {
            return this.maxAge;
        }

        public Builder setMaxAge(Integer maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public CorsPolicy build() {
            return new CorsPolicy(this.allowCredentials, this.allowHeaders, this.allowMethods, this.allowOriginRegexes, this.allowOrigins, this.disabled, this.exposeHeaders, this.maxAge);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAllowCredentials(this.allowCredentials);
            newBuilder.addAllAllowHeaders(this.allowHeaders);
            newBuilder.addAllAllowMethods(this.allowMethods);
            newBuilder.addAllAllowOriginRegexes(this.allowOriginRegexes);
            newBuilder.addAllAllowOrigins(this.allowOrigins);
            newBuilder.setDisabled(this.disabled);
            newBuilder.addAllExposeHeaders(this.exposeHeaders);
            newBuilder.setMaxAge(this.maxAge);
            return newBuilder;
        }
    }
}

