/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class CacheInvalidationRule
implements ApiMessage {
    private final String host;
    private final String path;
    private static final CacheInvalidationRule DEFAULT_INSTANCE = new CacheInvalidationRule();

    private CacheInvalidationRule() {
        this.host = null;
        this.path = null;
    }

    private CacheInvalidationRule(String host, String path) {
        this.host = host;
        this.path = path;
    }

    public Object getFieldValue(String fieldName) {
        if ("host".equals(fieldName)) {
            return this.host;
        }
        if ("path".equals(fieldName)) {
            return this.path;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CacheInvalidationRule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static CacheInvalidationRule getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "CacheInvalidationRule{host=" + this.host + ", path=" + this.path + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CacheInvalidationRule) {
            CacheInvalidationRule that = (CacheInvalidationRule)o;
            return Objects.equals(this.host, that.getHost()) && Objects.equals(this.path, that.getPath());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.path);
    }

    public static class Builder {
        private String host;
        private String path;

        Builder() {
        }

        public Builder mergeFrom(CacheInvalidationRule other) {
            if (other == CacheInvalidationRule.getDefaultInstance()) {
                return this;
            }
            if (other.getHost() != null) {
                this.host = other.host;
            }
            if (other.getPath() != null) {
                this.path = other.path;
            }
            return this;
        }

        Builder(CacheInvalidationRule source) {
            this.host = source.host;
            this.path = source.path;
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public String getPath() {
            return this.path;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public CacheInvalidationRule build() {
            return new CacheInvalidationRule(this.host, this.path);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setHost(this.host);
            newBuilder.setPath(this.path);
            return newBuilder;
        }
    }
}

