/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneInstanceGroupManagerName
implements ResourceName {
    private final String instanceGroupManager;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneInstanceGroupManagerName(Builder builder) {
        this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)builder.getInstanceGroupManager());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneInstanceGroupManagerName of(String instanceGroupManager, String project, String zone) {
        return ProjectZoneInstanceGroupManagerName.newBuilder().setInstanceGroupManager(instanceGroupManager).setProject(project).setZone(zone).build();
    }

    public static String format(String instanceGroupManager, String project, String zone) {
        return ProjectZoneInstanceGroupManagerName.of(instanceGroupManager, project, zone).toString();
    }

    public String getInstanceGroupManager() {
        return this.instanceGroupManager;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneInstanceGroupManagerName projectZoneInstanceGroupManagerName = this;
            synchronized (projectZoneInstanceGroupManagerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"instanceGroupManager", (Object)this.instanceGroupManager);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneInstanceGroupManagerName> newFactory() {
        return new ResourceNameFactory<ProjectZoneInstanceGroupManagerName>(){

            public ProjectZoneInstanceGroupManagerName parse(String formattedString) {
                return ProjectZoneInstanceGroupManagerName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneInstanceGroupManagerName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneInstanceGroupManagerName.parse: formattedString not in valid format");
        return ProjectZoneInstanceGroupManagerName.of((String)matchMap.get("instanceGroupManager"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"instanceGroupManager", this.instanceGroupManager, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneInstanceGroupManagerName) {
            ProjectZoneInstanceGroupManagerName that = (ProjectZoneInstanceGroupManagerName)o;
            return Objects.equals(this.instanceGroupManager, that.getInstanceGroupManager()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceGroupManager, this.project, this.zone);
    }

    public static class Builder {
        private String instanceGroupManager;
        private String project;
        private String zone;

        public String getInstanceGroupManager() {
            return this.instanceGroupManager;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setInstanceGroupManager(String instanceGroupManager) {
            this.instanceGroupManager = instanceGroupManager;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneInstanceGroupManagerName projectZoneInstanceGroupManagerName) {
            this.instanceGroupManager = projectZoneInstanceGroupManagerName.instanceGroupManager;
            this.project = projectZoneInstanceGroupManagerName.project;
            this.zone = projectZoneInstanceGroupManagerName.zone;
        }

        public ProjectZoneInstanceGroupManagerName build() {
            return new ProjectZoneInstanceGroupManagerName(this);
        }
    }
}

