/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ResourcePolicySnapshotSchedulePolicySnapshotProperties
implements ApiMessage {
    private final Boolean guestFlush;
    private final Map<String, String> labels;
    private final List<String> storageLocations;
    private static final ResourcePolicySnapshotSchedulePolicySnapshotProperties DEFAULT_INSTANCE = new ResourcePolicySnapshotSchedulePolicySnapshotProperties();

    private ResourcePolicySnapshotSchedulePolicySnapshotProperties() {
        this.guestFlush = null;
        this.labels = null;
        this.storageLocations = null;
    }

    private ResourcePolicySnapshotSchedulePolicySnapshotProperties(Boolean guestFlush, Map<String, String> labels, List<String> storageLocations) {
        this.guestFlush = guestFlush;
        this.labels = labels;
        this.storageLocations = storageLocations;
    }

    public Object getFieldValue(String fieldName) {
        if ("guestFlush".equals(fieldName)) {
            return this.guestFlush;
        }
        if ("labels".equals(fieldName)) {
            return this.labels;
        }
        if ("storageLocations".equals(fieldName)) {
            return this.storageLocations;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getGuestFlush() {
        return this.guestFlush;
    }

    public Map<String, String> getLabelsMap() {
        return this.labels;
    }

    public List<String> getStorageLocationsList() {
        return this.storageLocations;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ResourcePolicySnapshotSchedulePolicySnapshotProperties prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ResourcePolicySnapshotSchedulePolicySnapshotProperties getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ResourcePolicySnapshotSchedulePolicySnapshotProperties{guestFlush=" + this.guestFlush + ", labels=" + this.labels + ", storageLocations=" + this.storageLocations + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ResourcePolicySnapshotSchedulePolicySnapshotProperties) {
            ResourcePolicySnapshotSchedulePolicySnapshotProperties that = (ResourcePolicySnapshotSchedulePolicySnapshotProperties)o;
            return Objects.equals(this.guestFlush, that.getGuestFlush()) && Objects.equals(this.labels, that.getLabelsMap()) && Objects.equals(this.storageLocations, that.getStorageLocationsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.guestFlush, this.labels, this.storageLocations);
    }

    public static class Builder {
        private Boolean guestFlush;
        private Map<String, String> labels;
        private List<String> storageLocations;

        Builder() {
        }

        public Builder mergeFrom(ResourcePolicySnapshotSchedulePolicySnapshotProperties other) {
            if (other == ResourcePolicySnapshotSchedulePolicySnapshotProperties.getDefaultInstance()) {
                return this;
            }
            if (other.getGuestFlush() != null) {
                this.guestFlush = other.guestFlush;
            }
            if (other.getLabelsMap() != null) {
                this.labels = other.labels;
            }
            if (other.getStorageLocationsList() != null) {
                this.storageLocations = other.storageLocations;
            }
            return this;
        }

        Builder(ResourcePolicySnapshotSchedulePolicySnapshotProperties source) {
            this.guestFlush = source.guestFlush;
            this.labels = source.labels;
            this.storageLocations = source.storageLocations;
        }

        public Boolean getGuestFlush() {
            return this.guestFlush;
        }

        public Builder setGuestFlush(Boolean guestFlush) {
            this.guestFlush = guestFlush;
            return this;
        }

        public Map<String, String> getLabelsMap() {
            return this.labels;
        }

        public Builder putAllLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public List<String> getStorageLocationsList() {
            return this.storageLocations;
        }

        public Builder addAllStorageLocations(List<String> storageLocations) {
            if (this.storageLocations == null) {
                this.storageLocations = new LinkedList<String>();
            }
            this.storageLocations.addAll(storageLocations);
            return this;
        }

        public Builder addStorageLocations(String storageLocations) {
            if (this.storageLocations == null) {
                this.storageLocations = new LinkedList<String>();
            }
            this.storageLocations.add(storageLocations);
            return this;
        }

        public ResourcePolicySnapshotSchedulePolicySnapshotProperties build() {
            return new ResourcePolicySnapshotSchedulePolicySnapshotProperties(this.guestFlush, this.labels, this.storageLocations);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setGuestFlush(this.guestFlush);
            newBuilder.putAllLabels(this.labels);
            newBuilder.addAllStorageLocations(this.storageLocations);
            return newBuilder;
        }
    }
}

