/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalLicenseName
implements ResourceName {
    private final String license;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/licenses/{license}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalLicenseName(Builder builder) {
        this.license = (String)Preconditions.checkNotNull((Object)builder.getLicense());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalLicenseName of(String license, String project) {
        return ProjectGlobalLicenseName.newBuilder().setLicense(license).setProject(project).build();
    }

    public static String format(String license, String project) {
        return ProjectGlobalLicenseName.of(license, project).toString();
    }

    public String getLicense() {
        return this.license;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalLicenseName projectGlobalLicenseName = this;
            synchronized (projectGlobalLicenseName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"license", (Object)this.license);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalLicenseName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalLicenseName>(){

            public ProjectGlobalLicenseName parse(String formattedString) {
                return ProjectGlobalLicenseName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalLicenseName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalLicenseName.parse: formattedString not in valid format");
        return ProjectGlobalLicenseName.of((String)matchMap.get("license"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"license", this.license, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalLicenseName) {
            ProjectGlobalLicenseName that = (ProjectGlobalLicenseName)o;
            return Objects.equals(this.license, that.getLicense()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.license, this.project);
    }

    public static class Builder {
        private String license;
        private String project;

        public String getLicense() {
            return this.license;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setLicense(String license) {
            this.license = license;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalLicenseName projectGlobalLicenseName) {
            this.license = projectGlobalLicenseName.license;
            this.project = projectGlobalLicenseName.project;
        }

        public ProjectGlobalLicenseName build() {
            return new ProjectGlobalLicenseName(this);
        }
    }
}

