/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalInterconnectLocationName
implements ResourceName {
    private final String interconnectLocation;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/interconnectLocations/{interconnectLocation}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalInterconnectLocationName(Builder builder) {
        this.interconnectLocation = (String)Preconditions.checkNotNull((Object)builder.getInterconnectLocation());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalInterconnectLocationName of(String interconnectLocation, String project) {
        return ProjectGlobalInterconnectLocationName.newBuilder().setInterconnectLocation(interconnectLocation).setProject(project).build();
    }

    public static String format(String interconnectLocation, String project) {
        return ProjectGlobalInterconnectLocationName.of(interconnectLocation, project).toString();
    }

    public String getInterconnectLocation() {
        return this.interconnectLocation;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalInterconnectLocationName projectGlobalInterconnectLocationName = this;
            synchronized (projectGlobalInterconnectLocationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"interconnectLocation", (Object)this.interconnectLocation);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalInterconnectLocationName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalInterconnectLocationName>(){

            public ProjectGlobalInterconnectLocationName parse(String formattedString) {
                return ProjectGlobalInterconnectLocationName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalInterconnectLocationName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalInterconnectLocationName.parse: formattedString not in valid format");
        return ProjectGlobalInterconnectLocationName.of((String)matchMap.get("interconnectLocation"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"interconnectLocation", this.interconnectLocation, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalInterconnectLocationName) {
            ProjectGlobalInterconnectLocationName that = (ProjectGlobalInterconnectLocationName)o;
            return Objects.equals(this.interconnectLocation, that.getInterconnectLocation()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.interconnectLocation, this.project);
    }

    public static class Builder {
        private String interconnectLocation;
        private String project;

        public String getInterconnectLocation() {
            return this.interconnectLocation;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setInterconnectLocation(String interconnectLocation) {
            this.interconnectLocation = interconnectLocation;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalInterconnectLocationName projectGlobalInterconnectLocationName) {
            this.interconnectLocation = projectGlobalInterconnectLocationName.interconnectLocation;
            this.project = projectGlobalInterconnectLocationName.project;
        }

        public ProjectGlobalInterconnectLocationName build() {
            return new ProjectGlobalInterconnectLocationName(this);
        }
    }
}

