/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalInstanceTemplateResourceName
implements ResourceName {
    private final String project;
    private final String resource;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/instanceTemplates/{resource}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalInstanceTemplateResourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.resource = (String)Preconditions.checkNotNull((Object)builder.getResource());
    }

    public static ProjectGlobalInstanceTemplateResourceName of(String project, String resource) {
        return ProjectGlobalInstanceTemplateResourceName.newBuilder().setProject(project).setResource(resource).build();
    }

    public static String format(String project, String resource) {
        return ProjectGlobalInstanceTemplateResourceName.of(project, resource).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalInstanceTemplateResourceName projectGlobalInstanceTemplateResourceName = this;
            synchronized (projectGlobalInstanceTemplateResourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"resource", (Object)this.resource);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalInstanceTemplateResourceName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalInstanceTemplateResourceName>(){

            public ProjectGlobalInstanceTemplateResourceName parse(String formattedString) {
                return ProjectGlobalInstanceTemplateResourceName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalInstanceTemplateResourceName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalInstanceTemplateResourceName.parse: formattedString not in valid format");
        return ProjectGlobalInstanceTemplateResourceName.of((String)matchMap.get("project"), (String)matchMap.get("resource"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "resource", this.resource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalInstanceTemplateResourceName) {
            ProjectGlobalInstanceTemplateResourceName that = (ProjectGlobalInstanceTemplateResourceName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.resource, that.getResource());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.resource);
    }

    public static class Builder {
        private String project;
        private String resource;

        public String getProject() {
            return this.project;
        }

        public String getResource() {
            return this.resource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setResource(String resource) {
            this.resource = resource;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalInstanceTemplateResourceName projectGlobalInstanceTemplateResourceName) {
            this.project = projectGlobalInstanceTemplateResourceName.project;
            this.resource = projectGlobalInstanceTemplateResourceName.resource;
        }

        public ProjectGlobalInstanceTemplateResourceName build() {
            return new ProjectGlobalInstanceTemplateResourceName(this);
        }
    }
}

