/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNodeTemplatesHttpRequest;
import com.google.cloud.compute.v1.DeleteNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.GetNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.InsertNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.ListNodeTemplatesHttpRequest;
import com.google.cloud.compute.v1.NodeTemplate;
import com.google.cloud.compute.v1.NodeTemplateAggregatedList;
import com.google.cloud.compute.v1.NodeTemplateList;
import com.google.cloud.compute.v1.NodeTemplateSettings;
import com.google.cloud.compute.v1.NodeTemplatesScopedList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionNodeTemplateName;
import com.google.cloud.compute.v1.ProjectRegionNodeTemplateResourceName;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicyNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNodeTemplateHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.NodeTemplateStub;
import com.google.cloud.compute.v1.stub.NodeTemplateStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class NodeTemplateClient
implements BackgroundResource {
    private final NodeTemplateSettings settings;
    private final NodeTemplateStub stub;

    public static final NodeTemplateClient create() throws IOException {
        return NodeTemplateClient.create(NodeTemplateSettings.newBuilder().build());
    }

    public static final NodeTemplateClient create(NodeTemplateSettings settings) throws IOException {
        return new NodeTemplateClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final NodeTemplateClient create(NodeTemplateStub stub) {
        return new NodeTemplateClient(stub);
    }

    protected NodeTemplateClient(NodeTemplateSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NodeTemplateStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected NodeTemplateClient(NodeTemplateStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NodeTemplateSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NodeTemplateStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListNodeTemplatesPagedResponse aggregatedListNodeTemplates(Boolean includeAllScopes, ProjectName project) {
        AggregatedListNodeTemplatesHttpRequest request = AggregatedListNodeTemplatesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListNodeTemplates(request);
    }

    @BetaApi
    public final AggregatedListNodeTemplatesPagedResponse aggregatedListNodeTemplates(Boolean includeAllScopes, String project) {
        AggregatedListNodeTemplatesHttpRequest request = AggregatedListNodeTemplatesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListNodeTemplates(request);
    }

    @BetaApi
    public final AggregatedListNodeTemplatesPagedResponse aggregatedListNodeTemplates(AggregatedListNodeTemplatesHttpRequest request) {
        return (AggregatedListNodeTemplatesPagedResponse)((Object)this.aggregatedListNodeTemplatesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListNodeTemplatesHttpRequest, AggregatedListNodeTemplatesPagedResponse> aggregatedListNodeTemplatesPagedCallable() {
        return this.stub.aggregatedListNodeTemplatesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList> aggregatedListNodeTemplatesCallable() {
        return this.stub.aggregatedListNodeTemplatesCallable();
    }

    @BetaApi
    public final Operation deleteNodeTemplate(ProjectRegionNodeTemplateName nodeTemplate) {
        DeleteNodeTemplateHttpRequest request = DeleteNodeTemplateHttpRequest.newBuilder().setNodeTemplate(nodeTemplate == null ? null : nodeTemplate.toString()).build();
        return this.deleteNodeTemplate(request);
    }

    @BetaApi
    public final Operation deleteNodeTemplate(String nodeTemplate) {
        DeleteNodeTemplateHttpRequest request = DeleteNodeTemplateHttpRequest.newBuilder().setNodeTemplate(nodeTemplate).build();
        return this.deleteNodeTemplate(request);
    }

    @BetaApi
    public final Operation deleteNodeTemplate(DeleteNodeTemplateHttpRequest request) {
        return (Operation)this.deleteNodeTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteNodeTemplateHttpRequest, Operation> deleteNodeTemplateCallable() {
        return this.stub.deleteNodeTemplateCallable();
    }

    @BetaApi
    public final NodeTemplate getNodeTemplate(ProjectRegionNodeTemplateName nodeTemplate) {
        GetNodeTemplateHttpRequest request = GetNodeTemplateHttpRequest.newBuilder().setNodeTemplate(nodeTemplate == null ? null : nodeTemplate.toString()).build();
        return this.getNodeTemplate(request);
    }

    @BetaApi
    public final NodeTemplate getNodeTemplate(String nodeTemplate) {
        GetNodeTemplateHttpRequest request = GetNodeTemplateHttpRequest.newBuilder().setNodeTemplate(nodeTemplate).build();
        return this.getNodeTemplate(request);
    }

    @BetaApi
    public final NodeTemplate getNodeTemplate(GetNodeTemplateHttpRequest request) {
        return (NodeTemplate)this.getNodeTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetNodeTemplateHttpRequest, NodeTemplate> getNodeTemplateCallable() {
        return this.stub.getNodeTemplateCallable();
    }

    @BetaApi
    public final Policy getIamPolicyNodeTemplate(ProjectRegionNodeTemplateResourceName resource) {
        GetIamPolicyNodeTemplateHttpRequest request = GetIamPolicyNodeTemplateHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicyNodeTemplate(request);
    }

    @BetaApi
    public final Policy getIamPolicyNodeTemplate(String resource) {
        GetIamPolicyNodeTemplateHttpRequest request = GetIamPolicyNodeTemplateHttpRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicyNodeTemplate(request);
    }

    @BetaApi
    public final Policy getIamPolicyNodeTemplate(GetIamPolicyNodeTemplateHttpRequest request) {
        return (Policy)this.getIamPolicyNodeTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetIamPolicyNodeTemplateHttpRequest, Policy> getIamPolicyNodeTemplateCallable() {
        return this.stub.getIamPolicyNodeTemplateCallable();
    }

    @BetaApi
    public final Operation insertNodeTemplate(ProjectRegionName region, NodeTemplate nodeTemplateResource) {
        InsertNodeTemplateHttpRequest request = InsertNodeTemplateHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setNodeTemplateResource(nodeTemplateResource).build();
        return this.insertNodeTemplate(request);
    }

    @BetaApi
    public final Operation insertNodeTemplate(String region, NodeTemplate nodeTemplateResource) {
        InsertNodeTemplateHttpRequest request = InsertNodeTemplateHttpRequest.newBuilder().setRegion(region).setNodeTemplateResource(nodeTemplateResource).build();
        return this.insertNodeTemplate(request);
    }

    @BetaApi
    public final Operation insertNodeTemplate(InsertNodeTemplateHttpRequest request) {
        return (Operation)this.insertNodeTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertNodeTemplateHttpRequest, Operation> insertNodeTemplateCallable() {
        return this.stub.insertNodeTemplateCallable();
    }

    @BetaApi
    public final ListNodeTemplatesPagedResponse listNodeTemplates(ProjectRegionName region) {
        ListNodeTemplatesHttpRequest request = ListNodeTemplatesHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listNodeTemplates(request);
    }

    @BetaApi
    public final ListNodeTemplatesPagedResponse listNodeTemplates(String region) {
        ListNodeTemplatesHttpRequest request = ListNodeTemplatesHttpRequest.newBuilder().setRegion(region).build();
        return this.listNodeTemplates(request);
    }

    @BetaApi
    public final ListNodeTemplatesPagedResponse listNodeTemplates(ListNodeTemplatesHttpRequest request) {
        return (ListNodeTemplatesPagedResponse)((Object)this.listNodeTemplatesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListNodeTemplatesHttpRequest, ListNodeTemplatesPagedResponse> listNodeTemplatesPagedCallable() {
        return this.stub.listNodeTemplatesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListNodeTemplatesHttpRequest, NodeTemplateList> listNodeTemplatesCallable() {
        return this.stub.listNodeTemplatesCallable();
    }

    @BetaApi
    public final Policy setIamPolicyNodeTemplate(ProjectRegionNodeTemplateResourceName resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyNodeTemplateHttpRequest request = SetIamPolicyNodeTemplateHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicyNodeTemplate(request);
    }

    @BetaApi
    public final Policy setIamPolicyNodeTemplate(String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyNodeTemplateHttpRequest request = SetIamPolicyNodeTemplateHttpRequest.newBuilder().setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicyNodeTemplate(request);
    }

    @BetaApi
    public final Policy setIamPolicyNodeTemplate(SetIamPolicyNodeTemplateHttpRequest request) {
        return (Policy)this.setIamPolicyNodeTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetIamPolicyNodeTemplateHttpRequest, Policy> setIamPolicyNodeTemplateCallable() {
        return this.stub.setIamPolicyNodeTemplateCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsNodeTemplate(ProjectRegionNodeTemplateResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNodeTemplateHttpRequest request = TestIamPermissionsNodeTemplateHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsNodeTemplate(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsNodeTemplate(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNodeTemplateHttpRequest request = TestIamPermissionsNodeTemplateHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsNodeTemplate(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsNodeTemplate(TestIamPermissionsNodeTemplateHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsNodeTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsNodeTemplateHttpRequest, TestPermissionsResponse> testIamPermissionsNodeTemplateCallable() {
        return this.stub.testIamPermissionsNodeTemplateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNodeTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplate, ListNodeTemplatesPage, ListNodeTemplatesFixedSizeCollection> {
        private ListNodeTemplatesFixedSizeCollection(List<ListNodeTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodeTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListNodeTemplatesFixedSizeCollection(null, 0);
        }

        protected ListNodeTemplatesFixedSizeCollection createCollection(List<ListNodeTemplatesPage> pages, int collectionSize) {
            return new ListNodeTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodeTemplatesPage
    extends AbstractPage<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplate, ListNodeTemplatesPage> {
        private ListNodeTemplatesPage(PageContext<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplate> context, NodeTemplateList response) {
            super(context, (Object)response);
        }

        private static ListNodeTemplatesPage createEmptyPage() {
            return new ListNodeTemplatesPage(null, null);
        }

        protected ListNodeTemplatesPage createPage(PageContext<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplate> context, NodeTemplateList response) {
            return new ListNodeTemplatesPage(context, response);
        }

        public ApiFuture<ListNodeTemplatesPage> createPageAsync(PageContext<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplate> context, ApiFuture<NodeTemplateList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodeTemplatesPagedResponse
    extends AbstractPagedListResponse<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplate, ListNodeTemplatesPage, ListNodeTemplatesFixedSizeCollection> {
        public static ApiFuture<ListNodeTemplatesPagedResponse> createAsync(PageContext<ListNodeTemplatesHttpRequest, NodeTemplateList, NodeTemplate> context, ApiFuture<NodeTemplateList> futureResponse) {
            ApiFuture<ListNodeTemplatesPage> futurePage = ListNodeTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNodeTemplatesPage, ListNodeTemplatesPagedResponse>(){

                public ListNodeTemplatesPagedResponse apply(ListNodeTemplatesPage input) {
                    return new ListNodeTemplatesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNodeTemplatesPagedResponse(ListNodeTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodeTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListNodeTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplatesScopedList, AggregatedListNodeTemplatesPage, AggregatedListNodeTemplatesFixedSizeCollection> {
        private AggregatedListNodeTemplatesFixedSizeCollection(List<AggregatedListNodeTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListNodeTemplatesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListNodeTemplatesFixedSizeCollection(null, 0);
        }

        protected AggregatedListNodeTemplatesFixedSizeCollection createCollection(List<AggregatedListNodeTemplatesPage> pages, int collectionSize) {
            return new AggregatedListNodeTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListNodeTemplatesPage
    extends AbstractPage<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplatesScopedList, AggregatedListNodeTemplatesPage> {
        private AggregatedListNodeTemplatesPage(PageContext<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplatesScopedList> context, NodeTemplateAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListNodeTemplatesPage createEmptyPage() {
            return new AggregatedListNodeTemplatesPage(null, null);
        }

        protected AggregatedListNodeTemplatesPage createPage(PageContext<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplatesScopedList> context, NodeTemplateAggregatedList response) {
            return new AggregatedListNodeTemplatesPage(context, response);
        }

        public ApiFuture<AggregatedListNodeTemplatesPage> createPageAsync(PageContext<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplatesScopedList> context, ApiFuture<NodeTemplateAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListNodeTemplatesPagedResponse
    extends AbstractPagedListResponse<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplatesScopedList, AggregatedListNodeTemplatesPage, AggregatedListNodeTemplatesFixedSizeCollection> {
        public static ApiFuture<AggregatedListNodeTemplatesPagedResponse> createAsync(PageContext<AggregatedListNodeTemplatesHttpRequest, NodeTemplateAggregatedList, NodeTemplatesScopedList> context, ApiFuture<NodeTemplateAggregatedList> futureResponse) {
            ApiFuture<AggregatedListNodeTemplatesPage> futurePage = AggregatedListNodeTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListNodeTemplatesPage, AggregatedListNodeTemplatesPagedResponse>(){

                public AggregatedListNodeTemplatesPagedResponse apply(AggregatedListNodeTemplatesPage input) {
                    return new AggregatedListNodeTemplatesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListNodeTemplatesPagedResponse(AggregatedListNodeTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListNodeTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

