/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Duration
implements ApiMessage {
    private final Integer nanos;
    private final String seconds;
    private static final Duration DEFAULT_INSTANCE = new Duration();

    private Duration() {
        this.nanos = null;
        this.seconds = null;
    }

    private Duration(Integer nanos, String seconds) {
        this.nanos = nanos;
        this.seconds = seconds;
    }

    public Object getFieldValue(String fieldName) {
        if ("nanos".equals(fieldName)) {
            return this.nanos;
        }
        if ("seconds".equals(fieldName)) {
            return this.seconds;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Integer getNanos() {
        return this.nanos;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Duration prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Duration getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Duration{nanos=" + this.nanos + ", seconds=" + this.seconds + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Duration) {
            Duration that = (Duration)o;
            return Objects.equals(this.nanos, that.getNanos()) && Objects.equals(this.seconds, that.getSeconds());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.nanos, this.seconds);
    }

    public static class Builder {
        private Integer nanos;
        private String seconds;

        Builder() {
        }

        public Builder mergeFrom(Duration other) {
            if (other == Duration.getDefaultInstance()) {
                return this;
            }
            if (other.getNanos() != null) {
                this.nanos = other.nanos;
            }
            if (other.getSeconds() != null) {
                this.seconds = other.seconds;
            }
            return this;
        }

        Builder(Duration source) {
            this.nanos = source.nanos;
            this.seconds = source.seconds;
        }

        public Integer getNanos() {
            return this.nanos;
        }

        public Builder setNanos(Integer nanos) {
            this.nanos = nanos;
            return this;
        }

        public String getSeconds() {
            return this.seconds;
        }

        public Builder setSeconds(String seconds) {
            this.seconds = seconds;
            return this;
        }

        public Duration build() {
            return new Duration(this.nanos, this.seconds);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setNanos(this.nanos);
            newBuilder.setSeconds(this.seconds);
            return newBuilder;
        }
    }
}

