/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AllocationSpecificSKUReservation
implements ApiMessage {
    private final String count;
    private final String inUseCount;
    private final AllocationSpecificSKUAllocationReservedInstanceProperties instanceProperties;
    private static final AllocationSpecificSKUReservation DEFAULT_INSTANCE = new AllocationSpecificSKUReservation();

    private AllocationSpecificSKUReservation() {
        this.count = null;
        this.inUseCount = null;
        this.instanceProperties = null;
    }

    private AllocationSpecificSKUReservation(String count, String inUseCount, AllocationSpecificSKUAllocationReservedInstanceProperties instanceProperties) {
        this.count = count;
        this.inUseCount = inUseCount;
        this.instanceProperties = instanceProperties;
    }

    public Object getFieldValue(String fieldName) {
        if ("count".equals(fieldName)) {
            return this.count;
        }
        if ("inUseCount".equals(fieldName)) {
            return this.inUseCount;
        }
        if ("instanceProperties".equals(fieldName)) {
            return this.instanceProperties;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCount() {
        return this.count;
    }

    public String getInUseCount() {
        return this.inUseCount;
    }

    public AllocationSpecificSKUAllocationReservedInstanceProperties getInstanceProperties() {
        return this.instanceProperties;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AllocationSpecificSKUReservation prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AllocationSpecificSKUReservation getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AllocationSpecificSKUReservation{count=" + this.count + ", inUseCount=" + this.inUseCount + ", instanceProperties=" + this.instanceProperties + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AllocationSpecificSKUReservation) {
            AllocationSpecificSKUReservation that = (AllocationSpecificSKUReservation)o;
            return Objects.equals(this.count, that.getCount()) && Objects.equals(this.inUseCount, that.getInUseCount()) && Objects.equals(this.instanceProperties, that.getInstanceProperties());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.count, this.inUseCount, this.instanceProperties);
    }

    public static class Builder {
        private String count;
        private String inUseCount;
        private AllocationSpecificSKUAllocationReservedInstanceProperties instanceProperties;

        Builder() {
        }

        public Builder mergeFrom(AllocationSpecificSKUReservation other) {
            if (other == AllocationSpecificSKUReservation.getDefaultInstance()) {
                return this;
            }
            if (other.getCount() != null) {
                this.count = other.count;
            }
            if (other.getInUseCount() != null) {
                this.inUseCount = other.inUseCount;
            }
            if (other.getInstanceProperties() != null) {
                this.instanceProperties = other.instanceProperties;
            }
            return this;
        }

        Builder(AllocationSpecificSKUReservation source) {
            this.count = source.count;
            this.inUseCount = source.inUseCount;
            this.instanceProperties = source.instanceProperties;
        }

        public String getCount() {
            return this.count;
        }

        public Builder setCount(String count) {
            this.count = count;
            return this;
        }

        public String getInUseCount() {
            return this.inUseCount;
        }

        public Builder setInUseCount(String inUseCount) {
            this.inUseCount = inUseCount;
            return this;
        }

        public AllocationSpecificSKUAllocationReservedInstanceProperties getInstanceProperties() {
            return this.instanceProperties;
        }

        public Builder setInstanceProperties(AllocationSpecificSKUAllocationReservedInstanceProperties instanceProperties) {
            this.instanceProperties = instanceProperties;
            return this;
        }

        public AllocationSpecificSKUReservation build() {
            return new AllocationSpecificSKUReservation(this.count, this.inUseCount, this.instanceProperties);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCount(this.count);
            newBuilder.setInUseCount(this.inUseCount);
            newBuilder.setInstanceProperties(this.instanceProperties);
            return newBuilder;
        }
    }
}

