/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListReservationsHttpRequest;
import com.google.cloud.compute.v1.DeleteReservationHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyReservationHttpRequest;
import com.google.cloud.compute.v1.GetReservationHttpRequest;
import com.google.cloud.compute.v1.InsertReservationHttpRequest;
import com.google.cloud.compute.v1.ListReservationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.ProjectZoneReservationName;
import com.google.cloud.compute.v1.ProjectZoneReservationResourceName;
import com.google.cloud.compute.v1.Reservation;
import com.google.cloud.compute.v1.ReservationAggregatedList;
import com.google.cloud.compute.v1.ReservationList;
import com.google.cloud.compute.v1.ReservationSettings;
import com.google.cloud.compute.v1.ReservationsResizeRequest;
import com.google.cloud.compute.v1.ReservationsScopedList;
import com.google.cloud.compute.v1.ResizeReservationHttpRequest;
import com.google.cloud.compute.v1.SetIamPolicyReservationHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsReservationHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.ZoneSetPolicyRequest;
import com.google.cloud.compute.v1.stub.ReservationStub;
import com.google.cloud.compute.v1.stub.ReservationStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ReservationClient
implements BackgroundResource {
    private final ReservationSettings settings;
    private final ReservationStub stub;

    public static final ReservationClient create() throws IOException {
        return ReservationClient.create(ReservationSettings.newBuilder().build());
    }

    public static final ReservationClient create(ReservationSettings settings) throws IOException {
        return new ReservationClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ReservationClient create(ReservationStub stub) {
        return new ReservationClient(stub);
    }

    protected ReservationClient(ReservationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ReservationStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ReservationClient(ReservationStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ReservationSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ReservationStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListReservationsPagedResponse aggregatedListReservations(ProjectName project) {
        AggregatedListReservationsHttpRequest request = AggregatedListReservationsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListReservations(request);
    }

    @BetaApi
    public final AggregatedListReservationsPagedResponse aggregatedListReservations(String project) {
        AggregatedListReservationsHttpRequest request = AggregatedListReservationsHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListReservations(request);
    }

    @BetaApi
    public final AggregatedListReservationsPagedResponse aggregatedListReservations(AggregatedListReservationsHttpRequest request) {
        return (AggregatedListReservationsPagedResponse)((Object)this.aggregatedListReservationsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListReservationsHttpRequest, AggregatedListReservationsPagedResponse> aggregatedListReservationsPagedCallable() {
        return this.stub.aggregatedListReservationsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListReservationsHttpRequest, ReservationAggregatedList> aggregatedListReservationsCallable() {
        return this.stub.aggregatedListReservationsCallable();
    }

    @BetaApi
    public final Operation deleteReservation(ProjectZoneReservationName reservation) {
        DeleteReservationHttpRequest request = DeleteReservationHttpRequest.newBuilder().setReservation(reservation == null ? null : reservation.toString()).build();
        return this.deleteReservation(request);
    }

    @BetaApi
    public final Operation deleteReservation(String reservation) {
        DeleteReservationHttpRequest request = DeleteReservationHttpRequest.newBuilder().setReservation(reservation).build();
        return this.deleteReservation(request);
    }

    @BetaApi
    public final Operation deleteReservation(DeleteReservationHttpRequest request) {
        return (Operation)this.deleteReservationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteReservationHttpRequest, Operation> deleteReservationCallable() {
        return this.stub.deleteReservationCallable();
    }

    @BetaApi
    public final Reservation getReservation(ProjectZoneReservationName reservation) {
        GetReservationHttpRequest request = GetReservationHttpRequest.newBuilder().setReservation(reservation == null ? null : reservation.toString()).build();
        return this.getReservation(request);
    }

    @BetaApi
    public final Reservation getReservation(String reservation) {
        GetReservationHttpRequest request = GetReservationHttpRequest.newBuilder().setReservation(reservation).build();
        return this.getReservation(request);
    }

    @BetaApi
    public final Reservation getReservation(GetReservationHttpRequest request) {
        return (Reservation)this.getReservationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetReservationHttpRequest, Reservation> getReservationCallable() {
        return this.stub.getReservationCallable();
    }

    @BetaApi
    public final Policy getIamPolicyReservation(ProjectZoneReservationResourceName resource) {
        GetIamPolicyReservationHttpRequest request = GetIamPolicyReservationHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicyReservation(request);
    }

    @BetaApi
    public final Policy getIamPolicyReservation(String resource) {
        GetIamPolicyReservationHttpRequest request = GetIamPolicyReservationHttpRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicyReservation(request);
    }

    @BetaApi
    public final Policy getIamPolicyReservation(GetIamPolicyReservationHttpRequest request) {
        return (Policy)this.getIamPolicyReservationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetIamPolicyReservationHttpRequest, Policy> getIamPolicyReservationCallable() {
        return this.stub.getIamPolicyReservationCallable();
    }

    @BetaApi
    public final Operation insertReservation(ProjectZoneName zone, Reservation reservationResource) {
        InsertReservationHttpRequest request = InsertReservationHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).setReservationResource(reservationResource).build();
        return this.insertReservation(request);
    }

    @BetaApi
    public final Operation insertReservation(String zone, Reservation reservationResource) {
        InsertReservationHttpRequest request = InsertReservationHttpRequest.newBuilder().setZone(zone).setReservationResource(reservationResource).build();
        return this.insertReservation(request);
    }

    @BetaApi
    public final Operation insertReservation(InsertReservationHttpRequest request) {
        return (Operation)this.insertReservationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertReservationHttpRequest, Operation> insertReservationCallable() {
        return this.stub.insertReservationCallable();
    }

    @BetaApi
    public final ListReservationsPagedResponse listReservations(ProjectZoneName zone) {
        ListReservationsHttpRequest request = ListReservationsHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listReservations(request);
    }

    @BetaApi
    public final ListReservationsPagedResponse listReservations(String zone) {
        ListReservationsHttpRequest request = ListReservationsHttpRequest.newBuilder().setZone(zone).build();
        return this.listReservations(request);
    }

    @BetaApi
    public final ListReservationsPagedResponse listReservations(ListReservationsHttpRequest request) {
        return (ListReservationsPagedResponse)((Object)this.listReservationsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListReservationsHttpRequest, ListReservationsPagedResponse> listReservationsPagedCallable() {
        return this.stub.listReservationsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListReservationsHttpRequest, ReservationList> listReservationsCallable() {
        return this.stub.listReservationsCallable();
    }

    @BetaApi
    public final Operation resizeReservation(ProjectZoneReservationName reservation, ReservationsResizeRequest reservationsResizeRequestResource) {
        ResizeReservationHttpRequest request = ResizeReservationHttpRequest.newBuilder().setReservation(reservation == null ? null : reservation.toString()).setReservationsResizeRequestResource(reservationsResizeRequestResource).build();
        return this.resizeReservation(request);
    }

    @BetaApi
    public final Operation resizeReservation(String reservation, ReservationsResizeRequest reservationsResizeRequestResource) {
        ResizeReservationHttpRequest request = ResizeReservationHttpRequest.newBuilder().setReservation(reservation).setReservationsResizeRequestResource(reservationsResizeRequestResource).build();
        return this.resizeReservation(request);
    }

    @BetaApi
    public final Operation resizeReservation(ResizeReservationHttpRequest request) {
        return (Operation)this.resizeReservationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ResizeReservationHttpRequest, Operation> resizeReservationCallable() {
        return this.stub.resizeReservationCallable();
    }

    @BetaApi
    public final Policy setIamPolicyReservation(ProjectZoneReservationResourceName resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyReservationHttpRequest request = SetIamPolicyReservationHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicyReservation(request);
    }

    @BetaApi
    public final Policy setIamPolicyReservation(String resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyReservationHttpRequest request = SetIamPolicyReservationHttpRequest.newBuilder().setResource(resource).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicyReservation(request);
    }

    @BetaApi
    public final Policy setIamPolicyReservation(SetIamPolicyReservationHttpRequest request) {
        return (Policy)this.setIamPolicyReservationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetIamPolicyReservationHttpRequest, Policy> setIamPolicyReservationCallable() {
        return this.stub.setIamPolicyReservationCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsReservation(ProjectZoneReservationResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsReservationHttpRequest request = TestIamPermissionsReservationHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsReservation(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsReservation(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsReservationHttpRequest request = TestIamPermissionsReservationHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsReservation(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsReservation(TestIamPermissionsReservationHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsReservationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsReservationHttpRequest, TestPermissionsResponse> testIamPermissionsReservationCallable() {
        return this.stub.testIamPermissionsReservationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListReservationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReservationsHttpRequest, ReservationList, Reservation, ListReservationsPage, ListReservationsFixedSizeCollection> {
        private ListReservationsFixedSizeCollection(List<ListReservationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReservationsFixedSizeCollection createEmptyCollection() {
            return new ListReservationsFixedSizeCollection(null, 0);
        }

        protected ListReservationsFixedSizeCollection createCollection(List<ListReservationsPage> pages, int collectionSize) {
            return new ListReservationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReservationsPage
    extends AbstractPage<ListReservationsHttpRequest, ReservationList, Reservation, ListReservationsPage> {
        private ListReservationsPage(PageContext<ListReservationsHttpRequest, ReservationList, Reservation> context, ReservationList response) {
            super(context, (Object)response);
        }

        private static ListReservationsPage createEmptyPage() {
            return new ListReservationsPage(null, null);
        }

        protected ListReservationsPage createPage(PageContext<ListReservationsHttpRequest, ReservationList, Reservation> context, ReservationList response) {
            return new ListReservationsPage(context, response);
        }

        public ApiFuture<ListReservationsPage> createPageAsync(PageContext<ListReservationsHttpRequest, ReservationList, Reservation> context, ApiFuture<ReservationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReservationsPagedResponse
    extends AbstractPagedListResponse<ListReservationsHttpRequest, ReservationList, Reservation, ListReservationsPage, ListReservationsFixedSizeCollection> {
        public static ApiFuture<ListReservationsPagedResponse> createAsync(PageContext<ListReservationsHttpRequest, ReservationList, Reservation> context, ApiFuture<ReservationList> futureResponse) {
            ApiFuture<ListReservationsPage> futurePage = ListReservationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListReservationsPage, ListReservationsPagedResponse>(){

                public ListReservationsPagedResponse apply(ListReservationsPage input) {
                    return new ListReservationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListReservationsPagedResponse(ListReservationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReservationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListReservationsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationsScopedList, AggregatedListReservationsPage, AggregatedListReservationsFixedSizeCollection> {
        private AggregatedListReservationsFixedSizeCollection(List<AggregatedListReservationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListReservationsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListReservationsFixedSizeCollection(null, 0);
        }

        protected AggregatedListReservationsFixedSizeCollection createCollection(List<AggregatedListReservationsPage> pages, int collectionSize) {
            return new AggregatedListReservationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListReservationsPage
    extends AbstractPage<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationsScopedList, AggregatedListReservationsPage> {
        private AggregatedListReservationsPage(PageContext<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationsScopedList> context, ReservationAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListReservationsPage createEmptyPage() {
            return new AggregatedListReservationsPage(null, null);
        }

        protected AggregatedListReservationsPage createPage(PageContext<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationsScopedList> context, ReservationAggregatedList response) {
            return new AggregatedListReservationsPage(context, response);
        }

        public ApiFuture<AggregatedListReservationsPage> createPageAsync(PageContext<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationsScopedList> context, ApiFuture<ReservationAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListReservationsPagedResponse
    extends AbstractPagedListResponse<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationsScopedList, AggregatedListReservationsPage, AggregatedListReservationsFixedSizeCollection> {
        public static ApiFuture<AggregatedListReservationsPagedResponse> createAsync(PageContext<AggregatedListReservationsHttpRequest, ReservationAggregatedList, ReservationsScopedList> context, ApiFuture<ReservationAggregatedList> futureResponse) {
            ApiFuture<AggregatedListReservationsPage> futurePage = AggregatedListReservationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListReservationsPage, AggregatedListReservationsPagedResponse>(){

                public AggregatedListReservationsPagedResponse apply(AggregatedListReservationsPage input) {
                    return new AggregatedListReservationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListReservationsPagedResponse(AggregatedListReservationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListReservationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

