/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.OperationId;
import com.google.cloud.compute.deprecated.ZoneId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ZoneOperationId
extends OperationId {
    private static final String REGEX = ".*?projects/([^/]+)/zones/([^/]+)/operations/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/zones/([^/]+)/operations/([^/]+)");
    private static final long serialVersionUID = 4910670262094017392L;
    private final String zone;

    private ZoneOperationId(String project, String zone, String operation) {
        super(project, operation);
        this.zone = (String)Preconditions.checkNotNull((Object)zone);
    }

    @Override
    public OperationId.Type getType() {
        return OperationId.Type.ZONE;
    }

    public String getZone() {
        return this.zone;
    }

    public ZoneId getZoneId() {
        return ZoneId.of(this.getProject(), this.zone);
    }

    @Override
    public String getSelfLink() {
        return super.getSelfLink() + "/zones/" + this.zone + "/operations/" + this.getOperation();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("zone", (Object)this.zone);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.zone);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ZoneOperationId)) {
            return false;
        }
        ZoneOperationId other = (ZoneOperationId)obj;
        return this.baseEquals(other) && Objects.equals(this.zone, other.zone);
    }

    @Override
    ZoneOperationId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return ZoneOperationId.of(projectId, this.zone, this.getOperation());
    }

    public static ZoneOperationId of(ZoneId zoneId, String operation) {
        return new ZoneOperationId(zoneId.getProject(), zoneId.getZone(), operation);
    }

    public static ZoneOperationId of(String zone, String operation) {
        return new ZoneOperationId(null, zone, operation);
    }

    public static ZoneOperationId of(String project, String zone, String operation) {
        return new ZoneOperationId(project, zone, operation);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static ZoneOperationId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid zone operation URL");
        }
        return ZoneOperationId.of(matcher.group(1), matcher.group(2), matcher.group(3));
    }
}

