/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PathRule
implements ApiMessage {
    private final List<String> paths;
    private final String service;
    private static final PathRule DEFAULT_INSTANCE = new PathRule();

    private PathRule() {
        this.paths = null;
        this.service = null;
    }

    private PathRule(List<String> paths, String service) {
        this.paths = paths;
        this.service = service;
    }

    public Object getFieldValue(String fieldName) {
        if ("paths".equals(fieldName)) {
            return this.paths;
        }
        if ("service".equals(fieldName)) {
            return this.service;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getPathsList() {
        return this.paths;
    }

    public String getService() {
        return this.service;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PathRule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PathRule getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PathRule{paths=" + this.paths + ", service=" + this.service + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PathRule) {
            PathRule that = (PathRule)o;
            return Objects.equals(this.paths, that.getPathsList()) && Objects.equals(this.service, that.getService());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.paths, this.service);
    }

    public static class Builder {
        private List<String> paths;
        private String service;

        Builder() {
        }

        public Builder mergeFrom(PathRule other) {
            if (other == PathRule.getDefaultInstance()) {
                return this;
            }
            if (other.getPathsList() != null) {
                this.paths = other.paths;
            }
            if (other.getService() != null) {
                this.service = other.service;
            }
            return this;
        }

        Builder(PathRule source) {
            this.paths = source.paths;
            this.service = source.service;
        }

        public List<String> getPathsList() {
            return this.paths;
        }

        public Builder addAllPaths(List<String> paths) {
            if (this.paths == null) {
                this.paths = new LinkedList<String>();
            }
            this.paths.addAll(paths);
            return this;
        }

        public Builder addPaths(String paths) {
            if (this.paths == null) {
                this.paths = new LinkedList<String>();
            }
            this.paths.add(paths);
            return this;
        }

        public String getService() {
            return this.service;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public PathRule build() {
            return new PathRule(this.paths, this.service);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllPaths(this.paths);
            newBuilder.setService(this.service);
            return newBuilder;
        }
    }
}

