/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionSslCertificateHttpRequest;
import com.google.cloud.compute.v1.GetRegionSslCertificateHttpRequest;
import com.google.cloud.compute.v1.InsertRegionSslCertificateHttpRequest;
import com.google.cloud.compute.v1.ListRegionSslCertificatesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionSslCertificateClient;
import com.google.cloud.compute.v1.SslCertificate;
import com.google.cloud.compute.v1.SslCertificateList;
import com.google.cloud.compute.v1.stub.HttpJsonRegionSslCertificateStub;
import com.google.cloud.compute.v1.stub.RegionSslCertificateStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionSslCertificateStubSettings
extends StubSettings<RegionSslCertificateStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionSslCertificateHttpRequest, Operation> deleteRegionSslCertificateSettings;
    private final UnaryCallSettings<GetRegionSslCertificateHttpRequest, SslCertificate> getRegionSslCertificateSettings;
    private final UnaryCallSettings<InsertRegionSslCertificateHttpRequest, Operation> insertRegionSslCertificateSettings;
    private final PagedCallSettings<ListRegionSslCertificatesHttpRequest, SslCertificateList, RegionSslCertificateClient.ListRegionSslCertificatesPagedResponse> listRegionSslCertificatesSettings;
    private static final PagedListDescriptor<ListRegionSslCertificatesHttpRequest, SslCertificateList, SslCertificate> LIST_REGION_SSL_CERTIFICATES_PAGE_STR_DESC = new PagedListDescriptor<ListRegionSslCertificatesHttpRequest, SslCertificateList, SslCertificate>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionSslCertificatesHttpRequest injectToken(ListRegionSslCertificatesHttpRequest payload, String token) {
            return ListRegionSslCertificatesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionSslCertificatesHttpRequest injectPageSize(ListRegionSslCertificatesHttpRequest payload, int pageSize) {
            return ListRegionSslCertificatesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionSslCertificatesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SslCertificateList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SslCertificate> extractResources(SslCertificateList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionSslCertificatesHttpRequest, SslCertificateList, RegionSslCertificateClient.ListRegionSslCertificatesPagedResponse> LIST_REGION_SSL_CERTIFICATES_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionSslCertificatesHttpRequest, SslCertificateList, RegionSslCertificateClient.ListRegionSslCertificatesPagedResponse>(){

        public ApiFuture<RegionSslCertificateClient.ListRegionSslCertificatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionSslCertificatesHttpRequest, SslCertificateList> callable, ListRegionSslCertificatesHttpRequest request, ApiCallContext context, ApiFuture<SslCertificateList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_SSL_CERTIFICATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionSslCertificateClient.ListRegionSslCertificatesPagedResponse.createAsync((PageContext<ListRegionSslCertificatesHttpRequest, SslCertificateList, SslCertificate>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionSslCertificateHttpRequest, Operation> deleteRegionSslCertificateSettings() {
        return this.deleteRegionSslCertificateSettings;
    }

    public UnaryCallSettings<GetRegionSslCertificateHttpRequest, SslCertificate> getRegionSslCertificateSettings() {
        return this.getRegionSslCertificateSettings;
    }

    public UnaryCallSettings<InsertRegionSslCertificateHttpRequest, Operation> insertRegionSslCertificateSettings() {
        return this.insertRegionSslCertificateSettings;
    }

    public PagedCallSettings<ListRegionSslCertificatesHttpRequest, SslCertificateList, RegionSslCertificateClient.ListRegionSslCertificatesPagedResponse> listRegionSslCertificatesSettings() {
        return this.listRegionSslCertificatesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionSslCertificateStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionSslCertificateStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionSslCertificateStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionSslCertificateStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionSslCertificateStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionSslCertificateSettings = settingsBuilder.deleteRegionSslCertificateSettings().build();
        this.getRegionSslCertificateSettings = settingsBuilder.getRegionSslCertificateSettings().build();
        this.insertRegionSslCertificateSettings = settingsBuilder.insertRegionSslCertificateSettings().build();
        this.listRegionSslCertificatesSettings = settingsBuilder.listRegionSslCertificatesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionSslCertificateStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionSslCertificateHttpRequest, Operation> deleteRegionSslCertificateSettings;
        private final UnaryCallSettings.Builder<GetRegionSslCertificateHttpRequest, SslCertificate> getRegionSslCertificateSettings;
        private final UnaryCallSettings.Builder<InsertRegionSslCertificateHttpRequest, Operation> insertRegionSslCertificateSettings;
        private final PagedCallSettings.Builder<ListRegionSslCertificatesHttpRequest, SslCertificateList, RegionSslCertificateClient.ListRegionSslCertificatesPagedResponse> listRegionSslCertificatesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionSslCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionSslCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionSslCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionSslCertificatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_SSL_CERTIFICATES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionSslCertificateSettings, this.getRegionSslCertificateSettings, this.insertRegionSslCertificateSettings, this.listRegionSslCertificatesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionSslCertificateStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionSslCertificateStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionSslCertificateStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionSslCertificateStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionSslCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionSslCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionSslCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionSslCertificatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionSslCertificateStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionSslCertificateSettings = settings.deleteRegionSslCertificateSettings.toBuilder();
            this.getRegionSslCertificateSettings = settings.getRegionSslCertificateSettings.toBuilder();
            this.insertRegionSslCertificateSettings = settings.insertRegionSslCertificateSettings.toBuilder();
            this.listRegionSslCertificatesSettings = settings.listRegionSslCertificatesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionSslCertificateSettings, this.getRegionSslCertificateSettings, this.insertRegionSslCertificateSettings, this.listRegionSslCertificatesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionSslCertificateHttpRequest, Operation> deleteRegionSslCertificateSettings() {
            return this.deleteRegionSslCertificateSettings;
        }

        public UnaryCallSettings.Builder<GetRegionSslCertificateHttpRequest, SslCertificate> getRegionSslCertificateSettings() {
            return this.getRegionSslCertificateSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionSslCertificateHttpRequest, Operation> insertRegionSslCertificateSettings() {
            return this.insertRegionSslCertificateSettings;
        }

        public PagedCallSettings.Builder<ListRegionSslCertificatesHttpRequest, SslCertificateList, RegionSslCertificateClient.ListRegionSslCertificatesPagedResponse> listRegionSslCertificatesSettings() {
            return this.listRegionSslCertificatesSettings;
        }

        public RegionSslCertificateStubSettings build() throws IOException {
            return new RegionSslCertificateStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

