/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionTargetHttpProxyName
implements ResourceName {
    private final String project;
    private final String region;
    private final String targetHttpProxy;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionTargetHttpProxyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.targetHttpProxy = (String)Preconditions.checkNotNull((Object)builder.getTargetHttpProxy());
    }

    public static ProjectRegionTargetHttpProxyName of(String project, String region, String targetHttpProxy) {
        return ProjectRegionTargetHttpProxyName.newBuilder().setProject(project).setRegion(region).setTargetHttpProxy(targetHttpProxy).build();
    }

    public static String format(String project, String region, String targetHttpProxy) {
        return ProjectRegionTargetHttpProxyName.of(project, region, targetHttpProxy).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getTargetHttpProxy() {
        return this.targetHttpProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionTargetHttpProxyName projectRegionTargetHttpProxyName = this;
            synchronized (projectRegionTargetHttpProxyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"targetHttpProxy", (Object)this.targetHttpProxy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionTargetHttpProxyName> newFactory() {
        return new ResourceNameFactory<ProjectRegionTargetHttpProxyName>(){

            public ProjectRegionTargetHttpProxyName parse(String formattedString) {
                return ProjectRegionTargetHttpProxyName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionTargetHttpProxyName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionTargetHttpProxyName.parse: formattedString not in valid format");
        return ProjectRegionTargetHttpProxyName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("targetHttpProxy"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "targetHttpProxy", this.targetHttpProxy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionTargetHttpProxyName) {
            ProjectRegionTargetHttpProxyName that = (ProjectRegionTargetHttpProxyName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.targetHttpProxy, that.getTargetHttpProxy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.targetHttpProxy);
    }

    public static class Builder {
        private String project;
        private String region;
        private String targetHttpProxy;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getTargetHttpProxy() {
            return this.targetHttpProxy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setTargetHttpProxy(String targetHttpProxy) {
            this.targetHttpProxy = targetHttpProxy;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionTargetHttpProxyName projectRegionTargetHttpProxyName) {
            this.project = projectRegionTargetHttpProxyName.project;
            this.region = projectRegionTargetHttpProxyName.region;
            this.targetHttpProxy = projectRegionTargetHttpProxyName.targetHttpProxy;
        }

        public ProjectRegionTargetHttpProxyName build() {
            return new ProjectRegionTargetHttpProxyName(this);
        }
    }
}

